/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchsupport.jobs.config.AbstractJobConfigFactory;
import com.floragunn.searchsupport.jobs.config.DefaultJobConfig;
import com.floragunn.searchsupport.jobs.config.JobConfigFactory;
import org.quartz.Job;
import org.quartz.JobKey;

public class DefaultJobConfigFactory
extends AbstractJobConfigFactory<DefaultJobConfig>
implements JobConfigFactory<DefaultJobConfig> {
    public DefaultJobConfigFactory(Class<? extends Job> jobClass) {
        super(jobClass);
    }

    protected DefaultJobConfig createObject(String id, DocNode jsonNode) {
        return new DefaultJobConfig(this.getJobClass(jsonNode));
    }

    @Override
    protected DefaultJobConfig createFromJsonNode(String id, DocNode jsonNode, long version) throws ConfigValidationException {
        DefaultJobConfig result = this.createObject(id, jsonNode);
        JobKey jobKey = this.getJobKey(id, jsonNode);
        result.setJobKey(jobKey);
        result.setDescription(this.getDescription(jsonNode));
        Boolean durability = this.getDurability(jsonNode);
        if (durability != null) {
            result.setDurable(durability);
        }
        result.setJobDataMap(this.getJobDataMap(jsonNode));
        result.setTriggers(this.getTriggers(jobKey, jsonNode));
        result.setVersion(version);
        result.setAuthToken(this.getAuthToken(jsonNode));
        return result;
    }
}

