/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.execution;

import com.floragunn.searchsupport.jobs.config.JobConfig;
import com.floragunn.searchsupport.jobs.config.JobDetailWithBaseConfig;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class AuthorizingJobDecorator
implements Job {
    private final Job delegate;
    private final String authToken;
    private final ThreadContext threadContext;
    private final String authTokenAudience;

    AuthorizingJobDecorator(Job delegate, String authToken, String authTokenAudience, ThreadContext threadContext) {
        this.delegate = delegate;
        this.authToken = authToken;
        this.threadContext = threadContext;
        this.authTokenAudience = authTokenAudience;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try (ThreadContext.StoredContext ctx = this.threadContext.stashContext();){
            this.threadContext.putHeader("_sg_internal_auth_token", this.authToken);
            this.threadContext.putHeader("_sg_internal_auth_token_audience", this.authTokenAudience);
            this.delegate.execute(context);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static class DecoratingJobFactory
    implements JobFactory {
        private final ThreadContext threadContext;
        private final JobFactory delegate;

        public DecoratingJobFactory(ThreadContext threadContext, JobFactory delegate) {
            this.threadContext = threadContext;
            this.delegate = delegate;
        }

        public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
            Job job = this.delegate.newJob(bundle, scheduler);
            JobConfig jobConfig = this.getConfig(bundle);
            String authToken = jobConfig.getAuthToken();
            String authTokenAudience = jobConfig.getSecureAuthTokenAudience();
            if (authToken != null && authTokenAudience != null) {
                return new AuthorizingJobDecorator(job, authToken, authTokenAudience, this.threadContext);
            }
            return job;
        }

        private JobConfig getConfig(TriggerFiredBundle bundle) {
            return ((JobDetailWithBaseConfig)bundle.getJobDetail()).getBaseConfig(JobConfig.class);
        }
    }
}

