/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import com.google.code.regexp.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.util.Preconditions;

public class StringUtil {
    public static String nStrings(int n, String str) {
        return new String(new char[n]).replace("\u0000", str);
    }

    @NotNull
    public static String replaceNestedTokens(String lineWithTokens, int nestingDepth, String tokenOpen, String tokenClose, String tokenRegexToReplace, StringFormatter tokenReplacer) {
        com.google.code.regexp.Pattern startsWithOpen = com.google.code.regexp.Pattern.compile((String)Pattern.quote(tokenOpen));
        com.google.code.regexp.Pattern startsWithClose = com.google.code.regexp.Pattern.compile((String)Pattern.quote(tokenClose));
        com.google.code.regexp.Pattern startsWithTokenToReplace = com.google.code.regexp.Pattern.compile((String)String.format("(?<token>%s)", tokenRegexToReplace));
        StringBuilder lineWithTokensReplaced = new StringBuilder();
        int countOpenTokens = 0;
        int pos = 0;
        while (pos < lineWithTokens.length()) {
            String remainingLine = lineWithTokens.substring(pos);
            if (startsWithOpen.matcher((CharSequence)remainingLine).lookingAt()) {
                ++countOpenTokens;
                lineWithTokensReplaced.append(tokenOpen);
                pos += tokenOpen.length();
            } else if (startsWithClose.matcher((CharSequence)remainingLine).lookingAt()) {
                --countOpenTokens;
                lineWithTokensReplaced.append(tokenClose);
                pos += tokenClose.length();
            } else if (countOpenTokens == nestingDepth) {
                Matcher startsWithTokenMatcher = startsWithTokenToReplace.matcher((CharSequence)remainingLine);
                if (startsWithTokenMatcher.lookingAt()) {
                    String matchedToken = startsWithTokenMatcher.group("token");
                    lineWithTokensReplaced.append(tokenReplacer.apply(matchedToken));
                    pos += matchedToken.length();
                } else {
                    lineWithTokensReplaced.append(lineWithTokens.charAt(pos++));
                }
            } else {
                lineWithTokensReplaced.append(lineWithTokens.charAt(pos++));
            }
            Preconditions.assumeTrue(countOpenTokens >= 0, "Unbalanced token sets: closed token without open token\n\t" + lineWithTokens);
        }
        Preconditions.assumeTrue(countOpenTokens == 0, "Unbalanced token sets: open token without closed token\n\t" + lineWithTokens);
        return lineWithTokensReplaced.toString();
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static class StringFormatter {
        private final String formatPattern;

        public static StringFormatter formatterForPattern(@NotNull String pattern) {
            return new StringFormatter(pattern);
        }

        private StringFormatter(String formatPattern) {
            this.formatPattern = formatPattern;
        }

        String apply(String input) {
            return String.format(this.formatPattern, input);
        }
    }
}

