/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.queries;

import com.floragunn.fluent.collections.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Predicate;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.regex.Regex;

public class WildcardExpressionResolver {
    public static Map<String, IndexAbstraction> matches(Metadata metadata, SortedMap<String, IndexAbstraction> indicesLookup, String expression, IndicesOptions options, boolean includeDataStreams) {
        if (Regex.isMatchAllPattern((String)expression)) {
            return WildcardExpressionResolver.filterIndicesLookup(metadata, indicesLookup, expression, null, options, includeDataStreams);
        }
        if (expression.indexOf("*") == expression.length() - 1) {
            return WildcardExpressionResolver.suffixWildcard(metadata, indicesLookup, expression, options, includeDataStreams);
        }
        return WildcardExpressionResolver.otherWildcard(metadata, indicesLookup, expression, options, includeDataStreams);
    }

    public static List<String> resolveEmptyOrTrivialWildcard(IndicesOptions options, Metadata metadata) {
        if (options.expandWildcardsOpen() && options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
            return Arrays.asList(metadata.getConcreteAllIndices());
        }
        if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
            return Arrays.asList(metadata.getConcreteVisibleIndices());
        }
        if (options.expandWildcardsOpen() && options.expandWildcardsHidden()) {
            return Arrays.asList(metadata.getConcreteAllOpenIndices());
        }
        if (options.expandWildcardsOpen()) {
            return Arrays.asList(metadata.getConcreteVisibleOpenIndices());
        }
        if (options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
            return Arrays.asList(metadata.getConcreteAllClosedIndices());
        }
        if (options.expandWildcardsClosed()) {
            return Arrays.asList(metadata.getConcreteVisibleClosedIndices());
        }
        return Collections.emptyList();
    }

    public static boolean isEmptyOrTrivialWildcard(List<String> expressions) {
        return expressions.isEmpty() || expressions.size() == 1 && ("_all".equals(expressions.get(0)) || Regex.isMatchAllPattern((String)expressions.get(0)));
    }

    private static Map<String, IndexAbstraction> suffixWildcard(Metadata metadata, SortedMap<String, IndexAbstraction> indicesLookup, String expression, IndicesOptions options, boolean includeDataStreams) {
        String fromPrefix = expression.substring(0, expression.length() - 1);
        char[] toPrefixCharArr = fromPrefix.toCharArray();
        int n = toPrefixCharArr.length - 1;
        toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
        String toPrefix = new String(toPrefixCharArr);
        SortedMap<String, IndexAbstraction> subMap = indicesLookup.subMap(fromPrefix, toPrefix);
        return WildcardExpressionResolver.filterIndicesLookup(metadata, subMap, expression, null, options, includeDataStreams);
    }

    private static Map<String, IndexAbstraction> otherWildcard(Metadata metadata, SortedMap<String, IndexAbstraction> indicesLookup, String expression, IndicesOptions options, boolean includeDataStreams) {
        String pattern = expression;
        return WildcardExpressionResolver.filterIndicesLookup(metadata, indicesLookup, expression, e -> Regex.simpleMatch((String)pattern, (String)((String)e.getKey())), options, includeDataStreams);
    }

    private static Map<String, IndexAbstraction> filterIndicesLookup(Metadata metadata, SortedMap<String, IndexAbstraction> indicesLookup, String expression, Predicate<? super Map.Entry<String, IndexAbstraction>> filter, IndicesOptions options, boolean includeDataStreams) {
        IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(options);
        if (!options.ignoreAliases() && includeDataStreams && filter == null && options.expandWildcardsHidden() && excludeState == null) {
            return indicesLookup;
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder();
        for (Map.Entry<String, IndexAbstraction> entry : indicesLookup.entrySet()) {
            IndexMetadata indexMetadata;
            IndexAbstraction.Type type = entry.getValue().getType();
            if (options.ignoreAliases() && type == IndexAbstraction.Type.ALIAS || !includeDataStreams && type == IndexAbstraction.Type.DATA_STREAM || !options.expandWildcardsHidden() && entry.getValue().isHidden() && !WildcardExpressionResolver.implicitHiddenMatch(entry.getKey(), expression) || filter != null && !filter.test(entry) || excludeState != null && type == IndexAbstraction.Type.CONCRETE_INDEX && (indexMetadata = metadata.index(entry.getKey())) != null && excludeState == indexMetadata.getState()) continue;
            result.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return result.build();
    }

    public static IndexMetadata.State excludeState(IndicesOptions options) {
        Object excludeState = options.expandWildcardsOpen() && options.expandWildcardsClosed() ? null : (options.expandWildcardsOpen() && !options.expandWildcardsClosed() ? IndexMetadata.State.CLOSE : (options.expandWildcardsClosed() && !options.expandWildcardsOpen() ? IndexMetadata.State.OPEN : null));
        return excludeState;
    }

    public static Predicate<Boolean> excludeStatePredicate(IndicesOptions options) {
        IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(options);
        if (excludeState == IndexMetadata.State.OPEN) {
            return b -> b == true;
        }
        if (excludeState == IndexMetadata.State.CLOSE) {
            return b -> b == false;
        }
        return null;
    }

    private static boolean implicitHiddenMatch(String itemName, String expression) {
        return itemName.startsWith(".") && expression.startsWith(".") && Regex.isSimpleMatchPattern((String)expression);
    }
}

