/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.user.User;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;

public class TenantManager {
    private static final String USER_TENANT = "__user__";
    private final ImmutableSet<String> configuredTenants;
    private final MultiTenancyConfigurationProvider multiTenancyConfigurationProvider;

    public TenantManager(Set<String> tenantNames, MultiTenancyConfigurationProvider multiTenancyConfigurationProvider) {
        this.configuredTenants = ImmutableSet.of(tenantNames);
        this.multiTenancyConfigurationProvider = Objects.requireNonNull(multiTenancyConfigurationProvider, "Multi Tenancy Configuration Provider is required");
    }

    public boolean isTenantHeaderValid(String tenant) {
        if (this.multiTenancyConfigurationProvider.isMultiTenancyEnabled()) {
            return "SGS_GLOBAL_TENANT".equals(tenant) && this.multiTenancyConfigurationProvider.isGlobalTenantEnabled() || USER_TENANT.equals(tenant) && this.multiTenancyConfigurationProvider.isPrivateTenantEnabled() || !ImmutableSet.of((Object)"SGS_GLOBAL_TENANT", (Object)USER_TENANT).contains((Object)tenant) && this.configuredTenants.contains((Object)tenant);
        }
        return "SGS_GLOBAL_TENANT".equals(tenant);
    }

    public boolean isUserTenantHeader(String tenant) {
        return USER_TENANT.equals(tenant);
    }

    public boolean isGlobalTenantHeader(String tenant) {
        return "SGS_GLOBAL_TENANT".equals(tenant);
    }

    public boolean isTenantHeaderEmpty(String tenant) {
        return tenant == null || tenant.isEmpty();
    }

    public String toInternalTenantName(User user) {
        String requestedTenant = user.getRequestedTenant();
        if (this.isUserTenantHeader(requestedTenant)) {
            return TenantManager.toInternalTenantName(user.getName());
        }
        return TenantManager.toInternalTenantName(requestedTenant);
    }

    public ImmutableSet<String> getConfiguredTenantNames() {
        return this.configuredTenants;
    }

    public ImmutableSet<String> getAllKnownTenantNames() {
        return this.configuredTenants.with((Object)"SGS_GLOBAL_TENANT");
    }

    public static String toInternalTenantName(String tenant) {
        if (tenant == null) {
            throw new ElasticsearchException("tenant must not be null here", new Object[0]);
        }
        String tenantWithoutUnwantedChars = tenant.toLowerCase().replaceAll("[^a-z0-9]+", "");
        return String.format("%d_%s", tenant.hashCode(), tenantWithoutUnwantedChars);
    }
}

