/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.auth;

import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class HTTPProxyAuthenticator
implements LegacyHTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "proxy", HTTPProxyAuthenticator.class).initialized();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "proxy";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPProxyAuthenticator::new);
        }
    };

    public HTTPProxyAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) {
        if (context.getTransient("_sg_xff_done") != Boolean.TRUE) {
            throw new ElasticsearchSecurityException("xff not done", new Object[0]);
        }
        String userHeader = this.settings.get("user_header");
        String rolesHeader = this.settings.get("roles_header");
        String rolesSeparator = this.settings.get("roles_separator", ",");
        if (this.log.isDebugEnabled()) {
            this.log.debug("headers {}", (Object)request.getHeaders());
            this.log.debug("userHeader {}, value {}", (Object)userHeader, userHeader == null ? null : request.header(userHeader));
            this.log.debug("rolesHeader {}, value {}", (Object)rolesHeader, rolesHeader == null ? null : request.header(rolesHeader));
        }
        if (!Strings.isNullOrEmpty((String)userHeader) && !Strings.isNullOrEmpty((String)request.header(userHeader))) {
            String[] backendRoles = null;
            if (!Strings.isNullOrEmpty((String)rolesHeader) && !Strings.isNullOrEmpty((String)request.header(rolesHeader))) {
                backendRoles = request.header(rolesHeader).split(rolesSeparator);
            }
            return AuthCredentials.forUser((String)request.header(userHeader)).authenticatorType(this.getType()).backendRoles(backendRoles).complete().build();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("No '{}' header, send 401", (Object)userHeader);
        }
        return null;
    }

    public String getType() {
        return "proxy";
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

