/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.saml;

import java.util.HashMap;
import java.util.Map;

public class SamlNameIdFormat {
    private static Map<String, SamlNameIdFormat> KNOWN_NAME_ID_FORMATS_BY_URI = new HashMap<String, SamlNameIdFormat>();
    private static Map<String, SamlNameIdFormat> KNOWN_NAME_ID_FORMATS_BY_SHORT_NAME = new HashMap<String, SamlNameIdFormat>();
    private final String uri;
    private final String shortName;

    SamlNameIdFormat(String uri, String shortName) {
        this.uri = uri;
        this.shortName = shortName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static SamlNameIdFormat getByUri(String uri) {
        SamlNameIdFormat samlNameIdFormat = KNOWN_NAME_ID_FORMATS_BY_URI.get(uri);
        if (samlNameIdFormat == null) {
            samlNameIdFormat = new SamlNameIdFormat(uri, uri);
        }
        return samlNameIdFormat;
    }

    static SamlNameIdFormat getByShortName(String shortNameOrUri) {
        SamlNameIdFormat samlNameIdFormat = KNOWN_NAME_ID_FORMATS_BY_SHORT_NAME.get(shortNameOrUri);
        if (samlNameIdFormat == null) {
            samlNameIdFormat = new SamlNameIdFormat(shortNameOrUri, shortNameOrUri);
        }
        return samlNameIdFormat;
    }

    private static void add(String uri, String shortName) {
        SamlNameIdFormat samlNameIdFormat = new SamlNameIdFormat(uri, shortName);
        KNOWN_NAME_ID_FORMATS_BY_URI.put(uri, samlNameIdFormat);
        KNOWN_NAME_ID_FORMATS_BY_SHORT_NAME.put(shortName, samlNameIdFormat);
    }

    static {
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "u");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "email");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "sn");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", "ker");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:2.0:nameid-format:entity", "ent");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "p");
        SamlNameIdFormat.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "t");
    }
}

