/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.config.templates.PipeExpression;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.fluent.collections.ImmutableMap;
import java.util.Optional;

@FunctionalInterface
public interface Parser<T, C extends Context> {
    public T parse(DocNode var1, C var2) throws ConfigValidationException;

    public static interface Context {
        public static final Basic DEFAULT = new Basic(null, false, false, null);

        public VariableResolvers variableResolvers();

        default public boolean isLenientValidationRequested() {
            return false;
        }

        default public boolean isExternalResourceCreationEnabled() {
            return false;
        }

        default public ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctions() {
            return PipeExpression.PipeFunction.all();
        }

        public static Basic get() {
            return DEFAULT;
        }

        public static Basic lenient() {
            return new Basic(null, true, false, (ImmutableMap<String, PipeExpression.PipeFunction>)ImmutableMap.empty());
        }

        public static Basic withExternalResources() {
            return new Basic(null, false, true, (ImmutableMap<String, PipeExpression.PipeFunction>)ImmutableMap.empty());
        }

        public static Basic variableResolvers(VariableResolvers variableResolvers) {
            return new Basic(variableResolvers, false, false, (ImmutableMap<String, PipeExpression.PipeFunction>)ImmutableMap.empty());
        }

        public static class Basic
        implements Context {
            private final VariableResolvers variableResolvers;
            private final boolean lenientValidationRequested;
            private final boolean externalResourceCreationEnabled;
            private final ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap;

            Basic(VariableResolvers variableResolvers, boolean lenientValidationRequested, boolean externalResourceCreationEnabled, ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap) {
                this.variableResolvers = variableResolvers;
                this.lenientValidationRequested = lenientValidationRequested;
                this.externalResourceCreationEnabled = externalResourceCreationEnabled;
                this.pipeFunctionsMap = pipeFunctionsMap == null ? PipeExpression.PipeFunction.all() : pipeFunctionsMap;
            }

            @Override
            public VariableResolvers variableResolvers() {
                return this.variableResolvers;
            }

            @Override
            public Basic variableResolvers(VariableResolvers variableResolvers) {
                return new Basic(variableResolvers, this.lenientValidationRequested, this.externalResourceCreationEnabled, this.pipeFunctionsMap);
            }

            @Override
            public boolean isLenientValidationRequested() {
                return this.lenientValidationRequested;
            }

            @Override
            public Basic lenient() {
                return new Basic(this.variableResolvers, true, this.externalResourceCreationEnabled, this.pipeFunctionsMap);
            }

            @Override
            public boolean isExternalResourceCreationEnabled() {
                return this.externalResourceCreationEnabled;
            }

            @Override
            public Basic withExternalResources() {
                return new Basic(this.variableResolvers, this.lenientValidationRequested, true, this.pipeFunctionsMap);
            }

            public Basic withPipeFunctions(ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctionsMap) {
                return new Basic(this.variableResolvers, this.lenientValidationRequested, this.externalResourceCreationEnabled, pipeFunctionsMap);
            }

            @Override
            public ImmutableMap<String, PipeExpression.PipeFunction> pipeFunctions() {
                return this.pipeFunctionsMap;
            }
        }
    }

    @FunctionalInterface
    public static interface WithDefault<T, C extends Context> {
        public T parse(DocNode var1, C var2, Optional<T> var3) throws ConfigValidationException;
    }

    @FunctionalInterface
    public static interface ReturningValidationResult<T, C extends Context> {
        public ValidationResult<T> parse(DocNode var1, C var2);
    }
}

