/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.enterprise.femt.KibanaActionsProvider;
import com.floragunn.searchguard.enterprise.femt.TenantAuthorization;
import com.floragunn.searchguard.user.User;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeMultiTenancyTenantAccessMapper
implements TenantAccessMapper {
    private static final Logger log = LogManager.getLogger(FeMultiTenancyTenantAccessMapper.class);
    private final TenantManager tenantManager;
    private final TenantAuthorization tenantAuthorization;
    private final Actions actions;

    public FeMultiTenancyTenantAccessMapper(TenantManager tenantManager, TenantAuthorization tenantAuthorization, Actions actions) {
        this.tenantManager = tenantManager;
        this.tenantAuthorization = tenantAuthorization;
        this.actions = actions;
    }

    public Map<String, Boolean> mapTenantsAccess(User user, boolean adminUser, Set<String> roles) {
        if (user == null) {
            return ImmutableMap.empty();
        }
        ImmutableMap.Builder result = new ImmutableMap.Builder(roles.size());
        result.put((Object)user.getName(), (Object)true);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, adminUser, ImmutableSet.of(roles), null, null, false, null, null);
        for (String tenant : this.tenantManager.getAllKnownTenantNames()) {
            try {
                boolean hasReadPermission = this.tenantAuthorization.hasTenantPermission(context, KibanaActionsProvider.getKibanaReadAction(this.actions), tenant).isOk();
                boolean hasWritePermission = this.tenantAuthorization.hasTenantPermission(context, KibanaActionsProvider.getKibanaWriteAction(this.actions), tenant).isOk();
                if (hasWritePermission) {
                    result.put((Object)tenant, (Object)true);
                    continue;
                }
                if (!hasReadPermission) continue;
                result.put((Object)tenant, (Object)false);
            }
            catch (PrivilegesEvaluationException e) {
                log.error("Error while evaluating privileges for " + user + " " + tenant, (Throwable)e);
            }
        }
        if (!this.tenantManager.isTenantHeaderValid("SGS_GLOBAL_TENANT")) {
            result.remove((Object)"SGS_GLOBAL_TENANT");
        }
        if (!this.tenantManager.isTenantHeaderValid("__user__")) {
            result.remove((Object)user.getName());
        }
        return result.build();
    }
}

