/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.settings.update;

import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.settings.update.SettingsUpdateRequest;
import com.floragunn.signals.actions.settings.update.SettingsUpdateResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportSettingsUpdateAction
extends TransportNodesAction<SettingsUpdateRequest, SettingsUpdateResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportSettingsUpdateAction.class);
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportSettingsUpdateAction(Signals signals, Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:settings/update", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    protected SettingsUpdateResponse newResponse(SettingsUpdateRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new SettingsUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        this.threadPool.generic().execute(() -> {
            try {
                this.signals.getSignalsSettings().refresh(this.client);
            }
            catch (Exception e) {
                log.error("Error while updating settings", (Throwable)e);
            }
        });
        return new NodeResponse(localNode, NodeResponse.Status.SUCCESS, "");
    }

    protected NodeRequest newNodeRequest(SettingsUpdateRequest request) {
        return new NodeRequest(request);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private Status status;
        private String message;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.status = (Status)in.readEnum(Status.class);
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node, Status status, String message) {
            super(node);
            this.status = status;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public Status getStatus() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.message);
        }

        public String toString() {
            return "NodeResponse [status=" + this.status + ", message=" + this.message + "]";
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public static enum Status {
            SUCCESS,
            EXCEPTION;

        }
    }

    public static class NodeRequest
    extends TransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest(SettingsUpdateRequest request) {
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

