/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.settings;

import com.floragunn.codova.config.temporal.ConstantDurationExpression;
import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.signals.SignalsInitializationException;
import com.floragunn.signals.actions.settings.update.SettingsUpdateAction;
import com.floragunn.signals.support.LuckySisyphos;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SignalsSettings {
    private static final Logger log = LogManager.getLogger(SignalsSettings.class);
    private final DynamicSettings dynamicSettings;
    private final SignalsStaticSettings staticSettings;

    public SignalsSettings(Settings staticSettings) {
        this.staticSettings = new SignalsStaticSettings(staticSettings);
        this.dynamicSettings = new DynamicSettings(this.staticSettings.getIndexNames().getSettings(), this.staticSettings);
    }

    public DurationExpression getDefaultThrottlePeriod() {
        return this.dynamicSettings.getDefaultThrottlePeriod();
    }

    public DurationExpression getThrottlePeriodLowerBound() {
        return this.dynamicSettings.getThrottlePeriodLowerBound();
    }

    public Tenant getTenant(String tenant) {
        return this.dynamicSettings.getTenant(tenant);
    }

    public boolean isIncludeNodeInWatchLogEnabled() {
        return this.dynamicSettings.isIncludeNodeInWatchLogEnabled();
    }

    public void refresh(Client client) throws SignalsInitializationException {
        this.dynamicSettings.refresh(client);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.dynamicSettings.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.dynamicSettings.removeChangeListener(changeListener);
    }

    public void update(Client client, String key, Object value) throws ConfigValidationException {
        this.dynamicSettings.update(client, key, value);
    }

    public DynamicSettings getDynamicSettings() {
        return this.dynamicSettings;
    }

    public SignalsStaticSettings getStaticSettings() {
        return this.staticSettings;
    }

    public static class SignalsStaticSettings {
        public static StaticSettings.Attribute<Boolean> ENABLED = StaticSettings.Attribute.define((String)"signals.enabled").withDefault(true).asBoolean();
        public static StaticSettings.Attribute<Boolean> ENTERPRISE_ENABLED = StaticSettings.Attribute.define((String)"signals.enterprise.enabled").withDefault(true).asBoolean();
        public static StaticSettings.Attribute<Integer> MAX_THREADS = StaticSettings.Attribute.define((String)"signals.worker_threads.pool.max_size").withDefault(5).asInteger();
        public static StaticSettings.Attribute<TimeValue> THREAD_KEEP_ALIVE = StaticSettings.Attribute.define((String)"signals.worker_threads.pool.keep_alive").withDefault(TimeValue.timeValueMinutes((long)100L)).asTimeValue();
        public static StaticSettings.Attribute<Integer> THREAD_PRIO = StaticSettings.Attribute.define((String)"signals.worker_threads.prio").withDefault(5).asInteger();
        public static StaticSettings.Attribute<Boolean> ACTIVE_BY_DEFAULT = StaticSettings.Attribute.define((String)"signals.all_tenants_active_by_default").withDefault(true).asBoolean();
        public static StaticSettings.Attribute<String> WATCH_LOG_REFRESH_POLICY = StaticSettings.Attribute.define((String)"signals.watch_log.refresh_policy").withDefault((String)null).asString();
        public static StaticSettings.Attribute<Boolean> WATCH_LOG_SYNC_INDEXING = StaticSettings.Attribute.define((String)"signals.watch_log.sync_indexing").withDefault(false).asBoolean();
        public static StaticSettings.Attribute<Integer> WATCH_LOG_MAPPING_TOTAL_FIELDS_LIMIT = StaticSettings.Attribute.define((String)"signals.watch_log.mapping_total_fields_limit").withDefault(1000).asInteger();
        private final StaticSettings settings;
        private final IndexNames indexNames;

        public static StaticSettings.AttributeSet getAvailableSettings() {
            return StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{ENABLED, ENTERPRISE_ENABLED, MAX_THREADS, THREAD_KEEP_ALIVE, THREAD_PRIO, ACTIVE_BY_DEFAULT, WATCH_LOG_REFRESH_POLICY, WATCH_LOG_SYNC_INDEXING, WATCH_LOG_MAPPING_TOTAL_FIELDS_LIMIT, IndexNames.WATCHES, IndexNames.WATCHES_STATE, IndexNames.WATCHES_TRIGGER_STATE, IndexNames.ACCOUNTS, IndexNames.LOG});
        }

        public SignalsStaticSettings(Settings settings) {
            this.settings = new StaticSettings(settings, null);
            this.indexNames = new IndexNames(settings);
        }

        public boolean isEnabled() {
            return (Boolean)this.settings.get(ENABLED);
        }

        public int getMaxThreads() {
            return (Integer)this.settings.get(MAX_THREADS);
        }

        public Duration getThreadKeepAlive() {
            return Duration.ofMillis(((TimeValue)this.settings.get(THREAD_KEEP_ALIVE)).millis());
        }

        public int getThreadPrio() {
            return (Integer)this.settings.get(THREAD_PRIO);
        }

        public boolean isEnterpriseEnabled() {
            return (Boolean)this.settings.get(ENTERPRISE_ENABLED);
        }

        public IndexNames getIndexNames() {
            return this.indexNames;
        }

        public Settings getSettings() {
            return this.settings.getPlatformSettings();
        }

        public boolean isActiveByDefault() {
            return (Boolean)this.settings.get(ACTIVE_BY_DEFAULT);
        }

        public WriteRequest.RefreshPolicy getWatchLogRefreshPolicy() {
            String value = (String)this.settings.get(WATCH_LOG_REFRESH_POLICY);
            if (value == null) {
                return WriteRequest.RefreshPolicy.NONE;
            }
            if ("immediate".equalsIgnoreCase(value)) {
                return WriteRequest.RefreshPolicy.IMMEDIATE;
            }
            return WriteRequest.RefreshPolicy.NONE;
        }

        public boolean isWatchLogSyncIndexingEnabled() {
            return (Boolean)this.settings.get(WATCH_LOG_SYNC_INDEXING);
        }

        public int getWatchLogMappingTotalFieldsLimit() {
            return (Integer)this.settings.get(WATCH_LOG_MAPPING_TOTAL_FIELDS_LIMIT);
        }

        public static class IndexNames {
            public static final String TRUSTSTORES = ".signals_truststores";
            public static final String PROXIES = ".signals_proxies";
            public static StaticSettings.Attribute<String> WATCHES = StaticSettings.Attribute.define((String)"signals.index_names.watches").withDefault(".signals_watches").asString();
            public static StaticSettings.Attribute<String> WATCHES_STATE = StaticSettings.Attribute.define((String)"signals.index_names.watches_state").withDefault(".signals_watches_state").asString();
            public static StaticSettings.Attribute<String> WATCHES_TRIGGER_STATE = StaticSettings.Attribute.define((String)"signals.index_names.watches_trigger_state").withDefault(".signals_watches_trigger_state").asString();
            public static StaticSettings.Attribute<String> ACCOUNTS = StaticSettings.Attribute.define((String)"signals.index_names.accounts").withDefault(".signals_accounts").asString();
            public static StaticSettings.Attribute<String> SETTINGS = StaticSettings.Attribute.define((String)"signals.index_names.settings").withDefault(".signals_settings").asString();
            public static StaticSettings.Attribute<String> LOG = StaticSettings.Attribute.define((String)"signals.index_names.log").withDefault("<.signals_log_{now/d}>").asString();
            private final StaticSettings settings;

            public IndexNames(Settings settings) {
                this.settings = new StaticSettings(settings, null);
            }

            public String getWatches() {
                return (String)this.settings.get(WATCHES);
            }

            public String getWatchesState() {
                return (String)this.settings.get(WATCHES_STATE);
            }

            public String getWatchesTriggerState() {
                return (String)this.settings.get(WATCHES_TRIGGER_STATE);
            }

            public String getLog() {
                return (String)this.settings.get(LOG);
            }

            public String getAccounts() {
                return (String)this.settings.get(ACCOUNTS);
            }

            public String getSettings() {
                return (String)this.settings.get(SETTINGS);
            }
        }
    }

    public static class DynamicSettings {
        public static final Setting<Boolean> ACTIVE = Setting.boolSetting((String)"active", (boolean)Boolean.TRUE, (Setting.Property[])new Setting.Property[0]);
        public static Setting<String> DEFAULT_THROTTLE_PERIOD = Setting.simpleString((String)"execution.default_throttle_period", (String)"10s", (Setting.Property[])new Setting.Property[0]);
        public static Setting<String> THROTTLE_PERIOD_LOWER_BOUND = Setting.simpleString((String)"execution.throttle_period_lower_bound", (Setting.Property[])new Setting.Property[0]);
        public static Setting<Boolean> INCLUDE_NODE_IN_WATCHLOG = Setting.boolSetting((String)"watch_log.include_node", (boolean)Boolean.TRUE, (Setting.Property[])new Setting.Property[0]);
        public static Setting<String> WATCH_LOG_INDEX = Setting.simpleString((String)"watch_log.index", (Setting.Property[])new Setting.Property[0]);
        public static Setting<Settings> TENANT = Setting.groupSetting((String)"tenant.", (Setting.Property[])new Setting.Property[0]);
        public static Setting<String> INTERNAL_AUTH_TOKEN_SIGNING_KEY = Setting.simpleString((String)"internal_auth.token_signing_key", (Setting.Property[])new Setting.Property[0]);
        public static Setting<String> INTERNAL_AUTH_TOKEN_ENCRYPTION_KEY = Setting.simpleString((String)"internal_auth.token_encryption_key", (Setting.Property[])new Setting.Property[0]);
        public static Setting<List<String>> ALLOWED_HTTP_ENDPOINTS = Setting.listSetting((String)"http.allowed_endpoints", Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> HTTP_PROXY = Setting.simpleString((String)"http.proxy", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> NODE_FILTER = Setting.simpleString((String)"node_filter", (Setting.Property[])new Setting.Property[0]);
        public static final Setting<String> FRONTEND_BASE_URL = Setting.simpleString((String)"frontend_base_url", (Setting.Property[])new Setting.Property[0]);
        private final String indexName;
        private final SignalsStaticSettings staticSettings;
        private volatile Settings settings = Settings.builder().build();
        private volatile DurationExpression defaultThrottlePeriod;
        private volatile DurationExpression throttlePeriodLowerBound;
        private Collection<ChangeListener> changeListeners = Collections.newSetFromMap(new ConcurrentHashMap());

        DynamicSettings(String indexName, SignalsStaticSettings staticSettings) {
            this.indexName = indexName;
            this.staticSettings = staticSettings;
        }

        public boolean isActive() {
            return (Boolean)ACTIVE.get(this.settings);
        }

        DurationExpression getDefaultThrottlePeriod() {
            return this.defaultThrottlePeriod;
        }

        DurationExpression getThrottlePeriodLowerBound() {
            return this.throttlePeriodLowerBound;
        }

        boolean isIncludeNodeInWatchLogEnabled() {
            return (Boolean)INCLUDE_NODE_IN_WATCHLOG.get(this.settings);
        }

        public String getInternalAuthTokenSigningKey() {
            String result = (String)INTERNAL_AUTH_TOKEN_SIGNING_KEY.get(this.settings);
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }

        String getNodeFilter() {
            return (String)NODE_FILTER.get(this.settings);
        }

        public String getFrontendBaseUrl() {
            return (String)FRONTEND_BASE_URL.get(this.settings);
        }

        public String getInternalAuthTokenEncryptionKey() {
            String result = (String)INTERNAL_AUTH_TOKEN_ENCRYPTION_KEY.get(this.settings);
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }

        public String getWatchLogIndex() {
            String result = (String)WATCH_LOG_INDEX.get(this.settings);
            if (result == null || result.length() == 0) {
                result = this.staticSettings.getIndexNames().getLog();
            }
            return result;
        }

        public List<String> getAllowedHttpEndpoints() {
            return (List)ALLOWED_HTTP_ENDPOINTS.get(this.settings);
        }

        public HttpProxyConfig getHttpProxyConfig() {
            String proxy = (String)HTTP_PROXY.get(this.settings);
            if (proxy == null || proxy.length() == 0) {
                return null;
            }
            try {
                return HttpProxyConfig.create(proxy);
            }
            catch (ConfigValidationException e) {
                log.error("Invalid proxy config " + proxy, (Throwable)e);
                return null;
            }
        }

        Tenant getTenant(String name) {
            return new Tenant(this.settings.getAsSettings("tenant." + name), this);
        }

        void addChangeListener(ChangeListener changeListener) {
            this.changeListeners.add(changeListener);
        }

        void removeChangeListener(ChangeListener changeListener) {
            this.changeListeners.remove(changeListener);
        }

        private void initDefaultThrottlePeriod() {
            try {
                this.defaultThrottlePeriod = DurationExpression.parse((String)((String)DEFAULT_THROTTLE_PERIOD.get(this.settings)));
            }
            catch (Exception e) {
                log.error("Error parsing signals.execution.default_throttle_period: " + (String)DEFAULT_THROTTLE_PERIOD.get(this.settings), (Throwable)e);
                this.defaultThrottlePeriod = new ConstantDurationExpression(Duration.ofSeconds(10L));
            }
        }

        private void initThrottlePeriodLowerBound() {
            if (THROTTLE_PERIOD_LOWER_BOUND.exists(this.settings)) {
                try {
                    this.throttlePeriodLowerBound = DurationExpression.parse((String)((String)THROTTLE_PERIOD_LOWER_BOUND.get(this.settings)));
                }
                catch (Exception e) {
                    log.error("Error parsing signals.{}: {}", (Object)THROTTLE_PERIOD_LOWER_BOUND.getKey(), THROTTLE_PERIOD_LOWER_BOUND.get(this.settings), (Object)e);
                    this.throttlePeriodLowerBound = null;
                }
            } else {
                this.throttlePeriodLowerBound = null;
            }
        }

        private void validate(String key, Object value) throws ConfigValidationException {
            if (key.equals(HTTP_PROXY.getKey()) && value != null) {
                try {
                    HttpProxyConfig.create(value.toString());
                }
                catch (ConfigValidationException e) {
                    throw new ConfigValidationException(new ValidationErrors().add(key, e));
                }
            }
            ParsedSettingsKey parsedKey = DynamicSettings.matchSetting(key);
            Settings.Builder settingsBuilder = Settings.builder();
            if (value instanceof List) {
                settingsBuilder.putList(key, this.toStringList((List)value));
            } else if (value != null) {
                settingsBuilder.put(key, String.valueOf(value));
            }
            Settings newSettings = settingsBuilder.build();
            if (!parsedKey.isGroup()) {
                try {
                    parsedKey.setting.get(newSettings);
                }
                catch (Exception e) {
                    throw new ConfigValidationException(new ValidationError(key, e.getMessage()).cause((Throwable)e));
                }
            }
            Settings subSettings = newSettings.getAsSettings(parsedKey.setting.getKey() + parsedKey.groupName);
            try {
                parsedKey.subSetting.get(subSettings);
            }
            catch (Exception e) {
                throw new ConfigValidationException(new ValidationError(key, e.getMessage()).cause((Throwable)e));
            }
        }

        private void validate(String key, Object value, Object ... moreKeyValue) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            try {
                this.validate(key, value);
            }
            catch (ConfigValidationException e) {
                validationErrors.add(null, e);
            }
            if (moreKeyValue != null) {
                for (int i = 0; i < moreKeyValue.length; i += 2) {
                    try {
                        this.validate(String.valueOf(moreKeyValue[i]), moreKeyValue[i + 1]);
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        validationErrors.add(null, e);
                    }
                }
            }
            validationErrors.throwExceptionForPresentErrors();
        }

        private List<String> toStringList(List<?> value) {
            ArrayList<String> result = new ArrayList<String>(value.size());
            for (Object o : value) {
                result.add(String.valueOf(o));
            }
            return result;
        }

        public void update(Client client, String key, Object value) throws ConfigValidationException {
            this.validate(key, value);
            this.updateIndex(client, key, value);
            SettingsUpdateAction.send(client);
        }

        public void update(Client client, String key, Object value, Object ... moreKeyValue) throws ConfigValidationException {
            this.validate(key, value, moreKeyValue);
            this.updateIndex(client, key, value);
            if (moreKeyValue != null) {
                for (int i = 0; i < moreKeyValue.length; i += 2) {
                    this.updateIndex(client, String.valueOf(moreKeyValue[i]), moreKeyValue[i + 1]);
                }
            }
            SettingsUpdateAction.send(client);
        }

        public void updateIndex(Client client, String key, Object value) throws ConfigValidationException {
            if (value != null) {
                String json = DocWriter.json().writeAsString(value);
                PrivilegedConfigClient.adapt((Client)client).index((IndexRequest)new IndexRequest(this.indexName).id(key).source(new Object[]{"value", json}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
            } else {
                PrivilegedConfigClient.adapt((Client)client).delete((DeleteRequest)new DeleteRequest(this.indexName).id(key).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refresh(Client client) throws SignalsInitializationException {
            try {
                Settings.Builder newDynamicSettings = Settings.builder();
                SearchResponse response = LuckySisyphos.tryHard(() -> (SearchResponse)PrivilegedConfigClient.adapt((Client)client).search(new SearchRequest(new String[]{this.indexName}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000))).actionGet());
                try {
                    SearchHits hits = response.getHits();
                    for (SearchHit hit : hits) {
                        Map sourceAsMap = hit.getSourceAsMap();
                        if (sourceAsMap.get("value") == null) continue;
                        try {
                            String json = sourceAsMap.get("value").toString();
                            DocNode jsonNode = DocNode.parse((Format)Format.JSON).from(json);
                            if (jsonNode.isList()) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (DocNode subNode : jsonNode.toListOfNodes()) {
                                    list.add(subNode.toString());
                                }
                                newDynamicSettings.putList(hit.getId(), list);
                                continue;
                            }
                            newDynamicSettings.put(hit.getId(), jsonNode.toString());
                        }
                        catch (Exception e) {
                            log.error("Error while parsing setting " + hit, (Throwable)e);
                        }
                    }
                }
                finally {
                    response.decRef();
                }
                Settings newSettings = newDynamicSettings.build();
                if (!newSettings.equals((Object)this.settings)) {
                    this.settings = newSettings;
                    this.notifyListeners();
                }
            }
            catch (IndexNotFoundException e) {
                log.info("Settings index does not exist yet");
            }
            catch (Exception e) {
                throw new SignalsInitializationException("Error while loading settings", e);
            }
            finally {
                this.initDefaultThrottlePeriod();
                this.initThrottlePeriodLowerBound();
            }
        }

        private void notifyListeners() {
            for (ChangeListener listener : this.changeListeners) {
                try {
                    listener.onChange();
                }
                catch (Exception e) {
                    log.error("Error in " + listener, (Throwable)e);
                }
            }
        }

        static List<Setting<?>> getAvailableSettings() {
            return Arrays.asList(ACTIVE, DEFAULT_THROTTLE_PERIOD, THROTTLE_PERIOD_LOWER_BOUND, INCLUDE_NODE_IN_WATCHLOG, ALLOWED_HTTP_ENDPOINTS, TENANT, INTERNAL_AUTH_TOKEN_SIGNING_KEY, INTERNAL_AUTH_TOKEN_ENCRYPTION_KEY, WATCH_LOG_INDEX, NODE_FILTER, HTTP_PROXY, FRONTEND_BASE_URL);
        }

        public static Setting<?> getSetting(String key) throws ConfigValidationException {
            for (Setting<?> setting : DynamicSettings.getAvailableSettings()) {
                if (!setting.match(key)) continue;
                return setting;
            }
            throw new ConfigValidationException(new ValidationError(key, "Unknown key"));
        }

        public static ParsedSettingsKey matchSetting(String key) throws ConfigValidationException {
            Setting<?> setting = DynamicSettings.getSetting(key);
            if (!setting.getKey().endsWith(".")) {
                return new ParsedSettingsKey(setting);
            }
            String remainingKey = key.substring(TENANT.getKey().length());
            int nextPeriod = remainingKey.indexOf(46);
            if (nextPeriod == -1 && nextPeriod == remainingKey.length() - 1) {
                throw new ConfigValidationException(new ValidationError(key, "Illegal key"));
            }
            String groupName = remainingKey.substring(0, nextPeriod);
            String subSettingKey = remainingKey.substring(nextPeriod + 1);
            if (TENANT.match(key)) {
                return new ParsedSettingsKey(setting, groupName, Tenant.getSetting(subSettingKey));
            }
            throw new ConfigValidationException(new ValidationError(key, "Unknown key"));
        }

        public Settings getSettings() {
            return this.settings;
        }
    }

    public static class Tenant {
        static final Setting<String> NODE_FILTER = Setting.simpleString((String)"node_filter", (Setting.Property[])new Setting.Property[0]);
        static final Setting<Boolean> ACTIVE = Setting.boolSetting((String)"active", (boolean)Boolean.TRUE, (Setting.Property[])new Setting.Property[0]);
        private final Settings settings;
        private final DynamicSettings parent;

        Tenant(Settings settings, DynamicSettings parent) {
            this.settings = settings;
            this.parent = parent;
        }

        public String getNodeFilter() {
            String result = (String)NODE_FILTER.get(this.settings);
            if (result == null || result.isEmpty()) {
                result = this.parent.getNodeFilter();
            }
            if (result == null || result.isEmpty()) {
                return null;
            }
            return result;
        }

        public boolean isActive() {
            return this.settings.getAsBoolean(ACTIVE.getKey(), Boolean.valueOf(this.parent.staticSettings.isActiveByDefault()));
        }

        public static Setting<?> getSetting(String key) {
            if (NODE_FILTER.match(key)) {
                return NODE_FILTER;
            }
            if (ACTIVE.match(key)) {
                return ACTIVE;
            }
            throw new IllegalArgumentException("Unkown key: " + key);
        }
    }

    public static interface ChangeListener {
        public void onChange();
    }

    public static class ParsedSettingsKey {
        public final Setting<?> setting;
        public final String groupName;
        public final Setting<?> subSetting;

        ParsedSettingsKey(Setting<?> setting) {
            this.setting = setting;
            this.groupName = null;
            this.subSetting = null;
        }

        ParsedSettingsKey(Setting<?> setting, String groupName, Setting<?> subSetting) {
            this.setting = setting;
            this.groupName = groupName;
            this.subSetting = subSetting;
        }

        public Setting<?> getSetting() {
            return this.setting;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public Setting<?> getSubSetting() {
            return this.subSetting;
        }

        public boolean isGroup() {
            return this.groupName != null;
        }
    }
}

