/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.state;

import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.result.Status;
import com.floragunn.signals.watch.severity.SeverityLevel;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ActionState
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(ActionState.class);
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    private Instant lastTriggered;
    private Instant lastCheck;
    private boolean lastCheckResult;
    private Ack acked;
    private Instant lastExecution;
    private SeverityLevel lastSeverityLevel;
    private int executionCount = 0;
    private volatile Status lastStatus;
    private volatile Instant lastError;

    public synchronized BasicState beforeExecution(DurationExpression throttleDuration) {
        Instant now;
        this.lastTriggered = now = Instant.now();
        if (this.lastExecution == null) {
            return BasicState.EXECUTABLE;
        }
        if (throttleDuration == null) {
            return BasicState.EXECUTABLE;
        }
        Duration actualThrottleDuration = throttleDuration.getActualDuration(this.executionCount);
        if (log.isDebugEnabled()) {
            log.debug("Actual throttle duration after " + this.executionCount + " executions: " + actualThrottleDuration);
        }
        if (this.lastExecution.plus(actualThrottleDuration).isAfter(now)) {
            return BasicState.THROTTLED;
        }
        return BasicState.EXECUTABLE;
    }

    public synchronized void afterSuccessfulExecution() {
        this.lastExecution = this.lastTriggered;
        ++this.executionCount;
    }

    public synchronized Ack afterPositiveTriage() {
        this.lastCheck = this.lastTriggered;
        if (this.lastCheckResult && this.acked != null) {
            return this.acked;
        }
        this.lastCheckResult = true;
        return null;
    }

    public synchronized void afterNegativeTriage() {
        this.lastCheck = this.lastTriggered;
        this.lastCheckResult = false;
        this.acked = null;
        this.executionCount = 0;
    }

    public synchronized void ack(String user) {
        if (!this.lastCheckResult) {
            throw new IllegalStateException("Cannot ack this action because it was not positively triaged recently. Last triage was at " + this.lastCheck);
        }
        this.acked = new Ack(Instant.now(), user);
    }

    public synchronized boolean ackIfPossible(String user) {
        if (!this.lastCheckResult) {
            return false;
        }
        if (this.acked != null) {
            return true;
        }
        this.acked = new Ack(Instant.now(), user);
        return true;
    }

    public synchronized boolean unackIfPossible(String user) {
        if (this.acked == null) {
            return false;
        }
        this.acked = null;
        return true;
    }

    public synchronized Ack getAcked() {
        return this.acked;
    }

    public String toString() {
        return "ActionState [lastTriggered=" + this.lastTriggered + ", lastCheck=" + this.lastCheck + ", lastCheckResult=" + this.lastCheckResult + ", acked=" + this.acked + ", lastExecution=" + this.lastExecution + "]";
    }

    public synchronized XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("last_triggered", this.lastTriggered != null ? DATE_FORMATTER.format((TemporalAccessor)this.lastTriggered) : null);
        builder.field("last_check", this.lastCheck != null ? DATE_FORMATTER.format((TemporalAccessor)this.lastCheck) : null);
        builder.field("last_check_result", this.lastCheckResult);
        builder.field("last_execution", this.lastExecution != null ? DATE_FORMATTER.format((TemporalAccessor)this.lastExecution) : null);
        builder.field("last_error", this.lastError != null ? DATE_FORMATTER.format((TemporalAccessor)this.lastError) : null);
        builder.field("last_status", (ToXContent)this.lastStatus);
        if (this.lastSeverityLevel != null) {
            builder.field("last_execution_severity_level", this.lastSeverityLevel.getId());
        }
        builder.field("execution_count", this.executionCount);
        if (this.acked != null) {
            builder.field("acked", (ToXContent)this.acked);
        }
        builder.endObject();
        return builder;
    }

    public static ActionState createFrom(DocNode jsonNode) {
        ActionState result = new ActionState();
        if (jsonNode.hasNonNull("last_triggered")) {
            result.lastTriggered = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("last_triggered")));
        }
        if (jsonNode.hasNonNull("last_check")) {
            result.lastCheck = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("last_check")));
        } else if (jsonNode.hasNonNull("last_triage")) {
            result.lastCheck = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("last_triage")));
        }
        if (jsonNode.hasNonNull("last_execution")) {
            result.lastExecution = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("last_execution")));
        }
        if (jsonNode.hasNonNull("last_error")) {
            result.lastError = Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("last_error")));
        }
        if (jsonNode.hasNonNull("last_check_result")) {
            try {
                result.lastCheckResult = jsonNode.getBoolean("last_check_result");
            }
            catch (ConfigValidationException e) {
                log.error("Error parsing " + jsonNode, (Throwable)e);
            }
        } else if (jsonNode.hasNonNull("last_triage_result")) {
            try {
                result.lastCheckResult = jsonNode.getBoolean("last_triage_result");
            }
            catch (ConfigValidationException e) {
                log.error("Error parsing " + jsonNode, (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("last_status")) {
            result.lastStatus = Status.parse(jsonNode.getAsNode("last_status"));
        }
        if (jsonNode.hasNonNull("execution_count")) {
            try {
                result.executionCount = jsonNode.getNumber("execution_count").intValue();
            }
            catch (ConfigValidationException e) {
                log.error("Error parsing " + jsonNode, (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("acked")) {
            result.acked = Ack.create(jsonNode.getAsNode("acked"));
        }
        return result;
    }

    public Status getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(Status lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Instant getLastError() {
        return this.lastError;
    }

    public void setLastError(Instant lastError) {
        this.lastError = lastError;
    }

    public static enum BasicState {
        EXECUTABLE,
        THROTTLED;

    }
}

