/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.authc.rest.AuthenticatingRestFilter;
import com.floragunn.searchguard.authc.rest.RestAuthenticationProcessor;
import com.floragunn.searchsupport.action.StandardResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AuthcCacheApi {
    private static final Logger LOG = LogManager.getLogger(AuthcCacheApi.class);

    public static class DeleteAction
    extends ActionType<Response> {
        public static final DeleteAction INSTANCE = new DeleteAction();
        public static final String NAME = "cluster:admin:searchguard:cache/delete";

        public DeleteAction() {
            super(NAME);
        }

        public static class TransportAction
        extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse, Void> {
            private final AuthenticatingRestFilter authenticatingRestFilter;

            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, AuthenticatingRestFilter authenticatingRestFilter) {
                super(DeleteAction.NAME, clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
                this.authenticatingRestFilter = authenticatingRestFilter;
            }

            protected Response newResponse(Request request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
                return new Response(this.clusterService.getClusterName(), nodeResponses, failures);
            }

            protected NodeRequest newNodeRequest(Request request) {
                return new NodeRequest();
            }

            protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
                return new NodeResponse(in, node);
            }

            protected NodeResponse nodeOperation(NodeRequest request, Task task) {
                RestAuthenticationProcessor processor = this.authenticatingRestFilter.getAuthenticationProcessor();
                if (processor != null) {
                    processor.clearCaches();
                    LOG.debug("Cleaned up caches on node {}", (Object)this.clusterService.getNodeName());
                    return new NodeResponse(this.clusterService.localNode());
                }
                LOG.debug("Could not clean up caches on node {}. SearchGuard might not be initialized", (Object)this.clusterService.getNodeName());
                throw new IllegalStateException("SearchGuard might not be initialized");
            }
        }

        public static class NodeResponse
        extends BaseNodeResponse {
            protected NodeResponse(DiscoveryNode node) {
                super(node);
            }

            protected NodeResponse(StreamInput in) throws IOException {
                super(in);
            }

            public NodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
                super(in, node);
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }

        public static class Response
        extends BaseNodesResponse<NodeResponse>
        implements ToXContentObject,
        Document<Response> {
            protected Response(StreamInput in) throws IOException {
                super(in);
            }

            public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
                super(clusterName, nodes, failures);
            }

            protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
                return in.readCollectionAsList(NodeResponse::new);
            }

            protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
                out.writeCollection(nodes);
            }

            public RestStatus status() {
                return this.hasFailures() ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.OK;
            }

            public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
                return xContentBuilder.value(this.toDeepBasicObject());
            }

            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"successful_nodes", this.getNodes().stream().map(nodeResponse -> nodeResponse.getNode().getId()).collect(Collectors.toList()), (Object)"failed_nodes", this.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.toList()));
            }
        }

        public static class NodeRequest
        extends TransportRequest {
            protected NodeRequest() {
            }

            protected NodeRequest(StreamInput in) throws IOException {
                super(in);
            }
        }

        public static class Request
        extends BaseNodesRequest<Request> {
            protected Request() {
                super(new String[0]);
            }
        }
    }

    public static class RestHandler
    extends BaseRestHandler {
        private static final Logger LOG = LogManager.getLogger(RestHandler.class);

        public String getName() {
            return "/_searchguard/authc/cache";
        }

        public List<RestHandler.Route> routes() {
            return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_searchguard/authc/cache"));
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            switch (request.method()) {
                case DELETE: {
                    return channel -> {
                        try {
                            client.execute((ActionType)DeleteAction.INSTANCE, (ActionRequest)new DeleteAction.Request(), (ActionListener)new RestToXContentListener(channel, DeleteAction.Response::status));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e);
                            channel.sendResponse(new StandardResponse(e).toRestResponse());
                        }
                    };
                }
            }
            return channel -> new StandardResponse(405, "Method not allowed: " + request.method());
        }
    }
}

