/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.CheckTable;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Count;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import com.selectivem.collections.CompactMapGroupBuilder;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import com.selectivem.collections.IndexedImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class RoleBasedActionAuthorization
implements ActionAuthorization,
ComponentStateProvider {
    static final StaticSettings.Attribute<ByteSizeValue> PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE = StaticSettings.Attribute.define((String)"searchguard.privileges_evaluation.precomputed_privileges.max_heap_size").withDefault(new ByteSizeValue(10L, ByteSizeUnit.MB)).asByteSizeValue();
    private static final Logger log = LogManager.getLogger(RoleBasedActionAuthorization.class);
    private final SgDynamicConfiguration<Role> roles;
    private final ActionGroup.FlattenedIndex actionGroups;
    private final Actions actions;
    private final TenantManager tenantManager;
    private final ClusterPermissions cluster;
    private final ClusterPermissionExclusions clusterExclusions;
    private final IndexPermissions<Role.Index> index;
    private final IndexPermissions<Role.Alias> alias;
    private final IndexPermissions<Role.DataStream> dataStream;
    private final TenantPermissions tenant;
    private final ComponentState componentState;
    private final ByteSizeValue statefulIndexMaxHeapSize;
    private final Pattern universallyDeniedIndices;
    private final MetricsLevel metricsLevel;
    private final Measurement<?> indexActionChecks;
    private final CountAggregation indexActionCheckResults;
    private final CountAggregation indexActionCheckResults_ok;
    private final CountAggregation indexActionCheckResults_insufficient;
    private final CountAggregation indexActionCheckResults_partially;
    private final CountAggregation indexActionTypes;
    private final CountAggregation indexActionTypes_wellKnown;
    private final CountAggregation indexActionTypes_nonWellKnown;
    private final Measurement<?> tenantActionChecks;
    private final CountAggregation tenantActionCheckResults;
    private final CountAggregation tenantActionCheckResults_ok;
    private final CountAggregation tenantActionCheckResults_insufficient;
    private final TimeAggregation statefulIndexRebuild = new TimeAggregation.Milliseconds();
    private volatile StatefulPermissions stateful;
    private final ComponentState statefulIndexState = new ComponentState("index_permissions_stateful");
    private final ComponentState statefulAliasState = new ComponentState("alias_permissions_stateful");
    private final ComponentState statefulDataStreamState = new ComponentState("data_stream_permissions_stateful");
    private Future<?> updateFuture;

    public RoleBasedActionAuthorization(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta indexMetadata, Set<String> tenants, ByteSizeValue statefulIndexMaxHeapSize) {
        this(roles, actionGroups, actions, indexMetadata, tenants, statefulIndexMaxHeapSize, Pattern.blank(), MetricsLevel.NONE, MultiTenancyConfigurationProvider.DEFAULT);
    }

    public RoleBasedActionAuthorization(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta indexMetadata, Set<String> tenants, ByteSizeValue statefulIndexMaxHeapSize, Pattern universallyDeniedIndices, MetricsLevel metricsLevel, MultiTenancyConfigurationProvider multiTenancyConfigurationProvider) {
        this.roles = roles;
        this.actionGroups = actionGroups;
        this.actions = actions;
        this.metricsLevel = metricsLevel;
        this.statefulIndexMaxHeapSize = statefulIndexMaxHeapSize;
        this.tenantManager = new TenantManager(tenants, multiTenancyConfigurationProvider);
        this.cluster = new ClusterPermissions(roles, actionGroups, actions, metricsLevel);
        this.clusterExclusions = new ClusterPermissionExclusions(roles, actionGroups, actions);
        this.index = new IndexPermissions(roles, actionGroups, actions, Role::getIndexPermissions, "index_permissions");
        this.alias = new IndexPermissions(roles, actionGroups, actions, Role::getAliasPermissions, "alias_permissions");
        this.dataStream = new IndexPermissions(roles, actionGroups, actions, Role::getDataStreamPermissions, "data_stream_permissions");
        this.tenant = new TenantPermissions(roles, actionGroups, actions, this.tenantManager.getConfiguredTenantNames());
        this.universallyDeniedIndices = universallyDeniedIndices;
        this.componentState = new ComponentState("role_based_action_authorization");
        this.componentState.addParts(new ComponentState[]{this.cluster.getComponentState(), this.clusterExclusions.getComponentState(), this.index.getComponentState(), this.tenant.getComponentState(), this.statefulIndexState, this.statefulAliasState, this.statefulDataStreamState});
        if (indexMetadata != null) {
            try (Meter meter = Meter.basic((MetricsLevel)metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                StatefulPermissions.Index statefulIndex = new StatefulPermissions.Index(roles, actionGroups, actions, indexMetadata, universallyDeniedIndices, statefulIndexMaxHeapSize, this.statefulIndexState);
                StatefulPermissions.Alias statefulAlias = new StatefulPermissions.Alias(roles, actionGroups, actions, indexMetadata, universallyDeniedIndices, statefulIndexMaxHeapSize, this.statefulAliasState);
                StatefulPermissions.DataStream statefulDataStream = new StatefulPermissions.DataStream(roles, actionGroups, actions, indexMetadata, universallyDeniedIndices, statefulIndexMaxHeapSize, this.statefulDataStreamState);
                this.stateful = new StatefulPermissions(statefulIndex, statefulAlias, statefulDataStream, indexMetadata);
            }
        } else {
            this.statefulIndexState.setState(ComponentState.State.SUSPENDED, "no_meta_data");
            this.statefulAliasState.setState(ComponentState.State.SUSPENDED, "no_meta_data");
            this.statefulDataStreamState.setState(ComponentState.State.SUSPENDED, "no_meta_data");
        }
        this.componentState.updateStateFromParts();
        this.componentState.setConfigVersion(roles.getDocVersion());
        if (metricsLevel.detailedEnabled()) {
            this.indexActionChecks = new TimeAggregation.Nanoseconds();
            this.indexActionCheckResults = new CountAggregation();
            this.tenantActionChecks = new TimeAggregation.Nanoseconds();
            this.tenantActionCheckResults = new CountAggregation();
            this.indexActionTypes = new CountAggregation();
        } else if (metricsLevel.basicEnabled()) {
            this.indexActionChecks = new CountAggregation();
            this.indexActionCheckResults = new CountAggregation();
            this.tenantActionChecks = new CountAggregation();
            this.tenantActionCheckResults = new CountAggregation();
            this.indexActionTypes = new CountAggregation();
        } else {
            this.indexActionChecks = CountAggregation.noop();
            this.indexActionCheckResults = CountAggregation.noop();
            this.tenantActionChecks = CountAggregation.noop();
            this.tenantActionCheckResults = CountAggregation.noop();
            this.indexActionTypes = CountAggregation.noop();
        }
        this.indexActionCheckResults_ok = this.indexActionCheckResults.getSubCount("ok");
        this.indexActionCheckResults_partially = this.indexActionCheckResults.getSubCount("partially_ok");
        this.indexActionCheckResults_insufficient = this.indexActionCheckResults.getSubCount("insufficient");
        this.tenantActionCheckResults_ok = this.tenantActionCheckResults.getSubCount("ok");
        this.tenantActionCheckResults_insufficient = this.tenantActionCheckResults.getSubCount("insufficient");
        this.indexActionTypes_wellKnown = this.indexActionTypes.getSubCount("well_known");
        this.indexActionTypes_nonWellKnown = this.indexActionTypes.getSubCount("non_well_known");
        if (metricsLevel.basicEnabled()) {
            this.componentState.addMetrics("index_action_check_results", (Measurement)this.indexActionCheckResults);
            this.componentState.addMetrics("tenant_action_check_results", (Measurement)this.tenantActionCheckResults);
            this.componentState.addMetrics("index_action_checks", this.indexActionChecks, "tenant_action_checks", this.tenantActionChecks, "statful_index_rebuilds", (Measurement)this.statefulIndexRebuild);
            this.componentState.addMetrics("index_action_types", (Measurement)this.indexActionTypes);
        }
    }

    @Override
    public PrivilegesEvaluationResult hasClusterPermission(PrivilegesEvaluationContext context, Action action) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.clusterExclusions.contains(action, (Set<String>)context.getMappedRoles());
        if (result.getStatus() != PrivilegesEvaluationResult.Status.PENDING) {
            return result.missingPrivileges(action);
        }
        return this.cluster.contains(action, (Set<String>)context.getMappedRoles());
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivilegesEvaluationResult hasIndexPermission(PrivilegesEvaluationContext context, Action primaryAction, ImmutableSet<Action> actions, ResolvedIndices resolved, Action.Scope actionScope) throws PrivilegesEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 94[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkWellKnownActionsWithIndexPatternsForShallowCheckTable(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> shallowCheckTable, ResolvedIndices resolved, Meter meter) {
        try (Meter subMeter = meter.basic("well_known_action_index_pattern");){
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            ImmutableSet<Meta.Index> resolvedIndices = resolved.getLocal().getPureIndices();
            ImmutableSet<Meta.Alias> resolvedAliases = resolved.getLocal().getAliases();
            ImmutableSet<Meta.DataStream> resolvedDataStreams = resolved.getLocal().getDataStreams();
            ImmutableSet<Meta.NonExistent> resolvedNonExistentIndices = resolved.getLocal().getNonExistingIndices();
            for (String role : mappedRoles) {
                if (!resolvedIndices.isEmpty() && this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, shallowCheckTable, role, (Collection)resolvedIndices, (IndexPermissions)this.index, subMeter)) {
                    return;
                }
                if (!resolvedNonExistentIndices.isEmpty() && this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, shallowCheckTable, role, (Collection)resolvedNonExistentIndices, (IndexPermissions)this.index, subMeter)) {
                    return;
                }
                if (!resolvedAliases.isEmpty() && this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, shallowCheckTable, role, (Collection)resolvedAliases, (IndexPermissions)this.alias, subMeter)) {
                    return;
                }
                if (resolvedDataStreams.isEmpty() || !this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, shallowCheckTable, role, (Collection)resolvedDataStreams, (IndexPermissions)this.dataStream, subMeter)) continue;
                return;
            }
        }
    }

    private void checkWellKnownActionsWithIndexPatternsForDataStreams(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> semiDeepCheckTable, ResolvedIndices resolved, ImmutableSet<Meta.DataStream> resolvedDataStreams, Meter meter) {
        try (Meter subMeter = meter.basic("well_known_action_index_pattern_data_streams");){
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            for (String role : mappedRoles) {
                if (!this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, semiDeepCheckTable, role, (Collection)resolvedDataStreams, (IndexPermissions)this.dataStream, subMeter)) continue;
                return;
            }
        }
    }

    private void checkWellKnownActionsWithIndexPatternsForDeepCheckTable(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> deepCheckTable, ResolvedIndices resolved, Meter meter) {
        try (Meter subMeter = meter.basic("well_known_action_index_pattern");){
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            for (String role : mappedRoles) {
                if (!this.checkWellKnownActionsWithIndexPatterns(context, localContext, user, deepCheckTable, role, (Collection)deepCheckTable.getRows(), (IndexPermissions)this.index, subMeter)) continue;
                return;
            }
        }
    }

    private <PrivilegeType extends Role.Index, ResolvedType extends Meta.IndexLikeObject> boolean checkWellKnownActionsWithIndexPatterns(PrivilegesEvaluationContext context, LocalContext localContext, User user, CheckTable<Meta.IndexLikeObject, Action> checkTable, String role, Collection<ResolvedType> resolvedIndexLikeObjects, IndexPermissions<PrivilegeType> indexPermissions, Meter meter) {
        ImmutableMap actionToIndexPattern = (ImmutableMap)indexPermissions.rolesToActionToIndexPattern.get((Object)role);
        if (actionToIndexPattern != null) {
            for (Action action : checkTable.getColumns()) {
                IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                if (indexPattern == null) continue;
                for (Meta.IndexLikeObject indexLike : resolvedIndexLikeObjects) {
                    if (checkTable.isChecked((Object)indexLike, (Object)action)) continue;
                    try {
                        if (!indexPattern.matches(indexLike.name(), user, context, meter) || !checkTable.check((Object)indexLike, (Object)action)) continue;
                        return true;
                    }
                    catch (PrivilegesEvaluationException e) {
                        log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                        this.componentState.addLastException("has_index_permission", (Throwable)e);
                        localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                    }
                }
            }
        }
        return false;
    }

    private void checkWellKnownActionsWithIndexPatternsViaParentAliases(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> checkTable, ResolvedIndices resolved, Meter meter) {
        block15: {
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            try (Meter subMeter = meter.basic("parent_aliases_with_well_known_action_index_pattern");){
                for (Meta.IndexLikeObject index : checkTable.getIncompleteRows()) {
                    if (index.parentDataStreamName() == null && index.parentAliasNames().isEmpty()) continue;
                    for (String role : mappedRoles) {
                        ImmutableMap actionToAliasPattern = (ImmutableMap)this.alias.rolesToActionToIndexPattern.get((Object)role);
                        ImmutableMap actionToDataStreamPattern = (ImmutableMap)this.dataStream.rolesToActionToIndexPattern.get((Object)role);
                        if (actionToAliasPattern == null && actionToDataStreamPattern == null) continue;
                        for (Action action : checkTable.iterateUncheckedColumns((Object)index)) {
                            IndexPattern indexPattern;
                            Collection ancestorAliasNames;
                            block14: {
                                IndexPattern indexPattern2;
                                if (index.parentDataStreamName() != null && actionToDataStreamPattern != null && (indexPattern2 = (IndexPattern)actionToDataStreamPattern.get((Object)action)) != null) {
                                    try {
                                        if (!indexPattern2.matches(index.parentDataStreamName(), user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) break block14;
                                        break block15;
                                    }
                                    catch (PrivilegesEvaluationException e) {
                                        log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                                        this.componentState.addLastException("has_index_permission", (Throwable)e);
                                        localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                    }
                                }
                            }
                            if ((ancestorAliasNames = index.ancestorAliasNames()).isEmpty() || actionToAliasPattern == null || (indexPattern = (IndexPattern)actionToAliasPattern.get((Object)action)) == null) continue;
                            try {
                                if (!indexPattern.matches(ancestorAliasNames, user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                break block15;
                            }
                            catch (PrivilegesEvaluationException e) {
                                log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                                this.componentState.addLastException("has_index_permission", (Throwable)e);
                                localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkNonWellKnownActions(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> checkTable, boolean checkAliases, boolean checkDataStreams, Meter meter) {
        block22: {
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            try (Meter subMeter = meter.basic("non_well_known_actions_index_pattern");){
                for (String role : mappedRoles) {
                    ImmutableMap actionPatternToDataStreamPattern;
                    ImmutableMap actionPatternToIndexPattern = (ImmutableMap)this.index.rolesToActionPatternToIndexPattern.get((Object)role);
                    ImmutableMap actionPatternToAliasPattern = checkAliases ? (ImmutableMap)this.alias.rolesToActionPatternToIndexPattern.get((Object)role) : null;
                    ImmutableMap immutableMap = actionPatternToDataStreamPattern = checkDataStreams ? (ImmutableMap)this.dataStream.rolesToActionPatternToIndexPattern.get((Object)role) : null;
                    if (actionPatternToIndexPattern == null && actionPatternToAliasPattern == null && actionPatternToDataStreamPattern == null) continue;
                    for (Action action : checkTable.getIncompleteColumns()) {
                        IndexPattern indexPattern;
                        Pattern actionPattern;
                        if (actionPatternToIndexPattern != null) {
                            for (Map.Entry entry : actionPatternToIndexPattern.entrySet()) {
                                actionPattern = (Pattern)entry.getKey();
                                indexPattern = (IndexPattern)entry.getValue();
                                if (!actionPattern.matches(action.name())) continue;
                                for (Meta.IndexLikeObject index : checkTable.iterateUncheckedRows((Object)action)) {
                                    if (!(index instanceof Meta.IndexOrNonExistent)) continue;
                                    try {
                                        if (!indexPattern.matches(index.name(), user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                        break block22;
                                    }
                                    catch (PrivilegesEvaluationException e) {
                                        log.error("Error while evaluating index pattern. Ignoring entry", (Throwable)e);
                                        this.componentState.addLastException("has_index_permission", (Throwable)e);
                                        localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                    }
                                }
                            }
                        }
                        if (actionPatternToAliasPattern != null) {
                            for (Map.Entry entry : actionPatternToAliasPattern.entrySet()) {
                                actionPattern = (Pattern)entry.getKey();
                                indexPattern = (IndexPattern)entry.getValue();
                                if (!actionPattern.matches(action.name())) continue;
                                for (Meta.IndexLikeObject index : checkTable.iterateUncheckedRows((Object)action)) {
                                    if (!(index instanceof Meta.Alias)) continue;
                                    try {
                                        if (!indexPattern.matches(index.name(), user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                        break block22;
                                    }
                                    catch (PrivilegesEvaluationException e) {
                                        log.error("Error while evaluating index pattern. Ignoring entry", (Throwable)e);
                                        this.componentState.addLastException("has_index_permission", (Throwable)e);
                                        localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                    }
                                }
                            }
                        }
                        if (actionPatternToDataStreamPattern == null) continue;
                        for (Map.Entry entry : actionPatternToDataStreamPattern.entrySet()) {
                            actionPattern = (Pattern)entry.getKey();
                            indexPattern = (IndexPattern)entry.getValue();
                            if (!actionPattern.matches(action.name())) continue;
                            for (Meta.IndexLikeObject index : checkTable.iterateUncheckedRows((Object)action)) {
                                if (!(index instanceof Meta.DataStream)) continue;
                                try {
                                    if (!indexPattern.matches(index.name(), user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                    break block22;
                                }
                                catch (PrivilegesEvaluationException e) {
                                    log.error("Error while evaluating index pattern. Ignoring entry", (Throwable)e);
                                    this.componentState.addLastException("has_index_permission", (Throwable)e);
                                    localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkNonWellKnownActionsViaParentAliases(PrivilegesEvaluationContext context, LocalContext localContext, CheckTable<Meta.IndexLikeObject, Action> checkTable, ResolvedIndices resolved, Meter meter) {
        block16: {
            User user = context.getUser();
            ImmutableSet<String> mappedRoles = context.getMappedRoles();
            try (Meter subMeter = meter.basic("parent_aliases_with_non_well_known_actions_index_pattern");){
                for (Meta.IndexLikeObject index : checkTable.getIncompleteRows()) {
                    if (index.parentDataStreamName() == null && index.parentAliasNames().isEmpty()) continue;
                    for (String role : mappedRoles) {
                        ImmutableMap actionToAliasPattern = (ImmutableMap)this.alias.rolesToActionPatternToIndexPattern.get((Object)role);
                        ImmutableMap actionToDataStreamPattern = (ImmutableMap)this.dataStream.rolesToActionPatternToIndexPattern.get((Object)role);
                        if (actionToAliasPattern == null && actionToDataStreamPattern == null) continue;
                        for (Action action : checkTable.iterateUncheckedColumns((Object)index)) {
                            Collection ancestorAliasNames;
                            if (index.parentDataStreamName() != null && actionToDataStreamPattern != null) {
                                for (Map.Entry entry : actionToDataStreamPattern.entrySet()) {
                                    Pattern actionPattern = (Pattern)entry.getKey();
                                    IndexPattern indexPattern = (IndexPattern)entry.getValue();
                                    if (!actionPattern.matches(action.name())) continue;
                                    try {
                                        if (index.parentDataStreamName() == null || !indexPattern.matches(index.parentDataStreamName(), user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                        break block16;
                                    }
                                    catch (PrivilegesEvaluationException e) {
                                        log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                                        this.componentState.addLastException("has_index_permission", (Throwable)e);
                                        localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                    }
                                }
                            }
                            if ((ancestorAliasNames = index.ancestorAliasNames()).isEmpty() || actionToAliasPattern == null) continue;
                            for (Map.Entry entry : actionToAliasPattern.entrySet()) {
                                Pattern actionPattern = (Pattern)entry.getKey();
                                IndexPattern indexPattern = (IndexPattern)entry.getValue();
                                if (!actionPattern.matches(action.name())) continue;
                                try {
                                    if (!indexPattern.matches(ancestorAliasNames, user, context, subMeter) || !checkTable.check((Object)index, (Object)action)) continue;
                                    break block16;
                                }
                                catch (PrivilegesEvaluationException e) {
                                    log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                                    this.componentState.addLastException("has_index_permission", (Throwable)e);
                                    localContext.add(new PrivilegesEvaluationResult.Error("Error while evaluating index pattern", e, role));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivilegesEvaluationResult hasTenantPermission(PrivilegesEvaluationContext context, Action action, String requestedTenant) throws PrivilegesEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void update(Meta indexMetadata) {
        if (this.stateful == null || !this.stateful.indexMetadata.equals((Object)indexMetadata)) {
            try (Meter meter = Meter.basic((MetricsLevel)this.metricsLevel, (TimeAggregation)this.statefulIndexRebuild);){
                if (log.isTraceEnabled()) {
                    log.trace("Updating due to index metadata change: {}", (Object)indexMetadata);
                }
                StatefulPermissions.Index statefulIndex = new StatefulPermissions.Index(this.roles, this.actionGroups, this.actions, indexMetadata, this.universallyDeniedIndices, this.statefulIndexMaxHeapSize, this.statefulIndexState);
                StatefulPermissions.Alias statefulAlias = new StatefulPermissions.Alias(this.roles, this.actionGroups, this.actions, indexMetadata, this.universallyDeniedIndices, this.statefulIndexMaxHeapSize, this.statefulAliasState);
                StatefulPermissions.DataStream statefulDataStream = new StatefulPermissions.DataStream(this.roles, this.actionGroups, this.actions, indexMetadata, this.universallyDeniedIndices, this.statefulIndexMaxHeapSize, this.statefulDataStreamState);
                this.stateful = new StatefulPermissions(statefulIndex, statefulAlias, statefulDataStream, indexMetadata);
                this.componentState.updateStateFromParts();
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Got metadata update, but metadata was unchanged: {}", (Object)indexMetadata);
        }
    }

    public synchronized void updateStatefulIndexPrivilegesAsync(ClusterService clusterService, ThreadPool threadPool) {
        long currentMetadataVersion = clusterService.state().metadata().version();
        StatefulPermissions stateful = this.stateful;
        if (stateful != null && currentMetadataVersion <= stateful.indexMetadata.version()) {
            return;
        }
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = threadPool.generic().submit(() -> {
                int i = 0;
                while (true) {
                    if (i > 10) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    Meta indexMetadata = Meta.from((ClusterService)clusterService);
                    RoleBasedActionAuthorization roleBasedActionAuthorization = this;
                    synchronized (roleBasedActionAuthorization) {
                        if (indexMetadata.version() <= this.stateful.indexMetadata.version()) {
                            return;
                        }
                    }
                    try {
                        log.debug("Updating ActionPrivileges with metadata version {}", (Object)indexMetadata.version());
                        this.update(indexMetadata);
                    }
                    catch (Exception e) {
                        log.error("Error while updating ActionPrivileges", (Throwable)e);
                    }
                    finally {
                        roleBasedActionAuthorization = this;
                        synchronized (roleBasedActionAuthorization) {
                            if (this.updateFuture.isCancelled()) {
                                return;
                            }
                        }
                    }
                    ++i;
                }
            });
        }
    }

    public synchronized void shutdown() {
        if (this.updateFuture != null && !this.updateFuture.isDone()) {
            this.updateFuture.cancel(true);
        }
    }

    public ActionGroup.FlattenedIndex getActionGroups() {
        return this.actionGroups;
    }

    private static boolean isActionName(String actionName) {
        return actionName.indexOf(58) != -1;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private /* synthetic */ boolean lambda$hasIndexPermission$9(Meta.IndexLikeObject i) {
        return this.universallyDeniedIndices.matches(i.name());
    }

    private static /* synthetic */ Meta.IndexCollection lambda$hasIndexPermission$8(Meta.IndexLikeObject i) {
        return i instanceof Meta.IndexCollection ? (Meta.IndexCollection)i : null;
    }

    private /* synthetic */ boolean lambda$hasIndexPermission$7(Meta.IndexLikeObject i) {
        return this.universallyDeniedIndices.matches((Iterable)i.resolveDeepToNames(Meta.Alias.ResolutionMode.NORMAL));
    }

    private static /* synthetic */ boolean lambda$hasIndexPermission$6(Meta.Alias alias) {
        return alias.members().stream().anyMatch(member -> member instanceof Meta.DataStream);
    }

    private static /* synthetic */ boolean lambda$hasIndexPermission$4(CheckTable shallowCheckTable, Meta.DataStream e) {
        return !shallowCheckTable.isRowComplete((Object)e);
    }

    private static /* synthetic */ boolean lambda$hasIndexPermission$3(CheckTable shallowCheckTable, Meta.Alias e) {
        return !shallowCheckTable.isRowComplete((Object)e);
    }

    private /* synthetic */ boolean lambda$hasIndexPermission$2(Meta.IndexLikeObject i) {
        return this.universallyDeniedIndices.matches((Iterable)i.resolveDeepToNames(Meta.Alias.ResolutionMode.NORMAL));
    }

    private static /* synthetic */ boolean lambda$hasIndexPermission$1(Action a) {
        return a instanceof Action.WellKnownAction && ((Action.WellKnownAction)a).isPerformanceCritical();
    }

    private /* synthetic */ void lambda$hasIndexPermission$0(Action action) {
        this.indexActionTypes.increment();
        if (action instanceof Action.WellKnownAction) {
            this.indexActionTypes_wellKnown.increment();
        } else {
            this.indexActionTypes_nonWellKnown.increment();
            if (this.metricsLevel.detailedEnabled()) {
                this.indexActionTypes_nonWellKnown.getSubCount(action.name()).increment();
            }
        }
    }

    static class ClusterPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRoles;
        private final ImmutableSet<String> rolesWithWildcardPermissions;
        private final ImmutableMap<String, Pattern> rolesToActionPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState = new ComponentState("cluster_permissions");
        private final CountAggregation checks;
        private final CountAggregation nonWellKnownChecks;
        private final CountAggregation wildcardChecks;
        private final MetricsLevel metricsLevel;

        ClusterPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, MetricsLevel metricsLevel) {
            ImmutableMap.Builder actionToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableSet.Builder rolesWithWildcardPermissions = new ImmutableSet.Builder();
            ImmutableMap.Builder rolesToActionPattern = new ImmutableMap.Builder();
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)role.getClusterPermissions());
                    ImmutableSet<String> excludedPermissions = actionGroups.resolve((Collection<String>)role.getExcludeClusterPermissions());
                    Pattern excludedPattern = Pattern.createWithoutExclusions(excludedPermissions);
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    if (permissions.contains((Object)"*") && excludedPermissions.isEmpty()) {
                        rolesWithWildcardPermissions.add((Object)roleName);
                        continue;
                    }
                    for (String permission : permissions) {
                        if (Pattern.isConstant((String)permission)) {
                            if (excludedPattern.matches(permission) || !RoleBasedActionAuthorization.isActionName(permission)) continue;
                            ((ImmutableSet.Builder)actionToRoles.get((Object)actions.get(permission))).add((Object)roleName);
                            continue;
                        }
                        Pattern pattern = Pattern.create((String)permission);
                        ImmutableSet providedPrivileges = actions.clusterActions().matching(a -> pattern.matches(a.name()) && !excludedPattern.matches(a.name()));
                        for (Action.WellKnownAction action : providedPrivileges) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)action)).add((Object)roleName);
                        }
                        patterns.add(pattern);
                    }
                    if (patterns.isEmpty()) continue;
                    rolesToActionPattern.put((Object)roleName, (Object)Pattern.join(patterns).excluding(excludedPattern));
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid pattern in role: {}\nThis should have been caught before. Ignoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToRoles = actionToRoles.build(ImmutableSet.Builder::build);
            this.rolesWithWildcardPermissions = rolesWithWildcardPermissions.build();
            this.rolesToActionPattern = rolesToActionPattern.build();
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            this.checks = CountAggregation.basic((MetricsLevel)metricsLevel);
            this.nonWellKnownChecks = this.checks.getSubCount("non_well_known_actions");
            this.wildcardChecks = this.checks.getSubCount("wildcard");
            this.metricsLevel = metricsLevel;
            if (metricsLevel.basicEnabled()) {
                this.componentState.addMetrics("checks", (Measurement)this.checks);
                this.componentState.addMetrics("action_to_roles_map", (Measurement)new Count((long)actionToRoles.size()));
                this.componentState.addMetrics("roles_to_action_pattern_map", (Measurement)new Count((long)rolesToActionPattern.size()));
            }
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        PrivilegesEvaluationResult contains(Action action, Set<String> roles) {
            this.checks.increment();
            if (this.rolesWithWildcardPermissions.containsAny(roles)) {
                this.wildcardChecks.increment();
                return PrivilegesEvaluationResult.OK;
            }
            ImmutableSet rolesWithPrivileges = (ImmutableSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluationResult.OK;
            }
            if (!(action instanceof Action.WellKnownAction)) {
                try (Meter m = Meter.basic((MetricsLevel)MetricsLevel.BASIC, (Measurement)this.nonWellKnownChecks);){
                    if (this.metricsLevel.detailedEnabled()) {
                        m.count(action.name());
                    }
                    for (String role : roles) {
                        Pattern pattern = (Pattern)this.rolesToActionPattern.get((Object)role);
                        if (pattern == null || !pattern.matches(action.name())) continue;
                        PrivilegesEvaluationResult privilegesEvaluationResult = PrivilegesEvaluationResult.OK;
                        return privilegesEvaluationResult;
                    }
                }
            }
            return PrivilegesEvaluationResult.INSUFFICIENT.with(this.initializationErrors).missingPrivileges(action);
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class ClusterPermissionExclusions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRoles;
        private final ImmutableMap<String, Pattern> rolesToActionPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState = new ComponentState("cluster_permission_exclusions");

        ClusterPermissionExclusions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions) {
            ImmutableMap.Builder actionToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableMap.Builder rolesToActionPattern = new ImmutableMap.Builder();
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)role.getExcludeClusterPermissions());
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    for (String permission : permissions) {
                        if (Pattern.isConstant((String)permission)) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)actions.get(permission))).add((Object)roleName);
                            continue;
                        }
                        Pattern pattern = Pattern.create((String)permission);
                        ImmutableSet providedPrivileges = actions.clusterActions().matching(a -> pattern.matches(a.name()));
                        for (Action.WellKnownAction action : providedPrivileges) {
                            ((ImmutableSet.Builder)actionToRoles.get((Object)action)).add((Object)roleName);
                        }
                        patterns.add(pattern);
                    }
                    if (patterns.isEmpty()) continue;
                    rolesToActionPattern.put((Object)roleName, (Object)Pattern.join(patterns));
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid pattern in role: {}\nThis should have been caught before. Ignoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToRoles = actionToRoles.build(ImmutableSet.Builder::build);
            this.rolesToActionPattern = rolesToActionPattern.build();
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail(this.initializationErrors);
            }
        }

        PrivilegesEvaluationResult contains(Action action, Set<String> roles) {
            ImmutableSet rolesWithPrivileges = (ImmutableSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluationResult.INSUFFICIENT.reason("Privilege exclusion in role " + rolesWithPrivileges.intersection(roles));
            }
            if (!(action instanceof Action.WellKnownAction)) {
                for (String role : roles) {
                    Pattern pattern = (Pattern)this.rolesToActionPattern.get((Object)role);
                    if (pattern == null || !pattern.matches(action.name())) continue;
                    return PrivilegesEvaluationResult.INSUFFICIENT.reason("Privilege exclusion in role " + role);
                }
            }
            return PrivilegesEvaluationResult.PENDING;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class IndexPermissions<I extends Role.Index>
    implements ComponentStateProvider {
        private final ImmutableMap<String, ImmutableMap<Action, IndexPattern>> rolesToActionToIndexPattern;
        private final ImmutableMap<String, ImmutableMap<Pattern, IndexPattern>> rolesToActionPatternToIndexPattern;
        private final ImmutableMap<Action, ImmutableSet<String>> actionToRolesWithWildcardIndexPrivileges;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState;
        private final String componentName;

        IndexPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Function<Role, Iterable<I>> getPermissionsFunction, String componentName) {
            this.componentState = new ComponentState(componentName);
            this.componentName = componentName;
            ImmutableMap.Builder rolesToActionToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder rolesToActionPatternsToIndexPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new IndexPattern.Builder()));
            ImmutableMap.Builder actionToRolesWithWildcardIndexPrivileges = new ImmutableMap.Builder().defaultValue(k -> new ImmutableSet.Builder());
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Index indexPermissions : getPermissionsFunction.apply(role)) {
                        ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)indexPermissions.getAllowedActions());
                        for (String permission : permissions) {
                            if (Pattern.isConstant((String)permission)) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)actions.get(permission))).add(indexPermissions.getIndexPatterns());
                                if (!indexPermissions.getIndexPatterns().getPattern().isWildcard()) continue;
                                ((ImmutableSet.Builder)actionToRolesWithWildcardIndexPrivileges.get((Object)actions.get(permission))).add((Object)roleName);
                                continue;
                            }
                            Pattern actionPattern = Pattern.create((String)permission);
                            ImmutableSet providedPrivileges = actions.indexLikeActions().matching(a -> actionPattern.matches(a.name()));
                            for (Action.WellKnownAction action : providedPrivileges) {
                                ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionToIndexPattern.get((Object)roleName)).get((Object)action)).add(indexPermissions.getIndexPatterns());
                                if (!indexPermissions.getIndexPatterns().getPattern().isWildcard()) continue;
                                ((ImmutableSet.Builder)actionToRolesWithWildcardIndexPrivileges.get((Object)action)).add((Object)roleName);
                            }
                            ((IndexPattern.Builder)((ImmutableMap.Builder)rolesToActionPatternsToIndexPattern.get((Object)roleName)).get((Object)actionPattern)).add(indexPermissions.getIndexPatterns());
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: {}\nThis should have been caught before. Ignoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid pattern in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.rolesToActionToIndexPattern = rolesToActionToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.rolesToActionPatternToIndexPattern = rolesToActionPatternsToIndexPattern.build(b -> b.build(IndexPattern.Builder::build));
            this.actionToRolesWithWildcardIndexPrivileges = actionToRolesWithWildcardIndexPrivileges.build(ImmutableSet.Builder::build);
            this.initializationErrors = initializationErrors.build();
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
            if (log.isTraceEnabled()) {
                log.trace("Built {}", (Object)this.toString());
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        public String toString() {
            return this.componentName + ":\nrolesToActionToIndexPattern: " + this.rolesToActionToIndexPattern + "\nrolesToActionPatternToIndexPattern: " + this.rolesToActionPatternToIndexPattern + "\nactionToRolesWithWildcardIndexPrivileges: " + this.actionToRolesWithWildcardIndexPrivileges + "\n";
        }
    }

    static class TenantPermissions
    implements ComponentStateProvider {
        private final ImmutableMap<Action, ImmutableMap<String, ImmutableSet<String>>> actionToTenantToRoles;
        private final ImmutableMap<String, ImmutableMap<Action, ImmutableSet<Template<Pattern>>>> roleToActionToTenantPattern;
        private final ImmutableList<PrivilegesEvaluationResult.Error> initializationErrors;
        private final ComponentState componentState;

        TenantPermissions(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, ImmutableSet<String> tenants) {
            ImmutableMap.Builder actionToTenantToRoles = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableMap.Builder roleToActionToTenantPattern = new ImmutableMap.Builder().defaultValue(k -> new ImmutableMap.Builder().defaultValue(k2 -> new ImmutableSet.Builder()));
            ImmutableList.Builder initializationErrors = new ImmutableList.Builder();
            for (Map.Entry entry : roles.getCEntries().entrySet()) {
                try {
                    String roleName = (String)entry.getKey();
                    Role role = (Role)entry.getValue();
                    for (Role.Tenant tenantPermissions : role.getTenantPermissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)tenantPermissions.getAllowedActions());
                        for (String permission : permissions) {
                            for (Template tenantPatternTemplate : tenantPermissions.getTenantPatterns()) {
                                if (tenantPatternTemplate.isConstant()) {
                                    Pattern tenantPattern = (Pattern)tenantPatternTemplate.getConstantValue();
                                    ImmutableSet matchingTenants = tenants.matching((Predicate)tenantPattern);
                                    if (Pattern.isConstant((String)permission)) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)actions.get(permission))).get((Object)tenant)).add((Object)roleName);
                                        }
                                        continue;
                                    }
                                    Pattern actionPattern = Pattern.create((String)permission);
                                    ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                    for (Action.WellKnownAction action : providedPrivileges) {
                                        for (String tenant : matchingTenants) {
                                            ((ImmutableSet.Builder)((ImmutableMap.Builder)actionToTenantToRoles.get((Object)action)).get((Object)tenant)).add((Object)roleName);
                                        }
                                    }
                                    continue;
                                }
                                if (Pattern.isConstant((String)permission)) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)actions.get(permission))).add((Object)tenantPatternTemplate);
                                    continue;
                                }
                                Pattern actionPattern = Pattern.create((String)permission);
                                ImmutableSet providedPrivileges = actions.tenantActions().matching(a -> actionPattern.matches(a.name()));
                                for (Action.WellKnownAction action : providedPrivileges) {
                                    ((ImmutableSet.Builder)((ImmutableMap.Builder)roleToActionToTenantPattern.get((Object)roleName)).get((Object)action)).add((Object)tenantPatternTemplate);
                                }
                            }
                        }
                    }
                }
                catch (ConfigValidationException e) {
                    log.error("Invalid configuration in role: {}\nThis should have been caught before. Ignoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Invalid configuration in role", e, (String)entry.getKey()));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry, (Object)e);
                    initializationErrors.with((Object)new PrivilegesEvaluationResult.Error("Unexpected exception while processing role", e, (String)entry.getKey()));
                }
            }
            this.actionToTenantToRoles = actionToTenantToRoles.build(b -> b.build(ImmutableSet.Builder::build));
            this.roleToActionToTenantPattern = roleToActionToTenantPattern.build(b -> b.build(ImmutableSet.Builder::build));
            this.initializationErrors = initializationErrors.build();
            this.componentState = new ComponentState("tenant_permissions");
            this.componentState.setConfigVersion(roles.getDocVersion());
            if (this.initializationErrors.isEmpty()) {
                this.componentState.setInitialized();
            } else {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                this.componentState.addDetail((Object)initializationErrors);
            }
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }

    static class StatefulPermissions {
        final Index index;
        final Alias alias;
        final DataStream dataStream;
        final Meta indexMetadata;

        StatefulPermissions(Index index, Alias alias, DataStream dataStream, Meta indexMetadata) {
            this.index = index;
            this.alias = alias;
            this.dataStream = dataStream;
            this.indexMetadata = indexMetadata;
        }

        boolean covers(Set<Meta.IndexLikeObject> indexLikeObjects) {
            for (Meta.IndexLikeObject indexLike : indexLikeObjects) {
                if (!indexLike.exists()) {
                    return false;
                }
                Meta.IndexLikeObject covered = this.indexMetadata.getIndexOrLike(indexLike.name());
                if (covered != null && covered.equals((Object)indexLike)) continue;
                return false;
            }
            return true;
        }

        static class Index
        implements ComponentStateProvider {
            private final ImmutableMap<Action.WellKnownAction<?, ?, ?>, Map<String, ImmutableCompactSubSet<String>>> actionToIndexToRoles;
            private final Meta indexMetadata;
            private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final ComponentState componentState;
            private final Pattern universallyDeniedIndices;
            private final int estimatedByteSize;

            Index(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta indexMetadata, Pattern universallyDeniedIndices, ByteSizeValue statefulIndexMaxHeapSize, ComponentState componentState) {
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder indexMapBuilder = new CompactMapGroupBuilder((Set)indexMetadata.indexLikeObjects().keySet(), k2 -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder actionToIndexToRoles = new ImmutableMap.Builder().defaultValue(k -> indexMapBuilder.createMapBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                Iterable indexNames = indexMetadata.namesOfIndices();
                for (String roleName : roleNames) {
                    try {
                        Object providedPrivileges;
                        Pattern pattern;
                        Action action;
                        ImmutableSet<String> permissions;
                        Role role = roles.getCEntry(roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.Index indexPermissions : role.getIndexPermissions()) {
                            permissions = actionGroups.resolve((Collection<String>)indexPermissions.getAllowedActions());
                            Pattern indexPattern = indexPermissions.getIndexPatterns().getPattern();
                            if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                            for (String permission : permissions) {
                                Object index22;
                                if (Pattern.isConstant((String)permission)) {
                                    action = actions.get(permission);
                                    if (!(action instanceof Action.WellKnownAction)) continue;
                                    for (Object index22 : indexPattern.iterateMatching(indexNames)) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToIndexToRoles.get((Object)((Action.WellKnownAction)action))).get(index22)).add((Object)roleName);
                                    }
                                    continue;
                                }
                                pattern = Pattern.create((String)permission);
                                providedPrivileges = actions.indexLikeActionsPerformanceCritical().matching(a -> pattern.matches(a.name()));
                                index22 = indexPattern.iterateMatching(indexNames).iterator();
                                while (index22.hasNext()) {
                                    String index3 = (String)index22.next();
                                    UnmodifiableIterator unmodifiableIterator = providedPrivileges.iterator();
                                    while (unmodifiableIterator.hasNext()) {
                                        Action.WellKnownAction action2 = (Action.WellKnownAction)unmodifiableIterator.next();
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToIndexToRoles.get((Object)action2)).get((Object)index3)).add((Object)roleName);
                                    }
                                }
                            }
                        }
                        for (Role.Index aliasPermissions : role.getAliasPermissions()) {
                            permissions = actionGroups.resolve((Collection<String>)aliasPermissions.getAllowedActions());
                            Pattern aliasPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (aliasPattern.isWildcard() || aliasPattern.isBlank()) continue;
                            for (String permission : permissions) {
                                if (Pattern.isConstant((String)permission)) {
                                    action = actions.get(permission);
                                    if (!(action instanceof Action.WellKnownAction)) continue;
                                    for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                        alias.resolveDeepToNames(Meta.Alias.ResolutionMode.NORMAL).forEach(index -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToIndexToRoles.get((Object)((Action.WellKnownAction)action))).get(index)).add((Object)roleName));
                                    }
                                    continue;
                                }
                                pattern = Pattern.create((String)permission);
                                providedPrivileges = actions.indexLikeActionsPerformanceCritical().matching(a -> pattern.matches(a.name()));
                                for (Meta.Alias alias : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    alias.resolveDeepToNames(Meta.Alias.ResolutionMode.NORMAL).forEach(arg_0 -> Index.lambda$new$6((ImmutableSet)providedPrivileges, actionToIndexToRoles, roleName, arg_0));
                                }
                            }
                        }
                        if ((long)(roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize()) <= statefulIndexMaxHeapSize.getBytes()) continue;
                        log.info("Size of precomputed index privileges exceeds configured limit ({}). Using capped data structure.This might lead to slightly lower performance during privilege evaluation. Consider raising {} or closing unneeded indices.", (Object)statefulIndexMaxHeapSize, PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE);
                        break;
                    }
                    catch (ConfigValidationException e) {
                        log.error("Invalid pattern in role: {}\nThis should have been caught before. Ignoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
                this.estimatedByteSize = roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize();
                this.actionToIndexToRoles = actionToIndexToRoles.build(b -> b.build(subSetBuilder -> subSetBuilder.build(completedRoleSetBuilder)));
                this.indexMetadata = indexMetadata;
                this.universallyDeniedIndices = universallyDeniedIndices;
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(ImmutableList.Builder::build);
                this.componentState = componentState;
                this.componentState.setConfigVersion(roles.getDocVersion());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.setInitialized();
                    this.componentState.setMessage("Initialized with " + indexMetadata);
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                    this.componentState.setMessage("Roles with initialization errors: " + this.rolesToInitializationErrors.keySet());
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
                this.componentState.addMetrics("estimated_byte_size", (Measurement)new Count((long)this.estimatedByteSize));
            }

            PrivilegesEvaluationResult hasPermission(User user, ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions, ResolvedIndices resolvedIndices, PrivilegesEvaluationContext context, CheckTable<Meta.IndexLikeObject, Action> checkTable, Collection<Meta.Index> indices) throws PrivilegesEvaluationException {
                if (indices.isEmpty()) {
                    return null;
                }
                block0: for (Action action : actions) {
                    Map indexToRoles;
                    if (!(action instanceof Action.WellKnownAction) || !((Action.WellKnownAction)action).isPerformanceCritical() || (indexToRoles = (Map)this.actionToIndexToRoles.get((Object)action)) == null) continue;
                    for (Meta.Index index : indices) {
                        ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)indexToRoles.get(index.name());
                        if (rolesWithPrivileges == null || !rolesWithPrivileges.containsAny(mappedRoles) || this.isExcluded(action, index.name(), user, mappedRoles, context) || !checkTable.check((Object)index, (Object)action)) continue;
                        break block0;
                    }
                }
                if (checkTable.isComplete()) {
                    return PrivilegesEvaluationResult.OK;
                }
                return null;
            }

            private boolean isExcluded(Action action, String index, User user, ImmutableSet<String> mappedRoles, PrivilegesEvaluationContext context) {
                return this.universallyDeniedIndices.matches(index);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }

            private static /* synthetic */ void lambda$new$6(ImmutableSet providedPrivileges, ImmutableMap.Builder actionToIndexToRoles, String roleName, String index) {
                for (Action.WellKnownAction action : providedPrivileges) {
                    ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToIndexToRoles.get((Object)action)).get((Object)index)).add((Object)roleName);
                }
            }
        }

        static class Alias
        implements ComponentStateProvider {
            private final ImmutableMap<Action.WellKnownAction<?, ?, ?>, Map<String, ImmutableCompactSubSet<String>>> actionToAliasToRoles;
            private final Meta indexMetadata;
            private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final ComponentState componentState;
            private final Pattern universallyDeniedIndices;
            private final int estimatedByteSize;

            Alias(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta indexMetadata, Pattern universallyDeniedIndices, ByteSizeValue statefulIndexMaxHeapSize, ComponentState componentState) {
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder indexMapBuilder = new CompactMapGroupBuilder((Set)indexMetadata.indexLikeObjects().keySet(), k2 -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder actionToAliasToRoles = new ImmutableMap.Builder().defaultValue(k -> indexMapBuilder.createMapBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                block3: for (String roleName : roleNames) {
                    try {
                        Role role = roles.getCEntry(roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.Alias aliasPermissions : role.getAliasPermissions()) {
                            ImmutableSet<String> permissions = actionGroups.resolve((Collection<String>)aliasPermissions.getAllowedActions());
                            Pattern indexPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                            for (String permission : permissions) {
                                if (Pattern.isConstant((String)permission)) {
                                    Action action = actions.get(permission);
                                    if (!(action instanceof Action.WellKnownAction)) continue;
                                    for (Meta.Alias alias : indexPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToAliasToRoles.get((Object)((Action.WellKnownAction)action))).get((Object)alias.name())).add((Object)roleName);
                                    }
                                    continue;
                                }
                                Pattern pattern = Pattern.create((String)permission);
                                ImmutableSet providedPrivileges = actions.indexLikeActionsPerformanceCritical().matching(a -> pattern.matches(a.name()));
                                for (Meta.Alias alias : indexPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    for (Action.WellKnownAction action : providedPrivileges) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToAliasToRoles.get((Object)action)).get((Object)alias.name())).add((Object)roleName);
                                    }
                                }
                            }
                            if ((long)(roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize()) <= statefulIndexMaxHeapSize.getBytes()) continue;
                            log.info("Size of precomputed index privileges exceeds configured limit ({}). Using capped data structure.This might lead to slightly lower performance during privilege evaluation. Consider raising {} or closing unneeded indices.", (Object)statefulIndexMaxHeapSize, PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE);
                            break block3;
                        }
                    }
                    catch (ConfigValidationException e) {
                        log.error("Invalid pattern in role: {}\nThis should have been caught before. Ignoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
                this.estimatedByteSize = roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize();
                this.actionToAliasToRoles = actionToAliasToRoles.build(b -> b.build(subSetBuilder -> subSetBuilder.build(completedRoleSetBuilder)));
                this.indexMetadata = indexMetadata;
                this.universallyDeniedIndices = universallyDeniedIndices;
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(ImmutableList.Builder::build);
                this.componentState = componentState;
                this.componentState.setConfigVersion(roles.getDocVersion());
                this.componentState.setConfigProperty("es_metadata_version", (Object)indexMetadata.version());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.setInitialized();
                    this.componentState.setMessage("Initialized with " + indexMetadata.aliases().size());
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                    this.componentState.setMessage("Roles with initialization errors: " + this.rolesToInitializationErrors.keySet());
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
                this.componentState.addMetrics("estimated_byte_size", (Measurement)new Count((long)this.estimatedByteSize));
            }

            PrivilegesEvaluationResult hasPermission(User user, ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions, ResolvedIndices resolvedIndices, PrivilegesEvaluationContext context, CheckTable<Meta.IndexLikeObject, Action> checkTable) throws PrivilegesEvaluationException {
                ImmutableSet<Meta.Alias> aliases = resolvedIndices.getLocal().getAliases();
                if (aliases.isEmpty()) {
                    return null;
                }
                block0: for (Action action : actions) {
                    Map aliasToRoles;
                    if (!(action instanceof Action.WellKnownAction) || !((Action.WellKnownAction)action).isPerformanceCritical() || (aliasToRoles = (Map)this.actionToAliasToRoles.get((Object)action)) == null) continue;
                    for (Meta.Alias alias : aliases) {
                        ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)aliasToRoles.get(alias.name());
                        if (rolesWithPrivileges == null || !rolesWithPrivileges.containsAny(mappedRoles) || this.isExcluded(action, alias.name(), user, mappedRoles, context) || !checkTable.check((Object)alias, (Object)action)) continue;
                        break block0;
                    }
                }
                if (checkTable.isComplete()) {
                    return PrivilegesEvaluationResult.OK;
                }
                return null;
            }

            private boolean isExcluded(Action action, String index, User user, ImmutableSet<String> mappedRoles, PrivilegesEvaluationContext context) {
                return this.universallyDeniedIndices.matches(index);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }
        }

        static class DataStream
        implements ComponentStateProvider {
            private final ImmutableMap<Action.WellKnownAction<?, ?, ?>, Map<String, ImmutableCompactSubSet<String>>> actionToAliasToRoles;
            private final Meta indexMetadata;
            private final ImmutableMap<String, ImmutableList<Exception>> rolesToInitializationErrors;
            private final ComponentState componentState;
            private final Pattern universallyDeniedIndices;
            private final int estimatedByteSize;

            DataStream(SgDynamicConfiguration<Role> roles, ActionGroup.FlattenedIndex actionGroups, Actions actions, Meta indexMetadata, Pattern universallyDeniedIndices, ByteSizeValue statefulIndexMaxHeapSize, ComponentState componentState) {
                IndexedImmutableSet roleNames = IndexedImmutableSet.of((Set)roles.getCEntries().keySet());
                DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder((Set)roleNames);
                CompactMapGroupBuilder indexMapBuilder = new CompactMapGroupBuilder((Set)indexMetadata.indexLikeObjects().keySet(), k2 -> roleSetBuilder.createSubSetBuilder());
                ImmutableMap.Builder actionToDataStreamToRoles = new ImmutableMap.Builder().defaultValue(k -> indexMapBuilder.createMapBuilder());
                ImmutableMap.Builder rolesToInitializationErrors = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
                ImmutableSet dataStreamNames = indexMetadata.dataStreams().map(Meta.IndexLikeObject::name);
                for (String roleName : roleNames) {
                    try {
                        Object providedPrivileges;
                        Pattern pattern;
                        Action action;
                        ImmutableSet<String> permissions;
                        Role role = (Role)roles.getCEntries().get((Object)roleName);
                        roleSetBuilder.next((Object)roleName);
                        for (Role.DataStream dataStreamPermissions : role.getDataStreamPermissions()) {
                            permissions = actionGroups.resolve((Collection<String>)dataStreamPermissions.getAllowedActions());
                            Pattern indexPattern = dataStreamPermissions.getIndexPatterns().getPattern();
                            if (indexPattern.isWildcard() || indexPattern.isBlank()) continue;
                            for (String permission : permissions) {
                                Object alias2;
                                if (Pattern.isConstant((String)permission)) {
                                    action = actions.get(permission);
                                    if (!(action instanceof Action.WellKnownAction)) continue;
                                    for (Object alias2 : indexPattern.iterateMatching((Iterable)dataStreamNames)) {
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToDataStreamToRoles.get((Object)((Action.WellKnownAction)action))).get(alias2)).add((Object)roleName);
                                    }
                                    continue;
                                }
                                pattern = Pattern.create((String)permission);
                                providedPrivileges = actions.indexLikeActionsPerformanceCritical().matching(a -> pattern.matches(a.name()));
                                alias2 = indexPattern.iterateMatching((Iterable)dataStreamNames).iterator();
                                while (alias2.hasNext()) {
                                    String alias3 = (String)alias2.next();
                                    UnmodifiableIterator unmodifiableIterator = providedPrivileges.iterator();
                                    while (unmodifiableIterator.hasNext()) {
                                        Action.WellKnownAction action2 = (Action.WellKnownAction)unmodifiableIterator.next();
                                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToDataStreamToRoles.get((Object)action2)).get((Object)alias3)).add((Object)roleName);
                                    }
                                }
                            }
                        }
                        for (Role.Alias aliasPermissions : role.getAliasPermissions()) {
                            permissions = actionGroups.resolve((Collection<String>)aliasPermissions.getAllowedActions());
                            Pattern aliasPattern = aliasPermissions.getIndexPatterns().getPattern();
                            if (aliasPattern.isWildcard() || aliasPattern.isBlank()) continue;
                            for (String permission : permissions) {
                                if (Pattern.isConstant((String)permission)) {
                                    action = actions.get(permission);
                                    if (!(action instanceof Action.WellKnownAction)) continue;
                                    for (Object alias2 : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                        alias2.members().forEach(indexLikeObject -> {
                                            if (indexLikeObject instanceof DataStream) {
                                                ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToDataStreamToRoles.get((Object)((Action.WellKnownAction)action))).get((Object)indexLikeObject.name())).add((Object)roleName);
                                            }
                                        });
                                    }
                                    continue;
                                }
                                pattern = Pattern.create((String)permission);
                                providedPrivileges = actions.indexLikeActionsPerformanceCritical().matching(a -> pattern.matches(a.name()));
                                for (String alias3 : aliasPattern.iterateMatching((Iterable)indexMetadata.aliases(), Meta.IndexLikeObject::name)) {
                                    alias3.members().forEach(arg_0 -> DataStream.lambda$new$6((ImmutableSet)providedPrivileges, actionToDataStreamToRoles, roleName, arg_0));
                                }
                            }
                        }
                        if ((long)(roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize()) <= statefulIndexMaxHeapSize.getBytes()) continue;
                        log.info("Size of precomputed index privileges exceeds configured limit ({}). Using capped data structure.This might lead to slightly lower performance during privilege evaluation. Consider raising {} or closing unneeded indices.", (Object)statefulIndexMaxHeapSize, PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE);
                        break;
                    }
                    catch (ConfigValidationException e) {
                        log.error("Invalid pattern in role: {}\nThis should have been caught before. Ignoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)roleName, (Object)e);
                        ((ImmutableList.Builder)rolesToInitializationErrors.get((Object)roleName)).with((Object)e);
                    }
                }
                DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
                this.estimatedByteSize = roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize();
                this.actionToAliasToRoles = actionToDataStreamToRoles.build(b -> b.build(subSetBuilder -> subSetBuilder.build(completedRoleSetBuilder)));
                this.indexMetadata = indexMetadata;
                this.universallyDeniedIndices = universallyDeniedIndices;
                this.rolesToInitializationErrors = rolesToInitializationErrors.build(ImmutableList.Builder::build);
                this.componentState = componentState;
                this.componentState.setConfigVersion(roles.getDocVersion());
                this.componentState.setConfigProperty("es_metadata_version", (Object)indexMetadata.version());
                if (this.rolesToInitializationErrors.isEmpty()) {
                    this.componentState.setInitialized();
                    this.componentState.setMessage("Initialized with " + dataStreamNames.size() + " data streams");
                } else {
                    this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "contains_invalid_roles");
                    this.componentState.setMessage("Roles with initialization errors: " + this.rolesToInitializationErrors.keySet());
                    this.componentState.addDetail((Object)rolesToInitializationErrors);
                }
            }

            PrivilegesEvaluationResult hasPermission(User user, ImmutableSet<String> mappedRoles, ImmutableSet<Action> actions, ResolvedIndices resolvedIndices, PrivilegesEvaluationContext context, CheckTable<Meta.IndexLikeObject, Action> checkTable) throws PrivilegesEvaluationException {
                ImmutableSet<Meta.DataStream> dataStreams = resolvedIndices.getLocal().getDataStreams();
                if (dataStreams.isEmpty()) {
                    return null;
                }
                block0: for (Action action : actions) {
                    Map aliasToRoles;
                    if (!(action instanceof Action.WellKnownAction) || !((Action.WellKnownAction)action).isPerformanceCritical() || (aliasToRoles = (Map)this.actionToAliasToRoles.get((Object)action)) == null) continue;
                    for (Meta.DataStream dataStream : dataStreams) {
                        ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)aliasToRoles.get(dataStream.name());
                        if (rolesWithPrivileges == null || !rolesWithPrivileges.containsAny(mappedRoles) || this.isExcluded(action, dataStream.name(), user, mappedRoles, context) || !checkTable.check((Object)dataStream, (Object)action)) continue;
                        break block0;
                    }
                }
                if (checkTable.isComplete()) {
                    return PrivilegesEvaluationResult.OK;
                }
                return null;
            }

            private boolean isExcluded(Action action, String index, User user, ImmutableSet<String> mappedRoles, PrivilegesEvaluationContext context) {
                return this.universallyDeniedIndices.matches(index);
            }

            public ComponentState getComponentState() {
                return this.componentState;
            }

            private static /* synthetic */ void lambda$new$6(ImmutableSet providedPrivileges, ImmutableMap.Builder actionToDataStreamToRoles, String roleName, Meta.IndexLikeObject indexLikeObject) {
                if (indexLikeObject instanceof DataStream) {
                    for (Action.WellKnownAction action : providedPrivileges) {
                        ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)((CompactMapGroupBuilder.MapBuilder)actionToDataStreamToRoles.get((Object)action)).get((Object)indexLikeObject.name())).add((Object)roleName);
                    }
                }
            }
        }
    }

    static class LocalContext {
        ImmutableList<PrivilegesEvaluationResult.Error> errors;

        LocalContext() {
            this.errors = ImmutableList.empty();
        }

        LocalContext(ImmutableList<PrivilegesEvaluationResult.Error> initialErrors) {
            this.errors = initialErrors;
        }

        void add(PrivilegesEvaluationResult.Error error) {
            this.errors = this.errors.with((Object)error);
        }
    }

    static class IndexPattern {
        private final Pattern pattern;
        private final ImmutableList<Role.IndexPatterns.IndexPatternTemplate> patternTemplates;
        private final ImmutableList<Role.IndexPatterns.DateMathExpression> dateMathExpressions;

        IndexPattern(Pattern pattern, ImmutableList<Role.IndexPatterns.IndexPatternTemplate> patternTemplates, ImmutableList<Role.IndexPatterns.DateMathExpression> dateMathExpressions) {
            this.pattern = pattern;
            this.patternTemplates = patternTemplates;
            this.dateMathExpressions = dateMathExpressions;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(String index, User user, PrivilegesEvaluationContext context, Meter meter) throws PrivilegesEvaluationException {
            Pattern pattern2;
            if (this.pattern.matches(index)) {
                return true;
            }
            if (!this.patternTemplates.isEmpty()) {
                for (Role.IndexPatterns.IndexPatternTemplate patternTemplate : this.patternTemplates) {
                    Meter subMeter;
                    block20: {
                        subMeter = meter.basic("render_index_pattern_template");
                        pattern2 = context.getRenderedPattern(patternTemplate.getTemplate());
                        if (!pattern2.matches(index) || patternTemplate.getExclusions().matches(index)) break block20;
                        boolean bl = true;
                        if (subMeter == null) return bl;
                        subMeter.close();
                        return bl;
                    }
                    try {
                        if (subMeter == null) continue;
                        subMeter.close();
                        continue;
                        {
                            catch (Throwable pattern2) {
                                if (subMeter == null) throw pattern2;
                                try {
                                    subMeter.close();
                                    throw pattern2;
                                }
                                catch (Throwable throwable) {
                                    pattern2.addSuppressed(throwable);
                                }
                                throw pattern2;
                            }
                        }
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new PrivilegesEvaluationException("Error while evaluating dynamic index pattern: " + patternTemplate, e);
                    }
                }
            }
            if (this.dateMathExpressions.isEmpty()) return false;
            try (Meter subMeter = meter.basic("render_date_math_expression");){
                for (Role.IndexPatterns.DateMathExpression dateMathExpression : this.dateMathExpressions) {
                    try {
                        pattern2 = context.getRenderedDateMathExpression(dateMathExpression.getDateMathExpression());
                        if (!pattern2.matches(index) || dateMathExpression.getExclusions().matches(index)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        throw new PrivilegesEvaluationException("Error while evaluating date math expression: " + dateMathExpression, e);
                        return false;
                    }
                }
            }
        }

        public boolean matches(Iterable<String> indices, User user, PrivilegesEvaluationContext context, Meter meter) throws PrivilegesEvaluationException {
            for (String index : indices) {
                if (!this.matches(index, user, context, meter)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.pattern != null && this.patternTemplates != null && this.patternTemplates.size() != 0) {
                return this.pattern + " " + this.patternTemplates;
            }
            if (this.pattern != null) {
                return this.pattern.toString();
            }
            if (this.patternTemplates != null) {
                return this.patternTemplates.toString();
            }
            return "-/-";
        }

        static class Builder {
            private List<Pattern> constantPatterns = new ArrayList<Pattern>();
            private List<Role.IndexPatterns.IndexPatternTemplate> patternTemplates = new ArrayList<Role.IndexPatterns.IndexPatternTemplate>();
            private List<Role.IndexPatterns.DateMathExpression> dateMathExpressions = new ArrayList<Role.IndexPatterns.DateMathExpression>();

            Builder() {
            }

            void add(Role.IndexPatterns indexPattern) {
                this.constantPatterns.add(indexPattern.getPattern());
                this.patternTemplates.addAll((Collection<Role.IndexPatterns.IndexPatternTemplate>)indexPattern.getPatternTemplates());
                this.dateMathExpressions.addAll((Collection<Role.IndexPatterns.DateMathExpression>)indexPattern.getDateMathExpressions());
            }

            IndexPattern build() {
                return new IndexPattern(Pattern.join(this.constantPatterns), (ImmutableList<Role.IndexPatterns.IndexPatternTemplate>)ImmutableList.of(this.patternTemplates), (ImmutableList<Role.IndexPatterns.DateMathExpression>)ImmutableList.of(this.dateMathExpressions));
            }
        }
    }
}

