/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import inet.ipaddr.Address;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressTrie;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressTrie;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPAddressCollection
implements Document<IPAddressCollection> {
    private static final Logger log = LogManager.getLogger(IPAddressCollection.class);
    private final List<String> source;
    private final IPv4AddressTrie ipv4trie;
    private final IPv6AddressTrie ipv6trie;

    public IPAddressCollection(IPv4AddressTrie ipv4trie, IPv6AddressTrie ipv6trie, List<String> source) {
        this.ipv4trie = ipv4trie.size() > 0 ? ipv4trie : null;
        this.ipv6trie = ipv6trie.size() > 0 ? ipv6trie : null;
        this.source = source;
    }

    public boolean contains(IPAddress ipAddress) {
        IPv6Address ipv6Address;
        IPv4Address ipv4Address;
        if (this.ipv4trie != null && (ipv4Address = ipAddress.toIPv4()) != null && this.ipv4trie.elementsContaining(ipv4Address) != null) {
            return true;
        }
        return this.ipv6trie != null && (ipv6Address = ipAddress.toIPv6()) != null && this.ipv6trie.elementsContaining(ipv6Address) != null;
    }

    public static IPAddressCollection parse(DocNode docNode) throws ConfigValidationException {
        if (docNode.isNull()) {
            return null;
        }
        if (docNode.isString()) {
            return IPAddressCollection.parse(Collections.singletonList(docNode.toString()));
        }
        if (docNode.isList()) {
            return IPAddressCollection.parse((List<String>)docNode.toListOfStrings());
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"A list of IP addresses or netmasks in CIDR notation"));
    }

    public static IPAddressCollection parse(List<String> ipStringList) throws ConfigValidationException {
        IPv4AddressTrie ipv4trie = new IPv4AddressTrie();
        IPv6AddressTrie ipv6trie = new IPv6AddressTrie();
        ValidationErrors validationErrors = new ValidationErrors();
        int i = 0;
        for (String string : ipStringList) {
            try {
                IPAddressString ipAddressString = new IPAddressString(string);
                ipAddressString.validate();
                IPAddress ipAddress = ipAddressString.getAddress();
                if (ipAddress instanceof IPv4Address) {
                    ipv4trie.add((Address)((IPv4Address)ipAddress));
                } else if (ipAddress instanceof IPv6Address) {
                    ipv6trie.add((Address)((IPv6Address)ipAddress));
                }
            }
            catch (AddressStringException e) {
                validationErrors.add(new InvalidAttributeValue(String.valueOf(i), (Object)string, (Object)"IP address or netmask in CIDR notation").cause((Throwable)e));
                log.info("Configuration error; invalid ip address:" + string, (Throwable)e);
            }
            ++i;
        }
        validationErrors.throwExceptionForPresentErrors();
        return new IPAddressCollection(ipv4trie, ipv6trie, ipStringList);
    }

    public String toString() {
        if (this.ipv4trie == null && this.ipv6trie == null) {
            return "Empty IPAddressCollection";
        }
        if (this.ipv4trie == null) {
            return this.ipv6trie.toString();
        }
        if (this.ipv6trie == null) {
            return this.ipv4trie.toString();
        }
        return "IPAddressCollection [ipv4trie=" + this.ipv4trie + ", ipv6trie=" + this.ipv6trie + "]";
    }

    public Object toBasicObject() {
        return this.source;
    }

    public List<String> getSource() {
        return this.source;
    }
}

