/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.fluent.collections.ImmutableMap;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;

public class Attributes {
    public static final String FRONTEND_CONFIG_ID = "__fe_cnf_id";
    public static final String AUTH_TYPE = "__auth_type";
    private static final Logger log = LogManager.getLogger(Attributes.class);
    private static final Configuration JSON_PATH_CONFIG = BasicJsonPathDefaultConfiguration.defaultConfiguration().setOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});

    public static Map<String, JsonPath> getAttributeMapping(Settings settings) {
        HashMap<String, JsonPath> result = new HashMap<String, JsonPath>();
        if (settings == null) {
            return result;
        }
        for (String key : settings.keySet()) {
            try {
                result.put(key, JsonPath.compile((String)settings.get(key), (Predicate[])new Predicate[0]));
            }
            catch (InvalidPathException e) {
                log.error("Error in configuration: Invalid JSON path supplied for " + key, (Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, String> getFlatAttributeMapping(Settings settings) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (settings == null) {
            return result;
        }
        for (String key : settings.keySet()) {
            result.put(key, settings.get(key));
        }
        return result;
    }

    public static void validate(Object value) {
        Attributes.validate(value, 0);
    }

    static void addAttributesByJsonPath(Map<String, JsonPath> jsonPathMap, Object source, Map<String, Object> target) {
        for (Map.Entry<String, JsonPath> entry : jsonPathMap.entrySet()) {
            Object values = JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(source).read(entry.getValue());
            try {
                Attributes.validate(values);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchSecurityException("Error while initializing user attributes. Mapping for " + entry.getKey() + " produced invalid values:\n" + e.getMessage(), (Exception)e, new Object[0]);
            }
            target.put(entry.getKey(), values);
        }
    }

    static void addAttributesByJsonPath(Map<String, JsonPath> jsonPathMap, Object source, ImmutableMap.Builder<String, Object> target) {
        for (Map.Entry<String, JsonPath> entry : jsonPathMap.entrySet()) {
            Object values = JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(source).read(entry.getValue());
            try {
                Attributes.validate(values);
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchSecurityException("Error while initializing user attributes. Mapping for " + entry.getKey() + " produced invalid values:\n" + e.getMessage(), (Exception)e, new Object[0]);
            }
            target.put((Object)entry.getKey(), values);
        }
    }

    private static void validate(Object value, int depth) {
        if (depth > 10) {
            throw new IllegalArgumentException("Value exceeds max allowed nesting (or the value contains loops)");
        }
        if (value == null) {
            return;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return;
        }
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                Attributes.validate(element, depth + 1);
            }
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Attributes.validate(entry.getKey(), depth + 1);
                Attributes.validate(entry.getValue(), depth + 1);
            }
        } else {
            throw new IllegalArgumentException("Illegal value type. In user attributes the only allowed types are: String, Number, Boolean, Character, Collection, Map. Got: " + value);
        }
    }
}

