/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.jira;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class JiraIssueApiCall
implements ToXContentObject {
    private String project;
    private String parent;
    private String summary;
    private String description;
    private String issueType;
    private String priority;
    private List<String> components;
    private List<String> labels;
    private Map<Integer, Object> customFields;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("fields");
        builder.startObject();
        builder.field("project").startObject().field("key", this.project).endObject();
        if (this.parent != null) {
            builder.field("parent").startObject().field("key", this.parent).endObject();
        }
        if (this.priority != null) {
            builder.field("priority").startObject().field("name", this.priority).endObject();
        }
        builder.field("summary", this.summary);
        builder.field("description", this.description);
        builder.field("issuetype").startObject().field("name", this.issueType).endObject();
        if (this.components != null && this.components.size() > 0) {
            builder.field("components");
            builder.startArray();
            for (String string : this.components) {
                builder.startObject();
                builder.field("name", string);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.labels != null && this.labels.size() > 0) {
            builder.field("labels", this.labels);
        }
        if (this.customFields != null) {
            for (Map.Entry entry : this.customFields.entrySet()) {
                builder.field("customfield_" + entry.getKey(), entry.getValue());
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Map<Integer, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<Integer, Object> customFields) {
        this.customFields = customFields;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }
}

