/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchsupport.rest.AttributedHttpRequest;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.IncrementalBulkService;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.transport.netty4.TLSConfig;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardSSLNettyHttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SearchGuardSSLNettyHttpServerTransport.class);
    private final SearchGuardKeyStore sgks;
    private final SslExceptionHandler errorHandler;
    private final BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext;
    private final IncrementalBulkService.Enabled incrementalBulkServiceEnabled;

    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, ThreadPool threadPool, SearchGuardKeyStore sgks, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, SslExceptionHandler errorHandler, Tracer tracer, BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext) {
        super(settings, networkService, threadPool, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, tracer, TLSConfig.noTLS(), null, null);
        this.sgks = sgks;
        this.errorHandler = errorHandler;
        this.perRequestThreadContext = perRequestThreadContext;
        this.incrementalBulkServiceEnabled = new IncrementalBulkService.Enabled(clusterSettings);
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        SslHandler sslhandler = (SslHandler)((Netty4HttpChannel)httpChannel).getNettyChannel().pipeline().get("ssl_http");
        ImmutableMap attributes = ImmutableMap.of((Object)"sg_ssl_handler", (Object)sslhandler);
        super.incomingRequest((HttpRequest)AttributedHttpRequest.create((HttpRequest)httpRequest, (ImmutableMap)attributes), httpChannel);
    }

    protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
        this.perRequestThreadContext.accept((HttpPreRequest)restRequest.getHttpRequest(), threadContext);
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.handlingSettings, this.sgks, this.incrementalBulkServiceEnabled);
    }

    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException && cause0 != null) {
            cause = cause0.getCause();
        }
        this.errorHandler.logError(cause, true);
        if (logger.isDebugEnabled()) {
            logger.debug("Exception during establishing a SSL connection: " + cause, cause);
        }
        super.onException(channel, cause0);
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings, SearchGuardKeyStore sgks, IncrementalBulkService.Enabled enabled) {
            super(transport, handlingSettings, TLSConfig.noTLS(), null, null, enabled);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyHttpServerTransport.this.sgks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

