/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.util.ByteString;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base64EncodingStrategy
implements Serializable {
    @NotNull
    public static final Base64EncodingStrategy DEFAULT = new Base64EncodingStrategy(true, true, true, true);
    @NotNull
    public static final Base64EncodingStrategy MINIMAL_COMPLIANT = new Base64EncodingStrategy(false, true, true, true);
    @NotNull
    public static final Base64EncodingStrategy USER_FRIENDLY_NON_COMPLIANT = new Base64EncodingStrategy(true, false, true, true);
    @NotNull
    public static final Base64EncodingStrategy MAXIMAL = DEFAULT;
    private static final long serialVersionUID = -5787811215448347345L;
    private final boolean encodeASCIIControlCharacters;
    private final boolean encodeDisplayableNonASCIICharacters;
    private final boolean encodeNonDisplayableNonASCIICharacters;
    private final boolean encodeNonUTF8Data;

    public Base64EncodingStrategy(boolean encodeASCIIControlCharacters, boolean encodeDisplayableNonASCIICharacters, boolean encodeNonDisplayableNonASCIICharacters, boolean encodeNonUTF8Data) {
        this.encodeASCIIControlCharacters = encodeASCIIControlCharacters;
        this.encodeDisplayableNonASCIICharacters = encodeDisplayableNonASCIICharacters;
        this.encodeNonDisplayableNonASCIICharacters = encodeNonDisplayableNonASCIICharacters;
        this.encodeNonUTF8Data = encodeNonUTF8Data;
    }

    public boolean encodeASCIIControlCharacters() {
        return this.encodeASCIIControlCharacters;
    }

    public boolean encodeDisplayableNonASCIICharacters() {
        return this.encodeDisplayableNonASCIICharacters;
    }

    public boolean encodeNonDisplayableNonASCIICharacters() {
        return this.encodeNonDisplayableNonASCIICharacters;
    }

    public boolean encodeNonUTF8Data() {
        return this.encodeNonUTF8Data;
    }

    public boolean shouldBase64Encode(@NotNull byte[] value) {
        if (value == null || value.length == 0) {
            return false;
        }
        switch (value[0]) {
            case 32: 
            case 58: 
            case 60: {
                return true;
            }
        }
        if (value[value.length - 1] == 32) {
            return true;
        }
        for (int i = 0; i < value.length; ++i) {
            byte b = value[i];
            if (b >= 0 && b <= 31) {
                switch (b) {
                    case 0: 
                    case 10: 
                    case 13: {
                        return true;
                    }
                }
                if (!this.encodeASCIIControlCharacters) continue;
                return true;
            }
            if (b == 127) {
                if (!this.encodeASCIIControlCharacters) continue;
                return true;
            }
            if (b >= 0) continue;
            byte[] remainingBytes = new byte[value.length - i];
            System.arraycopy(value, i, remainingBytes, 0, remainingBytes.length);
            if (StaticUtils.isValidUTF8(remainingBytes)) {
                String valueString = StaticUtils.toUTF8String(remainingBytes);
                return this.shouldBase64EncodePreValidatedString(valueString);
            }
            return this.encodeNonUTF8Data;
        }
        return false;
    }

    public boolean shouldBase64Encode(@NotNull String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        switch (value.charAt(0)) {
            case ' ': 
            case ':': 
            case '<': {
                return true;
            }
        }
        if (value.charAt(value.length() - 1) == ' ') {
            return true;
        }
        return this.shouldBase64EncodePreValidatedString(value);
    }

    private boolean shouldBase64EncodePreValidatedString(@NotNull String s) {
        int charsPerCodePoint;
        for (int pos = 0; pos < s.length(); pos += charsPerCodePoint) {
            int codePoint = s.codePointAt(pos);
            if (codePoint <= 31) {
                switch (codePoint) {
                    case 0: 
                    case 10: 
                    case 13: {
                        return true;
                    }
                }
                if (this.encodeASCIIControlCharacters) {
                    return true;
                }
            } else if (codePoint == 127 ? this.encodeASCIIControlCharacters : codePoint > 127 && (StaticUtils.isLikelyDisplayableCharacter(codePoint) ? this.encodeDisplayableNonASCIICharacters : this.encodeNonDisplayableNonASCIICharacters)) {
                return true;
            }
            charsPerCodePoint = Character.charCount(codePoint);
        }
        return false;
    }

    public boolean shouldBase64Encode(@NotNull ByteString value) {
        return this.shouldBase64Encode(value.getValue());
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Base64EncodingStrategy(encodeASCIIControlCharacters=");
        buffer.append(this.encodeASCIIControlCharacters);
        buffer.append(", encodeDisplayableNonASCIICharacters=");
        buffer.append(this.encodeDisplayableNonASCIICharacters);
        buffer.append(", encodeNonDisplayableNonASCIICharacters=");
        buffer.append(this.encodeNonDisplayableNonASCIICharacters);
        buffer.append(", encodeNonUTF8Data=");
        buffer.append(this.encodeNonUTF8Data);
        buffer.append(')');
    }
}

