/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.actions;

import com.floragunn.searchsupport.jobs.actions.CheckForExecutingTriggerRequest;
import com.floragunn.searchsupport.jobs.actions.CheckForExecutingTriggerResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.impl.DirectSchedulerFactory;

public class TransportCheckForExecutingTriggerAction
extends TransportNodesAction<CheckForExecutingTriggerRequest, CheckForExecutingTriggerResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportCheckForExecutingTriggerAction.class);

    @Inject
    public TransportCheckForExecutingTriggerAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/searchsupport/scheduler/executing_triggers/check", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
    }

    protected CheckForExecutingTriggerResponse newResponse(CheckForExecutingTriggerRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new CheckForExecutingTriggerResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        try {
            Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(request.schedulerName);
            if (scheduler == null) {
                return new NodeResponse(this.clusterService.localNode(), new ArrayList<String>());
            }
            List executingJobs = scheduler.getCurrentlyExecutingJobs();
            if (executingJobs.size() == 0) {
                return new NodeResponse(this.clusterService.localNode(), new ArrayList<String>());
            }
            HashSet<String> requestedTriggerKeys = new HashSet<String>(request.triggerKeys);
            ArrayList<String> foundTriggerKeys = new ArrayList<String>(requestedTriggerKeys.size());
            for (JobExecutionContext executingJob : executingJobs) {
                String triggerKey;
                if (executingJob.getTrigger() == null || !requestedTriggerKeys.contains(triggerKey = executingJob.getTrigger().getKey().toString())) continue;
                foundTriggerKeys.add(triggerKey);
            }
            return new NodeResponse(localNode, foundTriggerKeys);
        }
        catch (Exception e) {
            log.error("Error while retrieving running triggers", (Throwable)e);
            return new NodeResponse(localNode, new ArrayList<String>(), e.toString());
        }
    }

    protected NodeRequest newNodeRequest(CheckForExecutingTriggerRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    public static class NodeRequest
    extends TransportRequest {
        private String schedulerName;
        private List<String> triggerKeys;

        public NodeRequest(CheckForExecutingTriggerRequest request) {
            this.schedulerName = request.getSchedulerName();
            this.triggerKeys = request.getTriggerKeys();
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.schedulerName = in.readString();
            this.triggerKeys = in.readStringCollectionAsList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.schedulerName);
            out.writeStringCollection(this.triggerKeys);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private List<String> executingTriggers;
        private String message;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.executingTriggers = in.readStringCollectionAsList();
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node, List<String> executingTriggers) {
            super(node);
            this.executingTriggers = executingTriggers;
        }

        public NodeResponse(DiscoveryNode node, List<String> executingTriggers, String message) {
            super(node);
            this.executingTriggers = executingTriggers;
            this.message = message;
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.executingTriggers);
            out.writeOptionalString(this.message);
        }

        public List<String> getExecutingTriggers() {
            return this.executingTriggers;
        }

        public void setExecutingTriggers(List<String> executingTriggers) {
            this.executingTriggers = executingTriggers;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "NodeResponse [executingTriggers=" + this.executingTriggers + ", message=" + this.message + "]";
        }
    }
}

