/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.action;

import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.xcontent.XContentConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xcontent.ToXContent;

public class RestApi
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestApi.class);
    private final Map<RestRequest.Method, List<Endpoint>> methodToEndpointMap = new EnumMap<RestRequest.Method, List<Endpoint>>(RestRequest.Method.class);
    private ImmutableMap<String, String> staticResponseHeaders = ImmutableMap.empty();
    private String name;
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([^\\}]*)\\}");

    public String getName() {
        return this.name;
    }

    public final List<RestHandler.Route> routes() {
        ArrayList<RestHandler.Route> routes = new ArrayList<RestHandler.Route>();
        for (List<Endpoint> endpoints : this.methodToEndpointMap.values()) {
            for (Endpoint endpoint : endpoints) {
                for (String route : endpoint.routes) {
                    routes.add(new RestHandler.Route(endpoint.platformMethod, route));
                }
            }
        }
        return routes;
    }

    public RestApi responseHeaders(Map<String, String> responseHeaders) {
        this.staticResponseHeaders = this.staticResponseHeaders.with(ImmutableMap.of(responseHeaders));
        return this;
    }

    public RestApi responseHeader(String name, String value) {
        this.staticResponseHeaders = this.staticResponseHeaders.with((Object)name, (Object)value);
        return this;
    }

    public Endpoint handlesGet(String routes) {
        return new Endpoint(Method.GET, routes);
    }

    public Endpoint handlesPost(String routes) {
        return new Endpoint(Method.POST, routes);
    }

    public Endpoint handlesPut(String routes) {
        return new Endpoint(Method.PUT, routes);
    }

    public Endpoint handlesPatch(String routes) {
        return new Endpoint(Method.PATCH, routes);
    }

    public Endpoint handlesDelete(String routes) {
        return new Endpoint(Method.DELETE, routes);
    }

    public RestApi name(String name) {
        this.name = name;
        return this;
    }

    public static RestResponse toRestResponse(Action.Response response) {
        return RestApi.toRestResponse(response, true, (Map<String, String>)ImmutableMap.empty());
    }

    public static RestResponse toRestResponse(Action.Response response, boolean prettyPrintResponse, Map<String, String> responseHeaders) {
        Format responseDocType = Format.JSON;
        RestResponse restResponse = new RestResponse(response.status(), responseDocType.getMediaType(), DocWriter.format((Format)responseDocType).pretty(prettyPrintResponse).writeAsString((Document)response));
        if (response.getConcurrencyControlEntityTag() != null) {
            restResponse.addHeader("ETag", response.getConcurrencyControlEntityTag());
        }
        if (!responseHeaders.isEmpty()) {
            responseHeaders.forEach((k, v) -> restResponse.addHeader(k, v));
        }
        return restResponse;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Endpoint endpoint = this.chooseEndpoint(this.methodToEndpointMap.get(request.method()), request.path(), request.params());
        if (endpoint != null) {
            return endpoint.handler.apply(request, client);
        }
        return channel -> channel.sendResponse(new StandardResponse(405, "Method not allowed: " + request.method()).toRestResponse());
    }

    private void addEndpoint(Endpoint endpoint) {
        this.methodToEndpointMap.computeIfAbsent(endpoint.platformMethod, k -> new ArrayList(4)).add(endpoint);
    }

    private Endpoint chooseEndpoint(List<Endpoint> endpoints, String actualRoute, Map<String, String> params) {
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        if (endpoints.size() == 1) {
            return endpoints.get(0);
        }
        Endpoint bestMatch = null;
        int bestMatchSize = -1;
        for (Endpoint endpoint : endpoints) {
            int match;
            if (!actualRoute.startsWith(endpoint.paramlessPrefix) || (match = endpoint.matchParams(params)) == -1 || match <= bestMatchSize) continue;
            bestMatch = endpoint;
            bestMatchSize = match;
        }
        if (log.isDebugEnabled()) {
            if (bestMatch != null) {
                log.debug("Chose " + bestMatch + " based on " + params + " and " + bestMatch.requiredParams);
            } else {
                log.debug("Could not find endpoint for params " + params + "; params of available endpoints: " + endpoints.stream().map(e -> e.requiredParams).collect(Collectors.toList()));
            }
        }
        return bestMatch;
    }

    private static Set<String> getPathParamsFromRoute(String route) {
        if (route.indexOf(123) == -1) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = PATH_PARAM_PATTERN.matcher(route);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    private static String getParamlessPrefix(String route) {
        int firstParam = route.indexOf(123);
        if (firstParam == -1) {
            return route;
        }
        return route.substring(0, firstParam);
    }

    public class Endpoint {
        private final Method method;
        private final RestRequest.Method platformMethod;
        private final List<String> routes;
        private BiFunction<RestRequest, NodeClient, BaseRestHandler.RestChannelConsumer> handler;
        private final Set<String> requiredParams;
        private final String paramlessPrefix;

        public Endpoint(Method method, String route) {
            this.method = method;
            this.platformMethod = RestRequest.Method.valueOf((String)method.toString());
            this.routes = Collections.singletonList(route);
            this.requiredParams = RestApi.getPathParamsFromRoute(route);
            this.paramlessPrefix = RestApi.getParamlessPrefix(route);
        }

        public RestApi with(BiFunction<RestRequest, NodeClient, BaseRestHandler.RestChannelConsumer> handler) {
            this.handler = handler;
            RestApi.this.addEndpoint(this);
            return RestApi.this;
        }

        public <RequestType extends Action.Request, ResponseType extends Action.Response> RestApi with(Action<RequestType, ResponseType> action) {
            if (action == null) {
                throw new IllegalArgumentException("action must not be null");
            }
            return this.with((RestRequest restRequest, NodeClient client) -> {
                try {
                    String ifNoneMatchHeader;
                    final boolean prettyPrintResponse = restRequest.paramAsBoolean("pretty", false);
                    UnparsedDocument unparsedDoc = null;
                    if (restRequest.hasContent()) {
                        ContentType contentType = ContentType.parseHeader((String)restRequest.header("Content-Type"));
                        if (contentType == null) {
                            return channel -> channel.sendResponse(new StandardResponse(400, "Content-Type header is missing").toRestResponse());
                        }
                        unparsedDoc = UnparsedDocument.from((byte[])BytesReference.toBytes((BytesReference)restRequest.content()), (ContentType)contentType);
                    }
                    Object transportRequest = action.parseRequest(new Action.UnparsedMessage(unparsedDoc, DocNode.EMPTY));
                    String ifMatchHeader = restRequest.header("If-Match");
                    if (ifMatchHeader != null) {
                        ((Action.Request)((Object)((Object)transportRequest))).ifMatch(ifMatchHeader);
                    }
                    if ((ifNoneMatchHeader = restRequest.header("If-None-Match")) != null) {
                        ((Action.Request)((Object)((Object)transportRequest))).ifNoneMatch(ifNoneMatchHeader);
                    }
                    return channel -> client.execute((ActionType)action, (ActionRequest)transportRequest, (ActionListener)new RestResponseListener<ResponseType>((RestChannel)channel){

                        public RestResponse buildResponse(ResponseType response) throws Exception {
                            return RestApi.toRestResponse(response, prettyPrintResponse, RestApi.this.staticResponseHeaders);
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("Error while handling request", (Throwable)e);
                    return channel -> channel.sendResponse(new StandardResponse(e).toRestResponse());
                }
            });
        }

        public <RequestType extends Action.Request, ResponseType extends Action.Response> RestApi with(Action<RequestType, ResponseType> action, RestRequestParser<RequestType> requestParser) {
            if (action == null) {
                throw new IllegalArgumentException("action must not be null");
            }
            if (requestParser == null) {
                throw new IllegalArgumentException("requestParser must not be null");
            }
            return this.with((RestRequest restRequest, NodeClient client) -> {
                try {
                    String ifNoneMatchHeader;
                    final boolean prettyPrintResponse = restRequest.paramAsBoolean("pretty", false);
                    UnparsedDocument unparsedDoc = null;
                    if (restRequest.hasContent()) {
                        ContentType contentType = ContentType.parseHeader((String)(restRequest.header("X-SG-Original-Content-Type") != null ? restRequest.header("X-SG-Original-Content-Type") : restRequest.header("Content-Type")));
                        if (contentType == null) {
                            return channel -> channel.sendResponse(new StandardResponse(400, "Content-Type header is missing").toRestResponse());
                        }
                        unparsedDoc = UnparsedDocument.from((byte[])BytesReference.toBytes((BytesReference)restRequest.content()), (ContentType)contentType);
                    }
                    Action.Request transportRequest = (Action.Request)((Object)((Object)requestParser.parse(new RestRequestParams((RestRequest)restRequest), unparsedDoc)));
                    String ifMatchHeader = restRequest.header("If-Match");
                    if (ifMatchHeader != null) {
                        transportRequest.ifMatch(ifMatchHeader);
                    }
                    if ((ifNoneMatchHeader = restRequest.header("If-None-Match")) != null) {
                        transportRequest.ifNoneMatch(ifNoneMatchHeader);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Parsed request for " + this + ": " + transportRequest);
                    }
                    return channel -> client.execute((ActionType)action, (ActionRequest)transportRequest, (ActionListener)new RestResponseListener<ResponseType>((RestChannel)channel){

                        public RestResponse buildResponse(ResponseType response) throws Exception {
                            return RestApi.toRestResponse(response, prettyPrintResponse, RestApi.this.staticResponseHeaders);
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("Error while handling request", (Throwable)e);
                    return channel -> channel.sendResponse(new StandardResponse(e).toRestResponse());
                }
            });
        }

        public <RequestType extends ActionRequest, ResponseType extends ActionResponse> RestApi with(ActionType<ResponseType> action, RestRequestParser<RequestType> requestParser, final Function<ResponseType, RestStatus> getStatusFunction) {
            if (action == null) {
                throw new IllegalArgumentException("action must not be null");
            }
            return this.with((RestRequest restRequest, NodeClient client) -> {
                try {
                    final boolean prettyPrintResponse = restRequest.paramAsBoolean("pretty", false);
                    UnparsedDocument unparsedDoc = null;
                    if (restRequest.hasContent()) {
                        ContentType contentType = ContentType.parseHeader((String)(restRequest.header("X-SG-Original-Content-Type") != null ? restRequest.header("X-SG-Original-Content-Type") : restRequest.header("Content-Type")));
                        if (contentType == null) {
                            return channel -> channel.sendResponse(new StandardResponse(400, "Content-Type header is missing").toRestResponse());
                        }
                        unparsedDoc = UnparsedDocument.from((byte[])BytesReference.toBytes((BytesReference)restRequest.content()), (ContentType)contentType);
                    }
                    Object transportRequest = requestParser.parse(new RestRequestParams((RestRequest)restRequest), unparsedDoc);
                    return channel -> client.execute(action, transportRequest, (ActionListener)new RestResponseListener<ResponseType>((RestChannel)channel){

                        public RestResponse buildResponse(ResponseType response) throws Exception {
                            Format responseDocType = Format.JSON;
                            RestStatus status = (RestStatus)getStatusFunction.apply(response);
                            String body = response instanceof Document ? DocWriter.format((Format)responseDocType).pretty(prettyPrintResponse).writeAsString(response) : (XContentConverter.canConvert(response) ? Strings.toString((ToXContent)XContentConverter.convertOrNull(response)) : response.toString());
                            RestResponse restResponse = new RestResponse(status, responseDocType.getMediaType(), body);
                            if (!RestApi.this.staticResponseHeaders.isEmpty()) {
                                RestApi.this.staticResponseHeaders.forEach((k, v) -> restResponse.addHeader(k, v));
                            }
                            return restResponse;
                        }
                    });
                }
                catch (Exception e) {
                    log.warn("Error while handling request", (Throwable)e);
                    return channel -> channel.sendResponse(new StandardResponse(e).toRestResponse());
                }
            });
        }

        public String toString() {
            return "Endpoint [method=" + this.method + ", routes=" + this.routes + "]";
        }

        private int matchParams(Map<String, String> actualParams) {
            if (this.requiredParams.size() == 0) {
                return 0;
            }
            int matchingParams = 0;
            for (String requiredParam : this.requiredParams) {
                if (actualParams.containsKey(requiredParam)) {
                    ++matchingParams;
                    continue;
                }
                return -1;
            }
            return matchingParams;
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH;

    }

    private static class RestRequestParams
    implements Map<String, String> {
        private final RestRequest request;

        RestRequestParams(RestRequest request) {
            this.request = request;
        }

        @Override
        public int size() {
            return this.request.params().size();
        }

        @Override
        public boolean isEmpty() {
            return this.request.params().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                return this.request.hasParam((String)key);
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.request.params().containsValue(value);
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                return this.request.param((String)key);
            }
            return null;
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.request.params().keySet();
        }

        @Override
        public Collection<String> values() {
            return this.request.params().values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.request.params().entrySet();
        }
    }

    @FunctionalInterface
    public static interface RestRequestParser<RequestType extends ActionRequest> {
        public RequestType parse(Map<String, String> var1, UnparsedDocument<?> var2) throws ConfigValidationException;
    }
}

