/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.searchsupport.cstate.metrics.CacheStats;
import com.floragunn.searchsupport.cstate.metrics.Count;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.cstate.metrics.UnknownMeasurement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Measurement<M>
implements Document<Measurement<M>> {
    private static final Logger log = LogManager.getLogger(Measurement.class);

    public static Measurement<?> parse(UnparsedDocument<Measurement<?>> unparsedDocument) {
        return Measurement.parse(unparsedDocument.toDocNode());
    }

    public static Measurement<?> parse(DocNode docNode) {
        if (!docNode.isMap() || docNode.isEmpty()) {
            log.error("Error while parsing measurement\n" + docNode, (Object)docNode);
            return new UnknownMeasurement("_", docNode);
        }
        String type = (String)docNode.keySet().iterator().next();
        DocNode typeNode = docNode.getAsNode(type);
        try {
            switch (type) {
                case "agg": {
                    if (typeNode.hasNonNull("agg_ms")) {
                        return new TimeAggregation.Milliseconds(typeNode);
                    }
                    if (typeNode.hasNonNull("agg_ns")) {
                        return new TimeAggregation.Nanoseconds(typeNode);
                    }
                    return new CountAggregation(typeNode);
                }
                case "cache": {
                    return new CacheStats.Static(typeNode);
                }
                case "count": {
                    return new Count(typeNode);
                }
            }
            return new UnknownMeasurement(type, typeNode);
        }
        catch (Exception e) {
            log.error("Error while parsing measurement " + type + "\n" + docNode, (Object)docNode);
            return new UnknownMeasurement(type, typeNode);
        }
    }

    public abstract Measurement<M> clone();

    public abstract void addToThis(M var1);

    public abstract void addToThis(Measurement<?> var1);

    public abstract String getType();

    public abstract void reset();
}

