/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthTokenHttpJwtAuthenticator
implements HttpAuthenticationFrontend {
    private static final Logger log = LogManager.getLogger(AuthTokenHttpJwtAuthenticator.class);
    private final AuthTokenService authTokenService;
    private final String jwtHeaderName;
    private final String subjectKey;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "sg_auth_token", AuthTokenHttpJwtAuthenticator.class).initialized();

    public AuthTokenHttpJwtAuthenticator(AuthTokenService authTokenService) {
        this.authTokenService = authTokenService;
        this.jwtHeaderName = "Authorization";
        this.subjectKey = "sub";
    }

    public String getType() {
        return "sg_auth_token";
    }

    public AuthCredentials extractCredentials(RequestMetaData<?> request) {
        String encodedJwt = request.getAuthorizationByScheme(this.jwtHeaderName, "bearer");
        if (Strings.isNullOrEmpty((String)encodedJwt)) {
            return null;
        }
        try {
            JwtToken jwt = this.authTokenService.getVerifiedJwtToken(encodedJwt);
            if (jwt == null) {
                return null;
            }
            JwtClaims claims = jwt.getClaims();
            String subject = this.extractSubject(claims);
            if (subject == null) {
                log.error("No subject found in JWT token: " + claims);
                return null;
            }
            return AuthCredentials.forUser((String)subject).claims(claims.asMap()).complete().build();
        }
        catch (JwtException e) {
            log.info("JWT is invalid (" + this.getType() + ")", (Throwable)e);
            return null;
        }
    }

    protected String extractSubject(JwtClaims claims) {
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            Object subjectObject = claims.getClaim(this.subjectKey);
            if (subjectObject == null) {
                log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
                subject = String.valueOf(subjectObject);
            } else {
                subject = (String)subjectObject;
            }
        }
        return subject;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

