/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class AbstractConfigurationValidator {
    JsonFactory factory = new JsonFactory();
    public static final String INVALID_KEYS_KEY = "invalid_keys";
    public static final String MISSING_MANDATORY_KEYS_KEY = "missing_mandatory_keys";
    public static final String MISSING_MANDATORY_OR_KEYS_KEY = "specify_one_of";
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Map<String, DataType> allowedKeys = new HashMap<String, DataType>();
    protected final Set<String> mandatoryKeys = new HashSet<String>();
    protected final Set<String> mandatoryOrKeys = new HashSet<String>();
    protected final Map<String, String> wrongDatatypes = new HashMap<String, String>();
    protected final Set<String> missingMandatoryKeys = new HashSet<String>();
    protected final Set<String> invalidKeys = new HashSet<String>();
    protected final Set<String> missingMandatoryOrKeys = new HashSet<String>();
    protected ErrorType errorType = ErrorType.NONE;
    protected Exception lastException;
    protected boolean payloadMandatory = false;
    protected boolean payloadAllowed = true;
    protected final RestRequest.Method method;
    protected final BytesReference content;
    protected final Settings esSettings;
    protected final RestRequest request;
    protected final Object[] param;
    private DocNode contentAsNode;

    public AbstractConfigurationValidator(RestRequest request, BytesReference ref, Settings esSettings, Object ... param) {
        this.content = ref;
        this.method = request.method();
        this.esSettings = esSettings;
        this.request = request;
        this.param = param;
    }

    public DocNode getContentAsNode() {
        return this.contentAsNode;
    }

    public boolean validate() {
        boolean valid;
        if (this.method.equals((Object)RestRequest.Method.DELETE) || this.method.equals((Object)RestRequest.Method.GET)) {
            return true;
        }
        if (this.payloadMandatory && this.content.length() == 0) {
            this.errorType = ErrorType.PAYLOAD_MANDATORY;
            return false;
        }
        if (this.payloadMandatory && this.content.length() > 0) {
            try {
                if (DocReader.json().readObject(this.content.utf8ToString()).size() == 0) {
                    this.errorType = ErrorType.PAYLOAD_MANDATORY;
                    return false;
                }
            }
            catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)this.validationError((Exception)e));
                this.errorType = ErrorType.BODY_NOT_PARSEABLE;
                this.lastException = this.validationError((Exception)e);
                return false;
            }
        }
        if (!this.payloadAllowed && this.content.length() > 0) {
            this.errorType = ErrorType.PAYLOAD_NOT_ALLOWED;
            return false;
        }
        HashSet requested = new HashSet();
        try {
            this.contentAsNode = DocNode.parse((Format)Format.JSON).from(this.content.utf8ToString());
            if (this.contentAsNode == null || this.contentAsNode.isNull()) {
                this.errorType = ErrorType.BODY_NOT_PARSEABLE;
                return false;
            }
            requested.addAll(ImmutableList.copyOf((Collection)this.contentAsNode.keySet()));
        }
        catch (Exception e) {
            this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)e);
            this.errorType = ErrorType.BODY_NOT_PARSEABLE;
            this.lastException = e;
            return false;
        }
        if (Collections.disjoint(requested, this.mandatoryOrKeys)) {
            this.missingMandatoryOrKeys.addAll(this.mandatoryOrKeys);
        }
        HashSet<String> mandatory = new HashSet<String>(this.mandatoryKeys);
        mandatory.removeAll(requested);
        this.missingMandatoryKeys.addAll(mandatory);
        HashSet<String> allowed = new HashSet<String>(this.allowedKeys.keySet());
        requested.removeAll(allowed);
        this.invalidKeys.addAll(requested);
        boolean bl = valid = this.missingMandatoryKeys.isEmpty() && this.invalidKeys.isEmpty() && this.missingMandatoryOrKeys.isEmpty();
        if (!valid) {
            this.errorType = ErrorType.INVALID_CONFIGURATION;
        }
        try {
            if (!this.checkDatatypes()) {
                this.errorType = ErrorType.WRONG_DATATYPE;
                return false;
            }
        }
        catch (Exception e) {
            this.log.error(ErrorType.BODY_NOT_PARSEABLE.toString(), (Throwable)e);
            this.errorType = ErrorType.BODY_NOT_PARSEABLE;
            this.lastException = e;
            return false;
        }
        return valid;
    }

    protected Exception validationError(Exception e) {
        return e;
    }

    private boolean checkDatatypes() throws Exception {
        String contentAsJson = XContentHelper.convertToJson((BytesReference)this.content, (boolean)false, (XContentType)XContentType.JSON);
        try (JsonParser parser = this.factory.createParser(contentAsJson);){
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                String currentName;
                DataType dataType;
                if (!token.equals((Object)JsonToken.FIELD_NAME) || (dataType = this.allowedKeys.get(currentName = parser.getCurrentName())) == null) continue;
                JsonToken valueToken = parser.nextToken();
                switch (dataType) {
                    case STRING: {
                        if (valueToken.equals((Object)JsonToken.VALUE_STRING)) break;
                        this.wrongDatatypes.put(currentName, "String expected");
                        break;
                    }
                    case ARRAY: {
                        if (valueToken.equals((Object)JsonToken.START_ARRAY) || valueToken.equals((Object)JsonToken.END_ARRAY)) break;
                        this.wrongDatatypes.put(currentName, "Array expected");
                        break;
                    }
                    case OBJECT: {
                        if (valueToken.equals((Object)JsonToken.START_OBJECT) || valueToken.equals((Object)JsonToken.END_OBJECT)) break;
                        this.wrongDatatypes.put(currentName, "Object expected");
                    }
                }
            }
            boolean bl = this.wrongDatatypes.isEmpty();
            return bl;
        }
    }

    public XContentBuilder errorsAsXContent(RestChannel channel) {
        try {
            XContentBuilder builder = channel.newErrorBuilder();
            builder.startObject();
            if (this.lastException != null) {
                builder.field("details", this.lastException.toString());
            }
            switch (this.errorType) {
                case INVALID_CONFIGURATION: {
                    builder.field("status", "error");
                    builder.field("reason", ErrorType.INVALID_CONFIGURATION.getMessage());
                    this.addErrorMessage(builder, INVALID_KEYS_KEY, this.invalidKeys);
                    this.addErrorMessage(builder, MISSING_MANDATORY_KEYS_KEY, this.missingMandatoryKeys);
                    this.addErrorMessage(builder, MISSING_MANDATORY_OR_KEYS_KEY, this.missingMandatoryKeys);
                    break;
                }
                case INVALID_PASSWORD: {
                    builder.field("status", "error");
                    builder.field("reason", this.esSettings.get("searchguard.restapi.password_validation_error_message", "Password does not match minimum criterias"));
                    break;
                }
                case WRONG_DATATYPE: {
                    builder.field("status", "error");
                    builder.field("reason", ErrorType.WRONG_DATATYPE.getMessage());
                    for (Map.Entry<String, String> entry : this.wrongDatatypes.entrySet()) {
                        builder.field(entry.getKey(), entry.getValue());
                    }
                    break;
                }
                default: {
                    builder.field("status", "error");
                    builder.field("reason", this.errorType.getMessage());
                }
            }
            builder.endObject();
            return builder;
        }
        catch (IOException ex) {
            this.log.error("Cannot build error settings", (Throwable)ex);
            return null;
        }
    }

    private void addErrorMessage(XContentBuilder builder, String message, Set<String> keys) throws IOException {
        if (!keys.isEmpty()) {
            builder.startObject(message);
            builder.field("keys", Joiner.on((String)",").join((Object[])keys.toArray(new String[0])));
            builder.endObject();
        }
    }

    protected final boolean hasParams() {
        return this.param != null && this.param.length > 0;
    }

    public static enum ErrorType {
        NONE("ok"),
        INVALID_CONFIGURATION("Invalid configuration"),
        INVALID_PASSWORD("Invalid password"),
        WRONG_DATATYPE("Wrong datatype"),
        BODY_NOT_PARSEABLE("Could not parse content of request."),
        PAYLOAD_NOT_ALLOWED("Request body not allowed for this action."),
        PAYLOAD_MANDATORY("Request body required for this action."),
        SG_NOT_INITIALIZED("Search Guard index not initialized (SG11)");

        private String message;

        private ErrorType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum DataType {
        STRING,
        ARRAY,
        OBJECT;

    }
}

