/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.validation;

import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentType;

public class InternalUsersValidator
extends AbstractConfigurationValidator {
    public InternalUsersValidator(RestRequest request, BytesReference ref, Settings esSettings, Object ... param) {
        super(request, ref, esSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("hash", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("password", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("backend_roles", AbstractConfigurationValidator.DataType.ARRAY);
        this.allowedKeys.put("attributes", AbstractConfigurationValidator.DataType.OBJECT);
        this.allowedKeys.put("description", AbstractConfigurationValidator.DataType.STRING);
        this.allowedKeys.put("search_guard_roles", AbstractConfigurationValidator.DataType.ARRAY);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String regex = this.esSettings.get("searchguard.restapi.password_validation_regex", null);
        if (!(this.request.method() != RestRequest.Method.PUT && this.request.method() != RestRequest.Method.PATCH || regex == null || regex.isEmpty() || this.content == null || this.content.length() <= 1)) {
            try {
                Map contentAsMap = (Map)XContentHelper.convertToMap((BytesReference)this.content, (boolean)false, (XContentType)XContentType.JSON).v2();
                if (contentAsMap != null && contentAsMap.containsKey("password")) {
                    String password = (String)contentAsMap.get("password");
                    if (password == null || password.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Unable to validate password because no password is given");
                        }
                        return false;
                    }
                    String username = this.request.param("name");
                    if (username == null && this.hasParams()) {
                        username = (String)this.param[0];
                    }
                    if (username == null || username.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Unable to validate username because no user is given");
                        }
                        return false;
                    }
                    AbstractConfigurationValidator.ErrorType error = InternalUsersValidator.validatePassword(username, password, this.esSettings);
                    if (error != null) {
                        this.errorType = error;
                        return false;
                    }
                }
            }
            catch (NotXContentException e) {
                this.log.error("Invalid xContent: " + e, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static AbstractConfigurationValidator.ErrorType validatePassword(String username, String password, Settings esSettings) {
        if (password == null || password.isEmpty()) {
            return null;
        }
        String regex = esSettings.get("searchguard.restapi.password_validation_regex", null);
        if (regex == null || regex.isEmpty()) {
            return null;
        }
        if (!Pattern.compile("^" + regex + "$").matcher(password).matches()) {
            return AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
        }
        if (username.toLowerCase().equals(password.toLowerCase())) {
            return AbstractConfigurationValidator.ErrorType.INVALID_PASSWORD;
        }
        return null;
    }

    @Override
    protected Exception validationError(Exception e) {
        if (e instanceof DocumentParseException) {
            return new SensitiveDataException("Passed User object is invalid");
        }
        return e;
    }

    private static class SensitiveDataException
    extends Exception {
        private static final long serialVersionUID = 7279592878585611145L;

        public SensitiveDataException(String message) {
            super(message);
        }
    }
}

