/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.jwt;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.jwt.Jose;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.JwksProviderClient;
import com.floragunn.searchguard.enterprise.auth.oidc.JwtVerifier;
import com.floragunn.searchguard.enterprise.auth.oidc.KeyProvider;
import com.floragunn.searchguard.enterprise.auth.oidc.OpenIdProviderClient;
import com.floragunn.searchguard.enterprise.auth.oidc.SelfRefreshingKeySet;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class JwtAuthenticator
implements HttpAuthenticationFrontend,
ApiAuthenticationFrontend {
    private static final Logger log = LogManager.getLogger(JwtAuthenticator.class);
    private final KeyProvider staticKeySet;
    private final SelfRefreshingKeySet openIdKeySet;
    private final SelfRefreshingKeySet jwksKeySet;
    private final JwtVerifier jwtVerifier;
    private final String jwtHeaderName;
    private final String jwtUrlParameter;
    private final String requiredAudience;
    private final String requiredIssuer;
    private final boolean challenge;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "jwt", JwtAuthenticator.class).initialized().requiresEnterpriseLicense();
    public static TypedComponent.Info<HttpAuthenticationFrontend> INFO = new TypedComponent.Info<HttpAuthenticationFrontend>(){

        public Class<HttpAuthenticationFrontend> getType() {
            return HttpAuthenticationFrontend.class;
        }

        public String getName() {
            return "jwt";
        }

        public TypedComponent.Factory<HttpAuthenticationFrontend> getFactory() {
            return JwtAuthenticator::new;
        }
    };

    public JwtAuthenticator(DocNode docNode, ConfigurationRepository.Context context) throws ConfigValidationException {
        ProxyConfig proxyConfig;
        TLSConfig tlsConfig;
        JsonWebKeys joinedJwks;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, (Parser.Context)context);
        this.jwtHeaderName = vNode.get("header").withDefault("Authorization").asString();
        this.jwtUrlParameter = vNode.get("url_parameter").asString();
        this.requiredAudience = vNode.get("required_audience").asString();
        this.requiredIssuer = vNode.get("required_issuer").asString();
        this.challenge = vNode.get("challenge").withDefault(true).asBoolean();
        JsonWebKeys jwks = (JsonWebKeys)((ValidatingDocNode.Attribute)vNode.get("signing.jwks").expected("A JWKS document")).by(n -> JwkUtils.readJwkSet((String)n.toJsonString()));
        JsonWebKey rsaJwk = (JsonWebKey)vNode.get("signing.rsa").by(JwtAuthenticator::parseRsa);
        JsonWebKey ecJwk = (JsonWebKey)vNode.get("signing.ec").by(JwtAuthenticator::parseEc);
        if (rsaJwk != null || ecJwk != null) {
            ImmutableList jwkList = ImmutableList.ofNonNull((Object)rsaJwk, (Object)ecJwk);
            if (jwks != null) {
                jwkList = jwkList.with((Collection)jwks.getKeys());
            }
            joinedJwks = new JsonWebKeys((List)jwkList);
        } else {
            joinedJwks = jwks;
        }
        this.staticKeySet = joinedJwks != null ? new KeyProvider(){

            @Override
            public JsonWebKey getKeyAfterRefresh(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                return this.getKey(kid);
            }

            @Override
            public JsonWebKey getKey(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                if (Strings.isNullOrEmpty((String)kid)) {
                    return joinedJwks.getKeys().size() != 0 ? (JsonWebKey)joinedJwks.getKeys().get(0) : null;
                }
                return joinedJwks.getKey(kid);
            }
        } : null;
        URI openidConnectUrl = vNode.get("signing.jwks_from_openid_configuration.url").asURI();
        if (openidConnectUrl != null) {
            boolean cacheJwksEndpoint = vNode.get("signing.keys_from_openid_configuration.cache_jwks_endpoint").withDefault(false).asBoolean();
            tlsConfig = (TLSConfig)vNode.get("signing.keys_from_openid_configuration.tls").by(TLSConfig::parse);
            proxyConfig = (ProxyConfig)vNode.get("signing.keys_from_openid_configuration.proxy").by(ProxyConfig::parse);
            OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(openidConnectUrl, tlsConfig, proxyConfig, cacheJwksEndpoint);
            this.openIdKeySet = new SelfRefreshingKeySet(() -> openIdProviderClient.getJsonWebKeys());
        } else {
            this.openIdKeySet = null;
        }
        URI jwksUrl = vNode.get("signing.jwks_endpoint.url").asURI();
        if (jwksUrl != null) {
            tlsConfig = (TLSConfig)vNode.get("signing.jwks_endpoint.tls").by(TLSConfig::parse);
            proxyConfig = (ProxyConfig)vNode.get("signing.jwks_endpoint.proxy").by(ProxyConfig::parse);
            JwksProviderClient jwksProviderClient = new JwksProviderClient(tlsConfig, proxyConfig);
            this.jwksKeySet = new SelfRefreshingKeySet(() -> jwksProviderClient.getJsonWebKeys(jwksUrl));
        } else {
            this.jwksKeySet = null;
        }
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        this.jwtVerifier = new JwtVerifier(KeyProvider.combined(this.staticKeySet, this.openIdKeySet, this.jwksKeySet), this.requiredAudience, this.requiredIssuer);
    }

    public String getType() {
        return "jwt";
    }

    public AuthCredentials extractCredentials(RequestMetaData<?> request) throws CredentialsException, AuthenticatorUnavailableException {
        String jwtTokenFromParam;
        String jwtString = request.getAuthorizationByScheme(this.jwtHeaderName, "bearer");
        String string = jwtTokenFromParam = this.jwtUrlParameter != null ? request.getParam(this.jwtUrlParameter) : null;
        if (jwtString == null && jwtTokenFromParam != null && jwtTokenFromParam.toLowerCase().startsWith("bearer ")) {
            jwtString = jwtTokenFromParam.substring("bearer ".length()).trim();
        }
        if (jwtString == null) {
            return null;
        }
        return this.tokenToCredentials(jwtString);
    }

    private AuthCredentials tokenToCredentials(String jwtString) throws AuthenticatorUnavailableException, CredentialsException {
        JwtToken jwt;
        Objects.requireNonNull(jwtString, "Jwt string is required");
        try {
            jwt = this.jwtVerifier.getVerifiedJwtToken(jwtString);
        }
        catch (AuthenticatorUnavailableException e) {
            log.info((Object)e);
            throw e;
        }
        catch (BadCredentialsException e) {
            log.info("Extracting JWT token from " + jwtString + " failed", (Throwable)e);
            throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, e.getMessage()), (Throwable)e);
        }
        JwtClaims claims = jwt.getClaims();
        if (log.isTraceEnabled()) {
            log.trace("Claims from JWT: " + claims.asMap());
        }
        return AuthCredentials.forUser((String)claims.getSubject()).nativeCredentials((Object)jwtString).attribute("__auth_type", (Object)"jwt").userMappingAttribute("jwt", Jose.toBasicObject((JsonMapObject)claims)).complete().build();
    }

    public String getChallenge(AuthCredentials credentials) {
        if (this.challenge) {
            return "Bearer realm=\"Search Guard\"";
        }
        return null;
    }

    private static JsonWebKey parseRsa(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        String publicKeyString;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        RSAPublicKey rsaPublicKey = null;
        String certificate = vNode.get("certificate").asString();
        if (certificate != null) {
            try {
                PublicKey publicKey = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getBytes())).getPublicKey();
                if (publicKey instanceof RSAPublicKey) {
                    rsaPublicKey = (RSAPublicKey)publicKey;
                } else {
                    validationErrors.add(new InvalidAttributeValue("certificate", publicKey.getClass(), (Object)"An RSA certificate").message("Not an RSA certificate"));
                }
            }
            catch (Exception e) {
                validationErrors.add(new ValidationError("certificate", e.getMessage()).cause((Throwable)e));
            }
        }
        if ((publicKeyString = vNode.get("public_key").asString()) != null) {
            try {
                PemObject pemObject = new PemReader((Reader)new StringReader(publicKeyString)).readPemObject();
                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(pemObject.getContent()));
                if (publicKey instanceof RSAPublicKey) {
                    rsaPublicKey = (RSAPublicKey)publicKey;
                } else {
                    validationErrors.add(new InvalidAttributeValue("public_key", publicKey.getClass(), (Object)"An RSA public key").message("Not an RSA public key"));
                }
            }
            catch (Exception e) {
                validationErrors.add(new ValidationError("public_key", e.getMessage()).cause((Throwable)e));
            }
        }
        String algo = vNode.get("algorithm").validatedBy(AlgorithmUtils::isRsa).asString();
        String kid = vNode.get("kid").asString();
        validationErrors.throwExceptionForPresentErrors();
        if (rsaPublicKey == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("certificate"));
        }
        try {
            return JwkUtils.fromRSAPublicKey((RSAPublicKey)rsaPublicKey, (String)algo, (String)kid);
        }
        catch (Exception e) {
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
    }

    private static JsonWebKey parseEc(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        String publicKeyString;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        ECPublicKey ecPublicKey = null;
        String certificate = vNode.get("certificate").asString();
        if (certificate != null) {
            try {
                PublicKey publicKey = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getBytes())).getPublicKey();
                if (publicKey instanceof ECPublicKey) {
                    ecPublicKey = (ECPublicKey)publicKey;
                } else {
                    validationErrors.add(new InvalidAttributeValue("certificate", publicKey.getClass(), (Object)"An EC certificate").message("Not an EC certificate"));
                }
            }
            catch (Exception e) {
                validationErrors.add(new ValidationError("certificate", e.getMessage()).cause((Throwable)e));
            }
        }
        if ((publicKeyString = vNode.get("public_key").asString()) != null) {
            try {
                PemObject pemObject = new PemReader((Reader)new StringReader(publicKeyString)).readPemObject();
                PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(pemObject.getContent()));
                if (publicKey instanceof ECPublicKey) {
                    ecPublicKey = (ECPublicKey)publicKey;
                } else {
                    validationErrors.add(new InvalidAttributeValue("public_key", publicKey.getClass(), (Object)"An EC public key").message("Not an EC public key"));
                }
            }
            catch (Exception e) {
                validationErrors.add(new ValidationError("public_key", e.getMessage()).cause((Throwable)e));
            }
        }
        String curve = vNode.get("curve").validatedBy(AlgorithmUtils::isRsa).asString();
        String kid = vNode.get("kid").asString();
        validationErrors.throwExceptionForPresentErrors();
        if (ecPublicKey == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("certificate"));
        }
        try {
            return JwkUtils.fromECPublicKey((ECPublicKey)ecPublicKey, (String)curve, (String)kid);
        }
        catch (Exception e) {
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public AuthCredentials extractCredentials(Map<String, Object> request) throws CredentialsException, ConfigValidationException, AuthenticatorUnavailableException {
        Object jwtToken = request.get("jwt") instanceof String ? request.get("jwt") : null;
        return this.tokenToCredentials((String)jwtToken);
    }

    public ActivatedFrontendConfig.AuthMethod activateFrontendConfig(ActivatedFrontendConfig.AuthMethod frontendConfig, GetActivatedFrontendConfigAction.Request request) throws AuthenticatorUnavailableException {
        return super.activateFrontendConfig(frontendConfig, request);
    }

    public String getLogoutUrl(User user) throws AuthenticatorUnavailableException {
        return super.getLogoutUrl(user);
    }
}

