/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.JwtVerifier;
import com.floragunn.searchguard.enterprise.auth.oidc.KeySetRetriever;
import com.floragunn.searchguard.enterprise.auth.oidc.OidcProviderConfig;
import com.floragunn.searchguard.enterprise.auth.oidc.OpenIdProviderClient;
import com.floragunn.searchguard.enterprise.auth.oidc.SelfRefreshingKeySet;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OidcAuthenticator
implements ApiAuthenticationFrontend {
    private static final Logger log = LogManager.getLogger(OidcAuthenticator.class);
    private static final String SSO_CONTEXT_PREFIX_STATE = "oidc_s:";
    private static final String SSO_CONTEXT_PREFIX_CODE_VERIFIER = "oidc_cv:";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private ProxyConfig proxyConfig;
    private OpenIdProviderClient openIdProviderClient;
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private JwtVerifier jwtVerifier;
    private JwtVerifier userInfoJwtVerifier;
    private final String logoutUrl;
    private final boolean usePkce;
    private final boolean useUserInfoEndpoint;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "oidc", OidcAuthenticator.class).initialized().requiresEnterpriseLicense();
    public static TypedComponent.Info<ApiAuthenticationFrontend> INFO = new TypedComponent.Info<ApiAuthenticationFrontend>(){

        public Class<ApiAuthenticationFrontend> getType() {
            return ApiAuthenticationFrontend.class;
        }

        public String getName() {
            return "oidc";
        }

        public TypedComponent.Factory<ApiAuthenticationFrontend> getFactory() {
            return OidcAuthenticator::new;
        }
    };

    public OidcAuthenticator(Map<String, Object> config, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors, (Parser.Context)context);
        this.clientId = vNode.get("client_id").required().asString();
        this.usePkce = vNode.get("pkce").withDefault(true).asBoolean();
        this.useUserInfoEndpoint = vNode.get("get_user_info").withDefault(false).asBoolean();
        this.clientSecret = vNode.get("client_secret").required(!this.usePkce).asString();
        this.scope = vNode.get("scope").withDefault("openid profile email address phone").asString();
        this.proxyConfig = (ProxyConfig)vNode.get("idp.proxy").by(ProxyConfig::parse);
        this.logoutUrl = vNode.get("logout_url").asString();
        int idpRequestTimeoutMs = vNode.get("idp_request_timeout_ms").withDefault((Number)5000).asInt();
        int idpQueuedThreadTimeoutMs = vNode.get("idp_queued_thread_timeout_ms").withDefault((Number)2500).asInt();
        int refreshRateLimitTimeWindowMs = vNode.get("refresh_rate_limit_time_window_ms").withDefault((Number)10000).asInt();
        int refreshRateLimitCount = vNode.get("refresh_rate_limit_count").withDefault((Number)10).asInt();
        URI openidConnectUrl = vNode.get("idp.openid_configuration_url").required().asURI();
        TLSConfig tlsConfig = (TLSConfig)vNode.get("idp.tls").by(TLSConfig::parse);
        boolean cacheJwksEndpoint = vNode.get("cache_jwks_endpoint").withDefault(false).asBoolean();
        String requiredAudience = vNode.get("required_audience").asString();
        String requiredIssuer = vNode.get("required_issuer").asString();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        this.openIdProviderClient = new OpenIdProviderClient(openidConnectUrl, tlsConfig, this.proxyConfig, cacheJwksEndpoint);
        this.openIdProviderClient.setRequestTimeoutMs(idpRequestTimeoutMs);
        KeySetRetriever keySetRetriever = new KeySetRetriever(this.openIdProviderClient);
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet(keySetRetriever);
        selfRefreshingKeySet.setRequestTimeoutMs(idpRequestTimeoutMs);
        selfRefreshingKeySet.setQueuedThreadTimeoutMs(idpQueuedThreadTimeoutMs);
        selfRefreshingKeySet.setRefreshRateLimitTimeWindowMs(refreshRateLimitTimeWindowMs);
        selfRefreshingKeySet.setRefreshRateLimitCount(refreshRateLimitCount);
        this.jwtVerifier = new JwtVerifier(selfRefreshingKeySet, requiredAudience, requiredIssuer);
        this.userInfoJwtVerifier = new JwtVerifier(selfRefreshingKeySet, null, requiredIssuer);
    }

    public ActivatedFrontendConfig.AuthMethod activateFrontendConfig(ActivatedFrontendConfig.AuthMethod frontendConfig, GetActivatedFrontendConfigAction.Request request) throws AuthenticatorUnavailableException {
        try {
            ValidationResult<OidcProviderConfig> oidcProviderConfig = this.openIdProviderClient.getOidcConfiguration();
            if (oidcProviderConfig.peek() == null || ((OidcProviderConfig)oidcProviderConfig.peek()).getAuthorizationEndpoint() == null) {
                throw new AuthenticatorUnavailableException("Invalid OIDC metadata", "authorization_endpoint missing from OIDC metadata").details("oidc_metadata", oidcProviderConfig.toBasicObject(), new Object[0]);
            }
            if (request.getFrontendBaseUrl() == null) {
                throw new AuthenticatorUnavailableException("Invalid configuration", "frontend_base_url is required for OIDC authentication").details("request", request.toBasicObject(), new Object[0]);
            }
            URI frontendBaseUrl = new URI(request.getFrontendBaseUrl());
            String redirectUri = this.getLoginPostURI(frontendBaseUrl).toASCIIString();
            String stateToken = this.createOpaqueToken(24);
            String codeVerifier = null;
            String codeChallenge = null;
            String ssoContext = SSO_CONTEXT_PREFIX_STATE + stateToken;
            Object state = !Strings.isNullOrEmpty((String)request.getNextURL()) ? stateToken + "|" + request.getNextURL() : stateToken;
            URIBuilder ssoLocationBuilder = new URIBuilder(((OidcProviderConfig)oidcProviderConfig.peek()).getAuthorizationEndpoint()).addParameter("client_id", this.clientId).addParameter("response_type", "code").addParameter("redirect_uri", redirectUri).addParameter("state", (String)state).addParameter("scope", this.scope);
            if (this.usePkce) {
                codeVerifier = this.createOpaqueToken(48);
                codeChallenge = BaseEncoding.base64Url().omitPadding().encode(Hashing.sha256().hashString((CharSequence)codeVerifier, StandardCharsets.US_ASCII).asBytes());
                ssoLocationBuilder.addParameter("code_challenge", codeChallenge);
                ssoLocationBuilder.addParameter("code_challenge_method", "S256");
                ssoContext = ssoContext + ";oidc_cv:" + codeVerifier;
            }
            return frontendConfig.ssoLocation(ssoLocationBuilder.build().toASCIIString()).ssoContext(ssoContext);
        }
        catch (URISyntaxException e) {
            log.error("Error while activating SAML authenticator", (Throwable)e);
            throw new AuthenticatorUnavailableException("Invalid configuration", "frontend_base_url is not a valid URL", (Throwable)e).details("request", request.toBasicObject(), new Object[0]);
        }
    }

    public AuthCredentials extractCredentials(Map<String, Object> request) throws CredentialsException, AuthenticatorUnavailableException, ConfigValidationException {
        JwtToken jwt;
        String frontendRedirectUri;
        String actualStateToken;
        URI frontendBaseUrl;
        String ssoResult;
        String ssoContext;
        HashMap<String, Object> debugDetails = new HashMap<String, Object>();
        String string = ssoContext = request.containsKey("sso_context") ? String.valueOf(request.get("sso_context")) : null;
        if (ssoContext == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("sso_context"));
        }
        String expectedStateToken = this.getValueFromSsoContext(SSO_CONTEXT_PREFIX_STATE, ssoContext);
        if (expectedStateToken == null) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("sso_context", (Object)ssoContext, (Object)"Must contain oidc_s:"));
        }
        String codeVerifier = this.getValueFromSsoContext(SSO_CONTEXT_PREFIX_CODE_VERIFIER, ssoContext);
        if (this.usePkce && codeVerifier == null) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("sso_context", (Object)ssoContext, (Object)"Must contain oidc_cv:"));
        }
        String string2 = ssoResult = request.containsKey("sso_result") ? String.valueOf(request.get("sso_result")) : null;
        if (ssoResult == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("ssoResult"));
        }
        if (!request.containsKey("frontend_base_url")) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("frontend_base_url"));
        }
        try {
            frontendBaseUrl = new URI(String.valueOf(request.get("frontend_base_url")));
        }
        catch (URISyntaxException e) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("frontend_base_url", request.get("frontend_base_url"), (Object)"A URL"));
        }
        Map<String, String> ssoResultParams = this.getUriParams(ssoResult);
        String state = ssoResultParams.get("state");
        if (state == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("ssoResult.state"));
        }
        int separator = state.indexOf(124);
        if (separator == -1) {
            actualStateToken = state;
            frontendRedirectUri = null;
        } else {
            actualStateToken = state.substring(0, separator);
            frontendRedirectUri = state.substring(separator + 1);
        }
        String code = ssoResultParams.get("code");
        if (code == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("ssoResult.code"));
        }
        debugDetails.put("sso_context", ssoContext);
        debugDetails.put("sso_result", ssoResult);
        debugDetails.put("code", code);
        debugDetails.put("state", state);
        if (!Objects.equals(expectedStateToken, actualStateToken)) {
            throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Invalid state token: " + expectedStateToken + "/" + actualStateToken, debugDetails));
        }
        String oidcRedirectUri = this.getLoginPostURI(frontendBaseUrl).toASCIIString();
        LinkedHashMap<String, String> tokenRequest = new LinkedHashMap<String, String>();
        tokenRequest.put("client_id", this.clientId);
        tokenRequest.put("code", code);
        tokenRequest.put("redirect_uri", oidcRedirectUri);
        if (this.usePkce) {
            tokenRequest.put("code_verifier", codeVerifier);
        }
        if (this.clientSecret != null) {
            tokenRequest.put("client_secret", this.clientSecret);
        }
        OpenIdProviderClient.TokenResponse tokenResponse = this.openIdProviderClient.callTokenEndpoint(tokenRequest);
        debugDetails.put("token_response", tokenResponse.asMap());
        String jwtString = tokenResponse.getIdToken();
        try {
            jwt = this.jwtVerifier.getVerifiedJwtToken(jwtString);
        }
        catch (AuthenticatorUnavailableException e) {
            log.info((Object)e);
            throw e;
        }
        catch (BadCredentialsException e) {
            log.info("Extracting JWT token from " + jwtString + " failed", (Throwable)e);
            throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, e.getMessage(), debugDetails), (Throwable)e);
        }
        JwtClaims claims = jwt.getClaims();
        if (log.isTraceEnabled()) {
            log.trace("Claims from JWT: " + claims.asMap());
        }
        debugDetails.put("claims", claims.asMap());
        Map<Object, Object> userInfo = Collections.emptyMap();
        if (this.useUserInfoEndpoint) {
            userInfo = this.openIdProviderClient.callUserInfoEndpoint(tokenResponse.getAccessToken(), this.userInfoJwtVerifier);
            String userInfoSubject = String.valueOf(userInfo.get("sub"));
            debugDetails.put("oidc_user_info", userInfo);
            if (!userInfoSubject.equals(jwt.getClaims().getSubject())) {
                throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "sub claim from user info does not match sub claim from ID token", debugDetails));
            }
        }
        return AuthCredentials.forUser((String)claims.getSubject()).userMappingAttribute("oidc_id_token", (Object)claims.asMap()).userMappingAttribute("jwt", (Object)claims.asMap()).userMappingAttribute("oidc_user_info", userInfo).attribute("__auth_type", (Object)"oidc").attribute("__oidc_id", (Object)jwtString).attribute("__fe_base_url", (Object)frontendBaseUrl.toString()).claims(claims.asMap()).complete().redirectUri(frontendRedirectUri).build();
    }

    public String getLogoutUrl(User user) throws AuthenticatorUnavailableException {
        try {
            if (this.logoutUrl != null) {
                return this.logoutUrl;
            }
            if (user == null) {
                return null;
            }
            if (user.getStructuredAttributes().get("__fe_base_url") == null) {
                return null;
            }
            String frontendBaseUrl = String.valueOf(user.getStructuredAttributes().get("__fe_base_url"));
            ValidationResult<OidcProviderConfig> oidcProviderConfig = this.openIdProviderClient.getOidcConfiguration();
            URI endSessionEndpoint = ((OidcProviderConfig)oidcProviderConfig.get()).getEndSessionEndpoint();
            if (endSessionEndpoint == null) {
                return null;
            }
            String idToken = user.getStructuredAttributes().get("__oidc_id") != null ? user.getStructuredAttributes().get("__oidc_id").toString() : null;
            URI result = new URIBuilder(endSessionEndpoint).addParameter("post_logout_redirect_uri", frontendBaseUrl).addParameter("id_token_hint", idToken).build();
            return result.toASCIIString();
        }
        catch (URISyntaxException e) {
            log.error("Error while constructing logout url for " + this, (Throwable)e);
            return null;
        }
        catch (ConfigValidationException e) {
            log.error("Error while constructing logout url for " + this, (Throwable)e);
            return null;
        }
    }

    private Map<String, String> getUriParams(String uriString) throws ConfigValidationException {
        try {
            URI uri = new URI(uriString);
            List nameValuePairs = URLEncodedUtils.parse((URI)uri, (Charset)Charset.forName("utf-8"));
            HashMap<String, String> result = new HashMap<String, String>(nameValuePairs.size());
            for (NameValuePair nameValuePair : nameValuePairs) {
                result.put(nameValuePair.getName(), nameValuePair.getValue());
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("sso_result", (Object)uriString, (Object)"URI"));
        }
    }

    private URI getLoginPostURI(URI frontendBaseURI) {
        try {
            String path = frontendBaseURI.getPath().endsWith("/") ? frontendBaseURI.getPath() + "auth/openid/login" : frontendBaseURI.getPath() + "/auth/openid/login";
            return new URIBuilder(frontendBaseURI).setPath(path).build();
        }
        catch (URISyntaxException e) {
            log.error("Got URISyntaxException when constructing loginPostURI. This should not happen. frontendBaseURI: " + frontendBaseURI, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getType() {
        return "oidc";
    }

    private String createOpaqueToken(int byteCount) {
        byte[] b = new byte[byteCount];
        SECURE_RANDOM.nextBytes(b);
        return BaseEncoding.base64Url().omitPadding().encode(b);
    }

    private String getValueFromSsoContext(String key, String ssoContext) {
        int valueIndex;
        if (ssoContext == null) {
            return null;
        }
        int keyIndex = ssoContext.indexOf(key);
        if (keyIndex == -1) {
            return null;
        }
        int endIndex = ssoContext.indexOf(59, valueIndex = keyIndex + key.length());
        return ssoContext.substring(valueIndex, endIndex == -1 ? ssoContext.length() : endIndex).trim();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

