/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf.history;

import com.fasterxml.jackson.core.Base64Variants;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.authc.blocking.Blocks;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.RoleMapping;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.sgconf.history.ConfigModel;
import com.floragunn.searchguard.sgconf.history.ConfigSnapshot;
import com.floragunn.searchguard.sgconf.history.ConfigVersion;
import com.floragunn.searchguard.sgconf.history.ConfigVersionSet;
import com.floragunn.searchguard.sgconf.history.UnknownConfigVersionException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.IndexNotFoundException;

public class ConfigHistoryService
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(ConfigHistoryService.class);
    public static final StaticSettings.Attribute<String> INDEX_NAME = StaticSettings.Attribute.define((String)"searchguard.config_history.index.name").withDefault(".searchguard_config_history").asString();
    public static final StaticSettings.Attribute<Integer> CACHE_TTL = StaticSettings.Attribute.define((String)"searchguard.config_history.cache.ttl").withDefault(2880).asInteger();
    public static final StaticSettings.Attribute<Integer> CACHE_MAX_SIZE = StaticSettings.Attribute.define((String)"searchguard.config_history.cache.max_size").withDefault(100).asInteger();
    public static final StaticSettings.Attribute<Integer> MODEL_CACHE_TTL = StaticSettings.Attribute.define((String)"searchguard.config_history.model.cache.ttl").withDefault(2880).asInteger();
    public static final StaticSettings.Attribute<Integer> MODEL_CACHE_MAX_SIZE = StaticSettings.Attribute.define((String)"searchguard.config_history.model.cache.max_size").withDefault(100).asInteger();
    private final String indexName;
    private final ConfigurationRepository configurationRepository;
    private final StaticSgConfig staticSgConfig;
    private final PrivilegedConfigClient privilegedConfigClient;
    private final Actions actions;
    private final Cache<ConfigVersion, SgDynamicConfiguration<?>> configCache;
    private final Cache<ConfigVersionSet, ConfigModel> configModelCache;
    private final ComponentState componentState = new ComponentState(1000, null, "config_history_service", ConfigHistoryService.class);
    private final PrivilegesEvaluator privilegesEvaluator;

    public ConfigHistoryService(ConfigurationRepository configurationRepository, StaticSgConfig staticSgConfig, PrivilegedConfigClient privilegedConfigClient, ProtectedConfigIndexService protectedConfigIndexService, Actions actions, StaticSettings settings, PrivilegesEvaluator privilegesEvaluator) {
        this.indexName = (String)settings.get(INDEX_NAME);
        this.privilegedConfigClient = privilegedConfigClient;
        this.configurationRepository = configurationRepository;
        this.staticSgConfig = staticSgConfig;
        this.actions = actions;
        this.configCache = CacheBuilder.newBuilder().weakValues().build();
        this.configModelCache = CacheBuilder.newBuilder().maximumSize((long)((Integer)settings.get(MODEL_CACHE_MAX_SIZE)).intValue()).expireAfterAccess((long)((Integer)settings.get(MODEL_CACHE_TTL)).intValue(), TimeUnit.MINUTES).build();
        this.privilegesEvaluator = privilegesEvaluator;
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(this.indexName).onIndexReady(f -> {
            f.onSuccess();
            this.componentState.setInitialized();
        })));
    }

    public ConfigSnapshot getCurrentConfigSnapshot() {
        return this.getCurrentConfigSnapshot(CType.all());
    }

    public ConfigSnapshot getCurrentConfigSnapshot(CType<?> first, CType<?> ... rest) {
        return this.getCurrentConfigSnapshot(CType.of(first, rest));
    }

    public ConfigSnapshot getCurrentConfigSnapshot(Set<CType<?>> configurationTypes) {
        HashMap configByType = new HashMap();
        for (CType<?> configurationType : configurationTypes) {
            SgDynamicConfiguration configuration = this.configurationRepository.getConfiguration(configurationType);
            if (configuration == null) {
                throw new IllegalStateException("Could not get configuration of type " + configurationType + " from configuration repository");
            }
            configByType.put(configurationType, configuration.withoutStatic());
        }
        ConfigVersionSet configVersionSet = ConfigVersionSet.from(configByType);
        ConfigSnapshot existingConfigSnapshots = this.peekConfigSnapshot(configVersionSet);
        if (existingConfigSnapshots.hasMissingConfigVersions()) {
            log.info("Storing missing config versions: " + existingConfigSnapshots.getMissingConfigVersions());
            this.storeMissingConfigDocs(existingConfigSnapshots.getMissingConfigVersions(), configByType);
            return new ConfigSnapshot(configByType);
        }
        return existingConfigSnapshots;
    }

    public void getConfigSnapshot(ConfigVersionSet configVersionSet, Consumer<ConfigSnapshot> onResult, Consumer<Exception> onFailure) {
        this.peekConfigSnapshot(configVersionSet, configSnapshot -> {
            if (configSnapshot.hasMissingConfigVersions()) {
                onFailure.accept(new UnknownConfigVersionException(configSnapshot.getMissingConfigVersions()));
            } else {
                onResult.accept((ConfigSnapshot)configSnapshot);
            }
        }, onFailure);
    }

    public void getConfigSnapshots(final Set<ConfigVersionSet> configVersionSets, final Consumer<Map<ConfigVersionSet, ConfigSnapshot>> onResult, Consumer<Exception> onFailure) {
        final HashMap configVersionMap = new HashMap(configVersionSets.size() * 2);
        HashSet<ConfigVersion> missingConfigVersions = new HashSet<ConfigVersion>(configVersionSets.size() * 2);
        for (ConfigVersionSet configVersionSet : configVersionSets) {
            for (ConfigVersion configurationVersion : configVersionSet) {
                SgDynamicConfiguration configuration = (SgDynamicConfiguration)this.configCache.getIfPresent((Object)configurationVersion);
                if (configuration != null) {
                    configVersionMap.put(configurationVersion, configuration);
                    continue;
                }
                missingConfigVersions.add(configurationVersion);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("missingConfigVersions: " + missingConfigVersions.size());
        }
        if (missingConfigVersions.size() == 0) {
            onResult.accept(this.buildConfigSnapshotResultMap(configVersionSets, configVersionMap));
        } else {
            MultiGetRequest multiGetRequest = new MultiGetRequest();
            for (ConfigVersion configurationVersion : missingConfigVersions) {
                multiGetRequest.add(this.indexName, configurationVersion.toId());
            }
            this.privilegedConfigClient.multiGet(multiGetRequest, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    try {
                        for (MultiGetItemResponse itemResponse : response.getResponses()) {
                            if (itemResponse.getResponse() == null) {
                                if (itemResponse.getFailure() != null) {
                                    if (itemResponse.getFailure().getFailure() instanceof IndexNotFoundException) continue;
                                    log.warn("Error while retrieving configuration versions " + itemResponse + ": " + itemResponse.getFailure().getFailure());
                                    continue;
                                }
                                log.warn("Error while retrieving configuration versions " + itemResponse);
                                continue;
                            }
                            if (itemResponse.getResponse().isExists()) {
                                SgDynamicConfiguration<?> sgDynamicConfig = ConfigHistoryService.this.parseConfig(itemResponse.getResponse());
                                ConfigVersion configVersion = new ConfigVersion(sgDynamicConfig.getCType(), sgDynamicConfig.getDocVersion());
                                configVersionMap.put(configVersion, sgDynamicConfig);
                                ConfigHistoryService.this.configCache.put((Object)configVersion, sgDynamicConfig);
                            }
                            onResult.accept(ConfigHistoryService.this.buildConfigSnapshotResultMap(configVersionSets, configVersionMap));
                        }
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    this.onFailure(e);
                }
            });
        }
    }

    private Map<ConfigVersionSet, ConfigSnapshot> buildConfigSnapshotResultMap(Set<ConfigVersionSet> configVersionSets, Map<ConfigVersion, SgDynamicConfiguration<?>> configVersionMap) {
        HashMap<ConfigVersionSet, ConfigSnapshot> result = new HashMap<ConfigVersionSet, ConfigSnapshot>(configVersionSets.size());
        for (ConfigVersionSet configVersionSet : configVersionSets) {
            ConfigSnapshot configSnapshot = this.peekConfigSnapshotFromCache(configVersionSet);
            if (configSnapshot.hasMissingConfigVersions()) {
                log.error("Could not completely load " + configVersionSet + ". Missing: " + configSnapshot.getMissingConfigVersions());
                continue;
            }
            result.put(configVersionSet, configSnapshot);
        }
        return result;
    }

    public ConfigModel getConfigModelForSnapshot(ConfigSnapshot configSnapshot) {
        ConfigVersionSet configVersionSet = configSnapshot.getConfigVersions();
        ConfigModel configModel = (ConfigModel)this.configModelCache.getIfPresent((Object)configVersionSet);
        if (configModel != null) {
            return configModel;
        }
        return this.createConfigModelForSnapshot(configSnapshot);
    }

    private ConfigModel createConfigModelForSnapshot(ConfigSnapshot configSnapshot) {
        SgDynamicConfiguration roles = configSnapshot.getConfigByType(Role.class);
        SgDynamicConfiguration<RoleMapping> roleMappings = configSnapshot.getConfigByType(RoleMapping.class);
        SgDynamicConfiguration actionGroups = configSnapshot.getConfigByType(ActionGroup.class);
        SgDynamicConfiguration tenants = configSnapshot.getConfigByType(Tenant.class);
        SgDynamicConfiguration blocks = configSnapshot.getConfigByType(Blocks.class);
        if (blocks == null) {
            blocks = SgDynamicConfiguration.empty((CType)CType.BLOCKS);
        }
        roles = this.staticSgConfig.addTo(roles);
        actionGroups = this.staticSgConfig.addTo(actionGroups);
        tenants = this.staticSgConfig.addTo(tenants);
        ConfigModel configModel = new ConfigModel((SgDynamicConfiguration<Role>)roles, roleMappings, (SgDynamicConfiguration<ActionGroup>)actionGroups, (SgDynamicConfiguration<Tenant>)tenants, (SgDynamicConfiguration<Blocks>)blocks, this.actions, this.privilegesEvaluator.getResolver(), this.privilegesEvaluator.getClusterService());
        this.configModelCache.put((Object)configSnapshot.getConfigVersions(), (Object)configModel);
        return configModel;
    }

    public ConfigSnapshot peekConfigSnapshotFromCache(ConfigVersionSet configVersionSet) {
        HashMap configByType = new HashMap();
        for (ConfigVersion configurationVersion : configVersionSet) {
            SgDynamicConfiguration configuration = (SgDynamicConfiguration)this.configCache.getIfPresent((Object)configurationVersion);
            if (configuration == null) continue;
            configByType.put(configurationVersion.getConfigurationType(), configuration);
        }
        return new ConfigSnapshot(configByType, configVersionSet);
    }

    public ConfigSnapshot peekConfigSnapshot(ConfigVersionSet configVersionSet) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.peekConfigSnapshot(configVersionSet, completableFuture::complete, completableFuture::completeExceptionally);
        try {
            return (ConfigSnapshot)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void peekConfigSnapshot(final ConfigVersionSet configVersionSet, final Consumer<ConfigSnapshot> onResult, final Consumer<Exception> onFailure) {
        try {
            final HashMap configByType = new HashMap();
            for (ConfigVersion configurationVersion : configVersionSet) {
                SgDynamicConfiguration configuration = (SgDynamicConfiguration)this.configCache.getIfPresent((Object)configurationVersion);
                if (configuration == null) continue;
                configByType.put(configurationVersion.getConfigurationType(), configuration);
            }
            if (configByType.size() == configVersionSet.size()) {
                onResult.accept(new ConfigSnapshot(configByType, configVersionSet));
            } else {
                MultiGetRequest multiGetRequest = new MultiGetRequest();
                for (ConfigVersion configurationVersion : configVersionSet) {
                    if (configByType.containsKey(configurationVersion.getConfigurationType())) continue;
                    multiGetRequest.add(this.indexName, configurationVersion.toId());
                }
                this.privilegedConfigClient.multiGet(multiGetRequest, (ActionListener)new ActionListener<MultiGetResponse>(){

                    public void onResponse(MultiGetResponse response) {
                        try {
                            for (MultiGetItemResponse itemResponse : response.getResponses()) {
                                if (itemResponse.getResponse() == null) {
                                    if (itemResponse.getFailure() != null) {
                                        if (itemResponse.getFailure().getFailure() instanceof IndexNotFoundException) continue;
                                        throw new ElasticsearchException("Error while retrieving configuration versions " + configVersionSet + ": " + itemResponse.getFailure().getFailure(), new Object[0]);
                                    }
                                    throw new ElasticsearchException("Error while retrieving configuration versions " + configVersionSet + ": " + itemResponse, new Object[0]);
                                }
                                if (!itemResponse.getResponse().isExists()) continue;
                                SgDynamicConfiguration<?> sgDynamicConfig = ConfigHistoryService.this.parseConfig(itemResponse.getResponse());
                                configByType.put(sgDynamicConfig.getCType(), sgDynamicConfig);
                                ConfigHistoryService.this.configCache.put((Object)new ConfigVersion(sgDynamicConfig.getCType(), sgDynamicConfig.getDocVersion()), sgDynamicConfig);
                            }
                            onResult.accept(new ConfigSnapshot(configByType, configVersionSet));
                        }
                        catch (Exception e) {
                            onFailure.accept(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        onFailure.accept(e);
                    }
                });
            }
        }
        catch (Exception e) {
            onFailure.accept(e);
        }
    }

    public SgDynamicConfiguration<?> parseConfig(GetResponse singleGetResponse) throws ConfigValidationException {
        ConfigVersion configurationVersion = ConfigVersion.fromId(singleGetResponse.getId());
        Object config = singleGetResponse.getSource().get("config");
        if (!(config instanceof String)) {
            throw new IllegalStateException("Malformed config history record: " + config + "\n" + singleGetResponse.getSource());
        }
        String jsonString = new String(Base64Variants.getDefaultVariant().decode((String)config));
        try {
            return (SgDynamicConfiguration)SgDynamicConfiguration.fromJson((String)jsonString, configurationVersion.getConfigurationType(), (long)configurationVersion.getVersion(), (long)0L, (long)0L, (ConfigurationRepository.Context)this.configurationRepository.getParserContext()).get();
        }
        catch (Exception e) {
            this.componentState.addLastException("parseConfig", new ComponentState.ExceptionRecord((Throwable)e, "Error while parsing config history record"));
            throw new RuntimeException("Error while parsing config history record: " + jsonString + "\n" + singleGetResponse);
        }
    }

    private void storeMissingConfigDocs(ConfigVersionSet missingVersions, Map<CType<?>, SgDynamicConfiguration<?>> configByType) {
        BulkRequestBuilder bulkRequest = this.privilegedConfigClient.prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (ConfigVersion missingVersion : missingVersions) {
            SgDynamicConfiguration<?> config = configByType.get(missingVersion.getConfigurationType());
            this.configCache.put((Object)missingVersion, config);
            BytesReference uninterpolatedConfigBytes = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(config.getUninterpolatedJson().getBytes()));
            bulkRequest.add(new IndexRequest(this.indexName).id(missingVersion.toId()).source(new Object[]{"config", uninterpolatedConfigBytes}));
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
        if (bulkResponse.hasFailures()) {
            throw new RuntimeException("Failure while storing configs " + missingVersions + "; " + bulkResponse.buildFailureMessage());
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

