/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf.history;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.sgconf.history.ConfigVersion;
import com.floragunn.searchguard.sgconf.history.ConfigVersionSet;
import java.util.Map;

public class ConfigSnapshot {
    private final Map<CType<?>, SgDynamicConfiguration<?>> configByType;
    private final ConfigVersionSet configVersions;
    private final ConfigVersionSet missingConfigVersions;

    public ConfigSnapshot(Map<CType<?>, SgDynamicConfiguration<?>> configByType) {
        this.configByType = configByType;
        this.configVersions = ConfigVersionSet.from(configByType);
        this.missingConfigVersions = ConfigVersionSet.EMPTY;
    }

    public ConfigSnapshot(Map<CType<?>, SgDynamicConfiguration<?>> configByType, ConfigVersionSet configVersionSet) {
        this.configByType = configByType;
        this.configVersions = configVersionSet;
        this.missingConfigVersions = this.findMissingVersions();
    }

    private ConfigVersionSet findMissingVersions() {
        ConfigVersionSet.Builder builder = new ConfigVersionSet.Builder();
        for (ConfigVersion configVersion : this.configVersions) {
            if (this.configByType.containsKey(configVersion.getConfigurationType())) continue;
            builder.add(configVersion);
        }
        return builder.build();
    }

    public ConfigVersionSet getConfigVersions() {
        return this.configVersions;
    }

    public ConfigVersionSet getMissingConfigVersions() {
        return this.missingConfigVersions;
    }

    public boolean hasMissingConfigVersions() {
        return this.missingConfigVersions.size() > 0;
    }

    public SgDynamicConfiguration<?> getConfigByType(CType<?> configType) {
        return this.configByType.get(configType);
    }

    public <T> SgDynamicConfiguration<T> getConfigByType(Class<T> configType) {
        SgDynamicConfiguration<?> config = this.getConfigByType(CType.getByClass(configType));
        return config;
    }

    public String toString() {
        return "ConfigSnapshot [configByType=" + this.configByType + ", configVersions=" + this.configVersions + ", missingConfigVersions=" + this.missingConfigVersions + "]";
    }
}

