/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ServerSideSortResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String SERVER_SIDE_SORT_RESPONSE_OID = "1.2.840.113556.1.4.474";
    private static final byte TYPE_ATTRIBUTE_TYPE = -128;
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTE_NAME = "attribute-name";
    @NotNull
    private static final String JSON_FIELD_RESULT_CODE = "result-code";
    private static final long serialVersionUID = -8707533262822875822L;
    @NotNull
    private final ResultCode resultCode;
    @Nullable
    private final String attributeName;

    ServerSideSortResponseControl() {
        this.resultCode = null;
        this.attributeName = null;
    }

    public ServerSideSortResponseControl(@NotNull ResultCode resultCode, @Nullable String attributeName) {
        this(resultCode, attributeName, false);
    }

    public ServerSideSortResponseControl(@NotNull ResultCode resultCode, @Nullable String attributeName, boolean isCritical) {
        super(SERVER_SIDE_SORT_RESPONSE_OID, isCritical, ServerSideSortResponseControl.encodeValue(resultCode, attributeName));
        this.resultCode = resultCode;
        this.attributeName = attributeName;
    }

    public ServerSideSortResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] valueElements = valueSequence.elements();
        if (valueElements.length < 1 || valueElements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_INVALID_ELEMENT_COUNT.get(valueElements.length));
        }
        try {
            int rc = ASN1Enumerated.decodeAsEnumerated(valueElements[0]).intValue();
            this.resultCode = ResultCode.valueOf(rc);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_FIRST_NOT_ENUM.get(ae), ae);
        }
        this.attributeName = valueElements.length == 2 ? ASN1OctetString.decodeAsOctetString(valueElements[1]).stringValue() : null;
    }

    @Override
    @NotNull
    public ServerSideSortResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new ServerSideSortResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static ServerSideSortResponseControl get(@NotNull SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(SERVER_SIDE_SORT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof ServerSideSortResponseControl) {
            return (ServerSideSortResponseControl)c;
        }
        return new ServerSideSortResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ResultCode resultCode, @Nullable String attributeName) {
        ASN1Element[] valueElements = attributeName == null ? new ASN1Element[]{new ASN1Enumerated(resultCode.intValue())} : new ASN1Element[]{new ASN1Enumerated(resultCode.intValue()), new ASN1OctetString(-128, attributeName)};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    @NotNull
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SORT_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_RESULT_CODE, new JSONNumber(this.resultCode.intValue()));
        if (this.attributeName != null) {
            valueFields.put(JSON_FIELD_ATTRIBUTE_NAME, new JSONString(this.attributeName));
        }
        return new JSONObject(new JSONField("oid", SERVER_SIDE_SORT_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SORT_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static ServerSideSortResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new ServerSideSortResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer resultCodeValue = valueObject.getFieldAsInteger(JSON_FIELD_RESULT_CODE);
        if (resultCodeValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_JSON_MISSING_RESULT_CODE.get(controlObject.toSingleLineString(), JSON_FIELD_RESULT_CODE));
        }
        ResultCode resultCode = ResultCode.valueOf(resultCodeValue);
        String attributeName = valueObject.getFieldAsString(JSON_FIELD_ATTRIBUTE_NAME);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_RESULT_CODE, JSON_FIELD_ATTRIBUTE_NAME)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new ServerSideSortResponseControl(resultCode, attributeName, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ServerSideSortResponseControl(resultCode=");
        buffer.append(this.resultCode);
        if (this.attributeName != null) {
            buffer.append(", attributeName='");
            buffer.append(this.attributeName);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

