/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.factory;

import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.AuthnRequestParams;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.logout.LogoutRequestParams;
import com.onelogin.saml2.logout.LogoutResponse;
import com.onelogin.saml2.logout.LogoutResponseParams;
import com.onelogin.saml2.settings.Saml2Settings;

public interface SamlMessageFactory {
    default public AuthnRequest createAuthnRequest(Saml2Settings settings, AuthnRequestParams params) {
        return new AuthnRequest(settings, params);
    }

    default public SamlResponse createSamlResponse(Saml2Settings settings, HttpRequest request) throws Exception {
        return new SamlResponse(settings, request);
    }

    default public LogoutRequest createOutgoingLogoutRequest(Saml2Settings settings, LogoutRequestParams params) {
        return new LogoutRequest(settings, params);
    }

    default public LogoutRequest createIncomingLogoutRequest(Saml2Settings settings, HttpRequest request) throws Exception {
        return new LogoutRequest(settings, request);
    }

    default public LogoutResponse createOutgoingLogoutResponse(Saml2Settings settings, LogoutResponseParams params) {
        return new LogoutResponse(settings, params);
    }

    default public LogoutResponse createIncomingLogoutResponse(Saml2Settings settings, HttpRequest request) throws Exception {
        return new LogoutResponse(settings, request);
    }
}

