/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpChannel
implements HttpChannel {
    private final Channel channel;
    private final ListenableFuture<Void> closeContext = new ListenableFuture();

    Netty4HttpChannel(Channel channel) {
        this.channel = channel;
        Netty4Utils.addListener((Future<Void>)this.channel.closeFuture(), this.closeContext);
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        Netty4Utils.safeWriteAndFlush(this.channel, response, listener);
    }

    public InetSocketAddress getLocalAddress() {
        return Netty4HttpChannel.castAddressOrNull(this.channel.localAddress());
    }

    public InetSocketAddress getRemoteAddress() {
        return Netty4HttpChannel.castAddressOrNull(this.channel.remoteAddress());
    }

    private static InetSocketAddress castAddressOrNull(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + "}";
    }
}

