/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.UnmodifiableSet;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class ImmutableSetImpl<E>
extends UnmodifiableSetImpl<E>
implements UnmodifiableSet<E> {
    private static final Set<Object> EMPTY = new ImmutableSetImpl<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }
    };

    ImmutableSetImpl() {
    }

    static <E> ImmutableSetImpl<E> of(E e1) {
        if (e1 == null) {
            throw new IllegalArgumentException("Does not support null elements");
        }
        return new OneElementSet<E>(e1);
    }

    static <E> ImmutableSetImpl<E> of(E e1, E e2) {
        if (e1 == null || e2 == null) {
            throw new IllegalArgumentException("Does not support null elements");
        }
        if (!e1.equals(e2)) {
            return new TwoElementSet<E>(e1, e2);
        }
        return new OneElementSet<E>(e1);
    }

    static <E> ImmutableSetImpl<E> empty() {
        ImmutableSetImpl result = (ImmutableSetImpl)EMPTY;
        return result;
    }

    static class OneElementSet<E>
    extends ImmutableSetImpl<E> {
        private final E element;

        OneElementSet(E element) {
            this.element = element;
        }

        @Override
        public boolean contains(Object o) {
            return this.element.equals(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 1;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return element;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 1 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            result[0] = this.element;
            return result;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    static class TwoElementSet<E>
    extends ImmutableSetImpl<E> {
        private final E e1;
        private final E e2;

        TwoElementSet(E e1, E e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o) || this.e2.equals(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 2;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return e1;
                    }
                    if (this.i == 1) {
                        ++this.i;
                        return e2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1, this.e2};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 2 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
            result[0] = this.e1;
            result[1] = this.e2;
            return result;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

