/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import com.google.code.regexp.Pattern;
import jakarta.activation.DataSource;
import jakarta.mail.Message;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.internal.clisupport.model.Cli;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.mailer.config.Pkcs12Config;

@Cli.BuilderApiNode(builderApiType=CliBuilderApiType.EMAIL)
public interface EmailPopulatingBuilder {
    public static final Pattern IMG_SRC_PATTERN = Pattern.compile((String)"(?<imageTagStart><[Ii][Mm][Gg]\\s*[^>]*?\\s+[Ss][Rr][Cc]\\s*=\\s*[\"'])(?<src>[^\"']+?)(?<imageSrcEnd>[\"'])");

    @Cli.ExcludeApi(reason="This API is specifically for Java use")
    public Email buildEmail();

    public EmailPopulatingBuilder fixingMessageId(@Nullable String var1);

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder from(@NotNull String var1);

    public EmailPopulatingBuilder from(@Nullable String var1, @NotNull String var2);

    public EmailPopulatingBuilder from(@Nullable String var1, @NotNull InternetAddress var2);

    public EmailPopulatingBuilder from(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder from(@NotNull Recipient var1);

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReplyTo(@Nullable String var1);

    public EmailPopulatingBuilder withReplyTo(@Nullable String var1, @NotNull String var2);

    public EmailPopulatingBuilder withReplyTo(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder withReplyTo(@Nullable String var1, @NotNull InternetAddress var2);

    public EmailPopulatingBuilder withReplyTo(@Nullable Recipient var1);

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withBounceTo(@Nullable String var1);

    public EmailPopulatingBuilder withBounceTo(@Nullable String var1, @NotNull String var2);

    public EmailPopulatingBuilder withBounceTo(@NotNull InternetAddress var1);

    @Cli.ExcludeApi(reason="Method is not detailed enough for CLI")
    public EmailPopulatingBuilder withBounceTo(@Nullable String var1, @NotNull InternetAddress var2);

    public EmailPopulatingBuilder withBounceTo(@Nullable Recipient var1);

    public EmailPopulatingBuilder withSubject(@Nullable String var1);

    @Cli.OptionNameOverride(value="withPlainTextFromFile")
    public EmailPopulatingBuilder withPlainText(@NotNull File var1);

    public EmailPopulatingBuilder withPlainText(@Nullable String var1);

    @Cli.OptionNameOverride(value="prependTextFromFile")
    public EmailPopulatingBuilder prependText(@NotNull File var1);

    public EmailPopulatingBuilder prependText(@NotNull String var1);

    @Cli.OptionNameOverride(value="appendTextFromFile")
    public EmailPopulatingBuilder appendText(@NotNull File var1);

    public EmailPopulatingBuilder appendText(@NotNull String var1);

    @Cli.OptionNameOverride(value="withHTMLTextFromFile")
    public EmailPopulatingBuilder withHTMLText(@NotNull File var1);

    public EmailPopulatingBuilder withHTMLText(@Nullable String var1);

    @Cli.OptionNameOverride(value="prependTextHTMLFromFile")
    public EmailPopulatingBuilder prependTextHTML(@NotNull File var1);

    public EmailPopulatingBuilder prependTextHTML(@NotNull String var1);

    @Cli.OptionNameOverride(value="appendTextHTMLFromFile")
    public EmailPopulatingBuilder appendTextHTML(@NotNull File var1);

    public EmailPopulatingBuilder appendTextHTML(@NotNull String var1);

    public EmailPopulatingBuilder withCalendarText(@NotNull CalendarMethod var1, @NotNull String var2);

    public EmailPopulatingBuilder to(Recipient ... var1);

    public EmailPopulatingBuilder to(@NotNull Collection<Recipient> var1);

    public EmailPopulatingBuilder to(@Nullable String var1, String var2);

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder to(@NotNull String var1);

    public EmailPopulatingBuilder to(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder to(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder toMultiple(String ... var1);

    public EmailPopulatingBuilder toMultiple(@NotNull Collection<String> var1);

    public EmailPopulatingBuilder toWithFixedName(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String var1, String ... var2);

    public EmailPopulatingBuilder toWithFixedName(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder toWithDefaultName(@NotNull String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder to(@Nullable String var1, InternetAddress var2);

    public EmailPopulatingBuilder to(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder to(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder toAddresses(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder toMultiple(InternetAddress ... var1);

    public EmailPopulatingBuilder toMultipleAddresses(@NotNull Collection<InternetAddress> var1);

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder toAddressesWithDefaultName(@NotNull String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder cc(Recipient ... var1);

    public EmailPopulatingBuilder cc(@NotNull Collection<Recipient> var1);

    public EmailPopulatingBuilder cc(@Nullable String var1, String var2);

    @Cli.ExcludeApi(reason="API is subset of another API method")
    public EmailPopulatingBuilder cc(@NotNull String var1);

    public EmailPopulatingBuilder cc(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder cc(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder ccMultiple(String ... var1);

    public EmailPopulatingBuilder ccAddresses(@NotNull Collection<String> var1);

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String var1, String ... var2);

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder ccWithDefaultName(@NotNull String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder cc(@Nullable String var1, InternetAddress var2);

    public EmailPopulatingBuilder cc(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder cc(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder ccAddresses(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder ccMultiple(InternetAddress ... var1);

    public EmailPopulatingBuilder ccMultipleAddresses(@NotNull Collection<InternetAddress> var1);

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@NotNull String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder bcc(Recipient ... var1);

    public EmailPopulatingBuilder bcc(@NotNull Collection<Recipient> var1);

    public EmailPopulatingBuilder bcc(@Nullable String var1, String var2);

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder bcc(@NotNull String var1);

    public EmailPopulatingBuilder bcc(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder bcc(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder bccMultiple(String ... var1);

    public EmailPopulatingBuilder bccAddresses(@NotNull Collection<String> var1);

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String var1, String ... var2);

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String var1, String ... var2);

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder bccWithDefaultName(@NotNull String var1, @NotNull Collection<String> var2);

    public EmailPopulatingBuilder bcc(@Nullable String var1, InternetAddress var2);

    public EmailPopulatingBuilder bcc(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder bcc(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder bccAddresses(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder bccMultiple(InternetAddress ... var1);

    public EmailPopulatingBuilder bccMultipleAddresses(@NotNull Collection<InternetAddress> var1);

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String var1, InternetAddress ... var2);

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String var1, @NotNull Collection<InternetAddress> var2);

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@NotNull String var1, @NotNull Collection<InternetAddress> var2);

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String var1, @NotNull Collection<String> var2, @Nullable Message.RecipientType var3);

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String var1, @NotNull Collection<String> var2, @Nullable Message.RecipientType var3);

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String var1, @Nullable Message.RecipientType var2, String ... var3);

    @NotNull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String var1, @Nullable Message.RecipientType var2, String ... var3);

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String var1, boolean var2, @Nullable Message.RecipientType var3, String ... var4);

    @NotNull
    public EmailPopulatingBuilder withRecipients(@Nullable String var1, boolean var2, @NotNull Collection<String> var3, @Nullable Message.RecipientType var4);

    @NotNull
    public EmailPopulatingBuilder withAddressesWithDefaultName(@Nullable String var1, @NotNull Collection<InternetAddress> var2, @Nullable Message.RecipientType var3);

    @NotNull
    public EmailPopulatingBuilder withAddressesWithFixedName(@Nullable String var1, @NotNull Collection<InternetAddress> var2, @Nullable Message.RecipientType var3);

    @NotNull
    public EmailPopulatingBuilder withAddresses(@Nullable String var1, boolean var2, @NotNull Collection<InternetAddress> var3, @Nullable Message.RecipientType var4);

    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> var1);

    public EmailPopulatingBuilder withRecipients(Recipient ... var1);

    @NotNull
    public EmailPopulatingBuilder withRecipients(@NotNull Collection<Recipient> var1, @Nullable Message.RecipientType var2);

    public EmailPopulatingBuilder withRecipient(@NotNull String var1, @Nullable Message.RecipientType var2);

    public EmailPopulatingBuilder withRecipient(@Nullable String var1, @NotNull String var2, @Nullable Message.RecipientType var3);

    public EmailPopulatingBuilder withRecipient(@Nullable String var1, boolean var2, @NotNull String var3, @Nullable Message.RecipientType var4);

    public EmailPopulatingBuilder withRecipient(@NotNull Recipient var1);

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForFiles(boolean var1);

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForClassPathResources(boolean var1);

    public EmailPopulatingBuilder withEmbeddedImageAutoResolutionForURLs(boolean var1);

    public EmailPopulatingBuilder withEmbeddedImageBaseDir(@NotNull String var1);

    public EmailPopulatingBuilder withEmbeddedImageBaseClassPath(@NotNull String var1);

    public EmailPopulatingBuilder withEmbeddedImageBaseUrl(@NotNull String var1);

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder withEmbeddedImageBaseUrl(@NotNull URL var1);

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseDir(boolean var1);

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseClassPath(boolean var1);

    public EmailPopulatingBuilder allowingEmbeddedImageOutsideBaseUrl(boolean var1);

    public EmailPopulatingBuilder embeddedImageAutoResolutionMustBeSuccesful(boolean var1);

    public EmailPopulatingBuilder withEmbeddedImage(@NotNull String var1, @NotNull byte[] var2, @NotNull String var3);

    public EmailPopulatingBuilder withEmbeddedImage(@Nullable String var1, @NotNull DataSource var2);

    public EmailPopulatingBuilder withEmbeddedImages(@NotNull List<AttachmentResource> var1);

    public <T> EmailPopulatingBuilder withHeaders(@NotNull Map<String, Collection<T>> var1);

    public EmailPopulatingBuilder withHeader(@NotNull String var1, @Nullable Object var2);

    public EmailPopulatingBuilder withAttachment(@Nullable String var1, @NotNull byte[] var2, @NotNull String var3);

    public EmailPopulatingBuilder withAttachment(@Nullable String var1, @NotNull DataSource var2);

    public EmailPopulatingBuilder withAttachments(@NotNull List<AttachmentResource> var1);

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull byte[] var1, @NotNull String var2, @NotNull String var3);

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public EmailPopulatingBuilder signWithDomainKey(@NotNull InputStream var1, @NotNull String var2, @NotNull String var3);

    @Cli.ExcludeApi(reason="delegated method is an identical api from CLI point of view")
    public EmailPopulatingBuilder signWithDomainKey(@NotNull File var1, @NotNull String var2, @NotNull String var3);

    @Cli.ExcludeApi(reason="delegated method contains CLI compatible arguments")
    public EmailPopulatingBuilder signWithSmime(@NotNull Pkcs12Config var1);

    public EmailPopulatingBuilder signWithSmime(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public EmailPopulatingBuilder signWithSmime(@NotNull InputStream var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public EmailPopulatingBuilder signWithSmime(@NotNull byte[] var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull InputStream var1);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull String var1);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public EmailPopulatingBuilder encryptWithSmime(@NotNull File var1);

    public EmailPopulatingBuilder encryptWithSmime(@NotNull X509Certificate var1);

    public EmailPopulatingBuilder notMergingSingleSMIMESignedAttachment();

    @Cli.OptionNameOverride(value="withDispositionNotificationToEnabled")
    public EmailPopulatingBuilder withDispositionNotificationTo();

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull String var1);

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String var1, @NotNull String var2);

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String var1, @NotNull InternetAddress var2);

    public EmailPopulatingBuilder withDispositionNotificationTo(@NotNull Recipient var1);

    @Cli.OptionNameOverride(value="withReturnReceiptToEnabled")
    public EmailPopulatingBuilder withReturnReceiptTo();

    @Cli.ExcludeApi(reason="API is subset of another API")
    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull String var1);

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String var1, @NotNull String var2);

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull InternetAddress var1);

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String var1, @NotNull InternetAddress var2);

    public EmailPopulatingBuilder withReturnReceiptTo(@NotNull Recipient var1);

    public EmailPopulatingBuilder fixingSentDate(@NotNull Date var1);

    public EmailPopulatingBuilder clearId();

    public EmailPopulatingBuilder clearFromRecipient();

    public EmailPopulatingBuilder clearReplyTo();

    public EmailPopulatingBuilder clearBounceTo();

    public EmailPopulatingBuilder clearPlainText();

    public EmailPopulatingBuilder clearHTMLText();

    public EmailPopulatingBuilder clearSubject();

    public EmailPopulatingBuilder clearRecipients();

    public EmailPopulatingBuilder clearEmbeddedImageBaseDir();

    public EmailPopulatingBuilder clearEmbeddedImageBaseClassPath();

    public EmailPopulatingBuilder clearEmbeddedImageBaseUrl();

    public EmailPopulatingBuilder clearEmbeddedImages();

    public EmailPopulatingBuilder clearAttachments();

    public EmailPopulatingBuilder clearHeaders();

    public EmailPopulatingBuilder clearDkim();

    public EmailPopulatingBuilder clearSmime();

    public EmailPopulatingBuilder clearDispositionNotificationTo();

    public EmailPopulatingBuilder clearReturnReceiptTo();

    public EmailPopulatingBuilder clearSentDate();

    public EmailPopulatingBuilder clearSMIMESignedAttachmentMergingBehavior();

    @Nullable
    public String getId();

    @Nullable
    public Recipient getFromRecipient();

    @Nullable
    public Recipient getReplyToRecipient();

    @Nullable
    public Recipient getBounceToRecipient();

    @Nullable
    public String getText();

    @Nullable
    public String getTextHTML();

    @Nullable
    public CalendarMethod getCalendarMethod();

    @Nullable
    public String getTextCalendar();

    @Nullable
    public String getSubject();

    @NotNull
    public List<Recipient> getRecipients();

    @NotNull
    public List<AttachmentResource> getEmbeddedImages();

    @NotNull
    public List<AttachmentResource> getAttachments();

    @NotNull
    public List<AttachmentResource> getDecryptedAttachments();

    @NotNull
    public Map<String, Collection<String>> getHeaders();

    @Nullable
    public byte[] getDkimPrivateKeyData();

    @Nullable
    public String getDkimSigningDomain();

    @Nullable
    public String getDkimSelector();

    public boolean isUseDispositionNotificationTo();

    @Nullable
    public Recipient getDispositionNotificationTo();

    public boolean isUseReturnReceiptTo();

    @Nullable
    public Recipient getReturnReceiptTo();

    @Nullable
    public MimeMessage getEmailToForward();

    @NotNull
    public OriginalSmimeDetails getOriginalSmimeDetails();

    @Nullable
    public Email getSmimeSignedEmail();

    public boolean isMergeSingleSMIMESignedAttachment();

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning();

    @Nullable
    public X509Certificate getX509CertificateForSmimeEncryption();

    @Nullable
    public Date getSentDate();
}

