/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.InvalidTopLevelDomainException;

public final class TopLevelDomain {
    public static final TopLevelDomain DOT_COM = new TopLevelDomain("com");
    public static final TopLevelDomain DOT_ORG = new TopLevelDomain("org");
    public static final TopLevelDomain DOT_NET = new TopLevelDomain("net");
    public static final TopLevelDomain DOT_INT = new TopLevelDomain("int");
    public static final TopLevelDomain DOT_EDU = new TopLevelDomain("edu");
    public static final TopLevelDomain DOT_GOV = new TopLevelDomain("gov");
    public static final TopLevelDomain DOT_MIL = new TopLevelDomain("mil");
    public static final TopLevelDomain NONE = new TopLevelDomain("");
    private final String tld;

    private TopLevelDomain(String tld) {
        this.tld = tld;
    }

    String stringValue() {
        return this.tld;
    }

    public static TopLevelDomain fromString(String tld) {
        String dotless;
        if (tld == null || tld.isEmpty()) {
            throw new InvalidTopLevelDomainException();
        }
        String string = dotless = tld.charAt(0) == '.' ? tld.substring(1) : tld;
        if (!TopLevelDomain.isValidTopLevelDomain(dotless)) {
            throw new InvalidTopLevelDomainException();
        }
        return new TopLevelDomain(dotless);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopLevelDomain)) {
            return false;
        }
        TopLevelDomain that = (TopLevelDomain)o;
        return this.tld.equals(that.tld);
    }

    public int hashCode() {
        return this.tld.hashCode();
    }

    public String toString() {
        return "TopLevelDomain[tld='" + this.tld + "']";
    }

    private static boolean isValidTopLevelDomain(String domain) {
        if (domain == null || domain.isEmpty()) {
            return false;
        }
        int size = domain.length();
        if (size > 63) {
            return false;
        }
        if (domain.charAt(0) == '-' || domain.charAt(size - 1) == '-') {
            return false;
        }
        boolean isAllNumeric = true;
        for (int i = 0; i < size; ++i) {
            char c = domain.charAt(i);
            if (c == '.') {
                return false;
            }
            if (Character.isDigit(c)) continue;
            isAllNumeric = false;
        }
        return !isAllNumeric;
    }
}

