/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ActivatedFrontendConfig {
    private List<AuthMethod> authMethods;

    private ActivatedFrontendConfig(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public List<AuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public static class AuthMethod
    implements Document<AuthMethod> {
        private final String id;
        private final String method;
        private final boolean session;
        private final boolean unavailable;
        private final String label;
        private final String message;
        private final String messageTitle;
        private final String ssoLocation;
        private final String ssoContext;
        private final boolean captureUrlFragment;
        private final boolean autoSelect;
        private final Map<String, Object> details;
        private final Map<String, Object> config;

        public AuthMethod(String method, String label, String id) {
            this.method = method;
            this.label = label;
            this.id = id;
            this.session = true;
            this.unavailable = false;
            this.message = null;
            this.messageTitle = null;
            this.config = Collections.emptyMap();
            this.ssoLocation = null;
            this.ssoContext = null;
            this.details = Collections.emptyMap();
            this.captureUrlFragment = false;
            this.autoSelect = false;
        }

        public AuthMethod(String method, String label, String id, boolean session, boolean unavailable, boolean captureUrlFragment, boolean autoSelect, String messageTitle, String message) {
            this.method = method;
            this.label = label;
            this.id = id;
            this.session = session;
            this.unavailable = unavailable;
            this.captureUrlFragment = captureUrlFragment;
            this.autoSelect = autoSelect;
            this.messageTitle = messageTitle;
            this.message = message;
            this.config = Collections.emptyMap();
            this.ssoLocation = null;
            this.ssoContext = null;
            this.details = Collections.emptyMap();
        }

        private AuthMethod(String method, String label, String id, boolean session, boolean unavailable, boolean captureUrlFragment, boolean autoSelect, String messageTitle, String message, String ssoLocation, String ssoContext, Map<String, Object> config) {
            this.method = method;
            this.id = id;
            this.session = session;
            this.unavailable = unavailable;
            this.captureUrlFragment = captureUrlFragment;
            this.autoSelect = autoSelect;
            this.label = label;
            this.messageTitle = messageTitle;
            this.message = message;
            this.ssoLocation = ssoLocation;
            this.ssoContext = ssoContext;
            this.config = Collections.unmodifiableMap(new HashMap<String, Object>(config));
            this.details = Collections.emptyMap();
        }

        private AuthMethod(String method, String label, String id, boolean session, boolean unavailable, boolean captureUrlFragment, boolean autoSelect, String messageTitle, String message, String ssoLocation, String ssoContext, Map<String, Object> config, Map<String, Object> details) {
            this.method = method;
            this.id = id;
            this.session = session;
            this.unavailable = unavailable;
            this.captureUrlFragment = captureUrlFragment;
            this.autoSelect = autoSelect;
            this.label = label;
            this.messageTitle = messageTitle;
            this.message = message;
            this.ssoLocation = ssoLocation;
            this.ssoContext = ssoContext;
            this.config = Collections.unmodifiableMap(new HashMap<String, Object>(config));
            this.details = details != null ? Collections.unmodifiableMap(new HashMap<String, Object>(details)) : Collections.emptyMap();
        }

        public AuthMethod(DocNode docNode) throws ConfigValidationException {
            this.method = docNode.getAsString("method");
            this.id = docNode.getAsString("id");
            this.session = docNode.getBoolean("session") != null ? docNode.getBoolean("session") : false;
            this.label = docNode.getAsString("label");
            this.messageTitle = docNode.getAsString("message_title");
            this.message = docNode.getAsString("message_body");
            this.unavailable = docNode.getBoolean("unavailable") != null ? docNode.getBoolean("unavailable") : false;
            this.captureUrlFragment = docNode.getBoolean("capture_url_fragment") != null ? docNode.getBoolean("capture_url_fragment") : false;
            this.autoSelect = docNode.getBoolean("auto_select") != null ? docNode.getBoolean("auto_select") : false;
            this.ssoLocation = docNode.getAsString("sso_location");
            this.ssoContext = docNode.getAsString("sso_context");
            this.config = docNode.hasNonNull("config") ? docNode.getAsNode("config").toMap() : null;
            this.details = docNode.hasNonNull("details") ? docNode.getAsNode("details").toMap() : null;
        }

        public AuthMethod unavailable(String messageTitle, String message) {
            return new AuthMethod(this.method, this.label, this.id, this.session, true, this.captureUrlFragment, this.autoSelect, messageTitle, message, this.ssoLocation, this.ssoContext, this.config);
        }

        public AuthMethod unavailable(String messageTitle, String message, Map<String, Object> details) {
            return new AuthMethod(this.method, this.label, this.id, this.session, true, this.captureUrlFragment, this.autoSelect, messageTitle, message, this.ssoLocation, this.ssoContext, this.config, details);
        }

        public AuthMethod ssoLocation(String ssoLocation) {
            return new AuthMethod(this.method, this.label, this.id, this.session, this.unavailable, this.captureUrlFragment, this.autoSelect, this.messageTitle, this.message, ssoLocation, this.ssoContext, this.config);
        }

        public AuthMethod ssoContext(String ssoContext) {
            return new AuthMethod(this.method, this.label, this.id, this.session, this.unavailable, this.captureUrlFragment, this.autoSelect, this.messageTitle, this.message, this.ssoLocation, ssoContext, this.config);
        }

        public AuthMethod config(Map<String, Object> config) {
            return new AuthMethod(this.method, this.label, this.id, this.session, this.unavailable, this.captureUrlFragment, this.autoSelect, this.messageTitle, this.message, this.ssoLocation, this.ssoContext, config);
        }

        public AuthMethod config(String key, Object value) {
            HashMap<String, Object> newConfig = new HashMap<String, Object>(this.config);
            newConfig.put(key, value);
            return new AuthMethod(this.method, this.label, this.id, this.session, this.unavailable, this.captureUrlFragment, this.autoSelect, this.messageTitle, this.message, this.ssoLocation, this.ssoContext, newConfig);
        }

        public String getMethod() {
            return this.method;
        }

        public boolean isSession() {
            return this.session;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSsoLocation() {
            return this.ssoLocation;
        }

        public String getSsoContext() {
            return this.ssoContext;
        }

        public AuthMethod clone() {
            return new AuthMethod(this.method, this.label, this.id, this.session, this.unavailable, this.captureUrlFragment, this.autoSelect, this.messageTitle, this.message, this.ssoLocation, this.ssoContext, this.config, this.details);
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public String getId() {
            return this.id;
        }

        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("method", this.method);
            if (this.id != null) {
                result.put("id", this.id);
            }
            result.put("session", this.session);
            result.put("label", this.label);
            if (this.unavailable) {
                result.put("unavailable", this.unavailable);
            }
            if (this.captureUrlFragment) {
                result.put("capture_url_fragment", this.captureUrlFragment);
            }
            if (this.autoSelect) {
                result.put("auto_select", this.autoSelect);
            }
            if (this.messageTitle != null) {
                result.put("message_title", this.messageTitle);
            }
            if (this.message != null) {
                result.put("message_body", this.message);
            }
            if (this.ssoLocation != null) {
                result.put("sso_location", this.ssoLocation);
            }
            if (this.ssoContext != null) {
                result.put("sso_context", this.ssoContext);
            }
            if (this.config.size() > 0) {
                result.put("config", this.config);
            }
            if (this.details.size() > 0) {
                result.put("details", this.details);
            }
            return result;
        }

        public String toString() {
            return this.toJsonString();
        }
    }
}

