/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authc.session.backend.SessionPrivileges;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SessionToken
implements ToXContentObject,
Writeable,
Serializable {
    private static final long serialVersionUID = -968321214418424644L;
    public static final String EXPIRES_AT = "expires_at";
    public static final String DYNAMIC_EXPIRES_AT = "dynamic_expires_at";
    public static final Map<String, Object> INDEX_MAPPING = ImmutableMap.of((Object)"dynamic", (Object)true, (Object)"properties", (Object)ImmutableMap.of((Object)"created_at", (Object)ImmutableMap.of((Object)"type", (Object)"date"), (Object)"expires_at", (Object)ImmutableMap.of((Object)"type", (Object)"date"), (Object)"dynamic_expires_at", (Object)ImmutableMap.of((Object)"type", (Object)"date")));
    private final String userName;
    private final String tokenName;
    private final String id;
    private final Instant creationTime;
    private final Instant expiryTime;
    private final Instant revokedAt;
    private final Instant dynamicExpiryTime;
    private final SessionPrivileges base;

    SessionToken(String id, String userName, SessionPrivileges base, Instant creationTime, Instant expiryTime, Instant dynamicExpiryTime, Instant revokedAt) {
        this.id = id;
        this.userName = userName;
        this.tokenName = null;
        this.base = base;
        this.creationTime = creationTime;
        this.expiryTime = expiryTime;
        this.dynamicExpiryTime = dynamicExpiryTime;
        this.revokedAt = revokedAt;
    }

    public SessionToken(StreamInput in) throws IOException {
        this.id = in.readString();
        this.userName = in.readString();
        this.tokenName = in.readOptionalString();
        this.creationTime = in.readInstant();
        this.expiryTime = in.readOptionalInstant();
        this.dynamicExpiryTime = in.readOptionalInstant();
        this.revokedAt = in.readOptionalInstant();
        this.base = new SessionPrivileges(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("user_name", this.userName);
        builder.field("token_name", this.tokenName);
        builder.field("base");
        this.base.toXContent(builder, params);
        builder.field("created_at", this.creationTime.toEpochMilli());
        if (this.expiryTime != null) {
            builder.field(EXPIRES_AT, this.expiryTime.toEpochMilli());
        }
        if (this.dynamicExpiryTime != null) {
            builder.field(DYNAMIC_EXPIRES_AT, this.dynamicExpiryTime.toEpochMilli());
        }
        if (this.revokedAt != null) {
            builder.field("revoked_at", this.revokedAt.toEpochMilli());
        }
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public SessionPrivileges getBase() {
        return this.base;
    }

    public boolean isRevoked() {
        return this.revokedAt != null;
    }

    SessionToken getRevokedInstance() {
        SessionToken revoked = new SessionToken(this.id, this.userName, this.base, this.creationTime, this.expiryTime, this.dynamicExpiryTime, Instant.now());
        return revoked;
    }

    public static SessionToken parse(String id, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        String userName = vJsonNode.get("user_name").required().asString();
        SessionPrivileges base = null;
        if (vJsonNode.hasNonNull("base")) {
            try {
                base = SessionPrivileges.parse(jsonNode.getAsNode("base"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("base", e);
            }
        } else {
            validationErrors.add((ValidationError)new MissingAttribute("base", (Object)jsonNode));
        }
        Instant createdAt = vJsonNode.get("created_at").asInstantFromEpochMilli();
        Instant expiry = vJsonNode.get(EXPIRES_AT).asInstantFromEpochMilli();
        Instant dynamicExpiry = vJsonNode.get(DYNAMIC_EXPIRES_AT).asInstantFromEpochMilli();
        Instant revokedAt = vJsonNode.get("revoked_at").asInstantFromEpochMilli();
        validationErrors.throwExceptionForPresentErrors();
        return new SessionToken(id, userName, base, createdAt, expiry, dynamicExpiry, revokedAt);
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.userName);
        out.writeOptionalString(this.tokenName);
        out.writeInstant(this.creationTime);
        out.writeOptionalInstant(this.expiryTime);
        out.writeOptionalInstant(this.dynamicExpiryTime);
        out.writeOptionalInstant(this.revokedAt);
        this.base.writeTo(out);
    }

    public Instant getRevokedAt() {
        return this.revokedAt;
    }

    public String toString() {
        return "AuthToken [userName=" + this.userName + ", tokenName=" + this.tokenName + ", id=" + this.id + ", creationTime=" + String.valueOf(this.creationTime) + ", expiryTime=" + String.valueOf(this.expiryTime) + ", revokedAt=" + String.valueOf(this.revokedAt) + ", base=" + String.valueOf(this.base) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (this.expiryTime == null ? 0 : this.expiryTime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionToken other = (SessionToken)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.expiryTime == null ? other.expiryTime != null : !this.expiryTime.equals(other.expiryTime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.tokenName == null ? other.tokenName != null : !this.tokenName.equals(other.tokenName)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public Instant getDynamicExpiryTime() {
        return this.dynamicExpiryTime;
    }
}

