/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap2.LDAPUserSearcher;
import com.floragunn.dlic.auth.ldap2.ParametrizedFilter;
import com.floragunn.dlic.util.RestrictingSSLSocketFactory;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.AggregateLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.FastestConnectServerSet;
import com.unboundid.ldap.sdk.FewestConnectionsServerSet;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.PruneUnneededConnectionsLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public final class LDAPConnectionManager
implements Closeable {
    private static final Logger log = LogManager.getLogger(LDAPConnectionManager.class);
    private final LDAPConnectionPool pool;
    private final SettingsBasedSSLConfigurator.SSLConfig sslConfig;
    private final LDAPUserSearcher userSearcher;
    private final Settings settings;

    public LDAPConnectionManager(Settings settings, Path configPath) throws LDAPException, SettingsBasedSSLConfigurator.SSLConfigException {
        boolean createIfNecessary;
        long maxWaitTimeMillis;
        this.sslConfig = new SettingsBasedSSLConfigurator(settings, configPath, "").buildSSLConfig();
        this.settings = settings;
        List ldapStrings = this.settings.getAsList("hosts", Collections.singletonList("localhost"));
        String bindDn = settings.get("bind_dn", null);
        String password = settings.get("password", null);
        if (password != null && password.length() == 0) {
            password = null;
        }
        Object bindRequest = bindDn != null && password != null && password.length() > 0 ? new SimpleBindRequest(bindDn, password) : (this.sslConfig != null && this.sslConfig.isClientCertAuthenticationEnabled() ? new EXTERNALBindRequest() : new SimpleBindRequest());
        LDAPConnectionOptions opts = new LDAPConnectionOptions();
        if (this.sslConfig != null && this.sslConfig.isHostnameVerificationEnabled()) {
            opts.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(false));
        }
        int connectTimeout = settings.getAsInt("connect_timeout", Integer.valueOf(opts.getConnectTimeoutMillis()));
        long responseTimeout = settings.getAsLong("response_timeout", Long.valueOf(opts.getResponseTimeoutMillis()));
        opts.setConnectTimeoutMillis(connectTimeout);
        opts.setResponseTimeoutMillis(responseTimeout);
        opts.setFollowReferrals(true);
        int poolMinSize = this.settings.getAsInt("pool.min_size", Integer.valueOf(3));
        int poolMaxSize = this.settings.getAsInt("pool.max_size", Integer.valueOf(10));
        if (this.settings.getAsBoolean("pool.enabled", Boolean.valueOf(false)).booleanValue()) {
            log.warn("LDAP connection pool can no longer be disabled");
        }
        if ("blocking".equals(this.settings.get("pool.type"))) {
            maxWaitTimeMillis = Long.MAX_VALUE;
            createIfNecessary = false;
        } else {
            maxWaitTimeMillis = 0L;
            createIfNecessary = true;
        }
        try {
            this.pool = AccessController.doPrivileged(() -> this.lambda$new$0(ldapStrings, opts, (BindRequest)bindRequest, poolMinSize, poolMaxSize));
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof LDAPException) {
                throw (LDAPException)((Object)e.getException());
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
        this.pool.setCreateIfNecessary(createIfNecessary);
        this.pool.setMaxWaitTimeMillis(maxWaitTimeMillis);
        this.configureHealthChecks(poolMaxSize);
        this.userSearcher = new LDAPUserSearcher(this, settings);
    }

    private void configureHealthChecks(int poolMaxSize) {
        if (this.settings.getAsBoolean("pool.health_check.enabled", Boolean.valueOf(false)).booleanValue()) {
            ArrayList<Object> healthChecks = new ArrayList<Object>();
            if (this.settings.getAsBoolean("pool.health_check.validation.enabled", Boolean.valueOf(true)).booleanValue()) {
                String entryDN = this.settings.get("pool.health_check.validation.dn", null);
                long maxResponseTime = this.settings.getAsLong("pool.health_check.validation.max_response_time", Long.valueOf(0L));
                boolean invokeOnCreate = this.settings.getAsBoolean("pool.health_check.validation.on_create", Boolean.valueOf(false));
                boolean invokeAfterAuthentication = this.settings.getAsBoolean("pool.health_check.validation.after_authentication", Boolean.valueOf(false));
                boolean invokeOnCheckout = this.settings.getAsBoolean("pool.health_check.validation.on_checkout", Boolean.valueOf(false));
                boolean invokeOnRelease = this.settings.getAsBoolean("pool.health_check.validation.on_release", Boolean.valueOf(false));
                boolean invokeForBackgroundChecks = this.settings.getAsBoolean("pool.health_check.validation.for_background_checks", Boolean.valueOf(true));
                boolean invokeOnException = this.settings.getAsBoolean("pool.health_check.validation.on_exception", Boolean.valueOf(false));
                GetEntryLDAPConnectionPoolHealthCheck gehc = new GetEntryLDAPConnectionPoolHealthCheck(entryDN, maxResponseTime, invokeOnCreate, invokeAfterAuthentication, invokeOnCheckout, invokeOnRelease, invokeForBackgroundChecks, invokeOnException);
                healthChecks.add(gehc);
            }
            if (this.settings.getAsBoolean("pool.health_check.pruning.enabled", Boolean.valueOf(false)).booleanValue()) {
                int minAvailableConnections = this.settings.getAsInt("pool.health_check.pruning.min_available_connections", Integer.valueOf(poolMaxSize));
                long minDurationMillisExceedingMinAvailableConnections = this.settings.getAsLong("pool.health_check.pruning.min_duration_millis_exceeding_min_available_connections", Long.valueOf(0L));
                PruneUnneededConnectionsLDAPConnectionPoolHealthCheck puchc = new PruneUnneededConnectionsLDAPConnectionPoolHealthCheck(minAvailableConnections, minDurationMillisExceedingMinAvailableConnections);
                healthChecks.add(puchc);
            }
            if (healthChecks.size() == 1) {
                this.pool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthChecks.get(0));
            } else if (healthChecks.size() > 1) {
                AggregateLDAPConnectionPoolHealthCheck aghc = new AggregateLDAPConnectionPoolHealthCheck(healthChecks);
                this.pool.setHealthCheck((LDAPConnectionPoolHealthCheck)aghc);
            }
            this.pool.setHealthCheckIntervalMillis(this.settings.getAsLong("pool.health_check.interval_millis", Long.valueOf(this.pool.getHealthCheckIntervalMillis())).longValue());
        }
    }

    private ServerSet createServerSet(Collection<String> ldapStrings, LDAPConnectionOptions opts) throws LDAPException {
        RestrictingSSLSocketFactory sf;
        ArrayList<String> ldapHosts = new ArrayList<String>();
        ArrayList<Integer> ldapPorts = new ArrayList<Integer>();
        if (ldapStrings == null || ldapStrings.isEmpty()) {
            ldapHosts.add("localhost");
            ldapPorts.add(this.sslConfig != null ? 636 : 389);
        } else {
            for (String ldapString : ldapStrings) {
                String[] split;
                int port;
                if (ldapString == null || (ldapString = ldapString.trim()).isEmpty()) continue;
                int n = port = this.sslConfig != null ? 636 : 389;
                if (ldapString.startsWith("ldap://")) {
                    ldapString = ldapString.replace("ldap://", "");
                }
                if (ldapString.startsWith("ldaps://")) {
                    ldapString = ldapString.replace("ldaps://", "");
                    port = 636;
                }
                if ((split = ldapString.split(":")).length > 1) {
                    port = Integer.parseInt(split[1]);
                }
                ldapHosts.add(split[0]);
                ldapPorts.add(port);
            }
        }
        if (this.sslConfig != null && !this.sslConfig.isStartTlsEnabled()) {
            sf = this.sslConfig.getRestrictedSSLSocketFactory();
            return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), sf, opts, null, null);
        }
        if (this.sslConfig != null && this.sslConfig.isStartTlsEnabled()) {
            sf = this.sslConfig.getRestrictedSSLSocketFactory();
            return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), null, opts, null, (PostConnectProcessor)new StartTLSPostConnectProcessor((SSLSocketFactory)sf));
        }
        return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), null, opts, null, null);
    }

    private ServerSet newServerSetImpl(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) throws LDAPException {
        String impl = this.settings.get("connection_strategy", "roundrobin").toLowerCase();
        if ("fewest".equals(impl)) {
            return new FewestConnectionsServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor);
        }
        if ("failover".equals(impl)) {
            return new FailoverServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor);
        }
        if ("fastest".equals(impl)) {
            return new FastestConnectServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor);
        }
        if ("roundrobin".equals(impl)) {
            return new RoundRobinServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor);
        }
        throw new LDAPException(ResultCode.NOT_SUPPORTED, "connection_strategy: " + impl + " not supported");
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.pool.getConnection();
    }

    public void checkDnPassword(String dn, String password) throws LDAPException {
        this.pool.bindAndRevertAuthentication((BindRequest)new SimpleBindRequest(dn, password));
    }

    public void checkDnPassword(String dn, byte[] password) throws LDAPException {
        this.pool.bindAndRevertAuthentication((BindRequest)new SimpleBindRequest(dn, password));
    }

    public List<SearchResultEntry> search(LDAPConnection con, String baseDN, SearchScope scope, ParametrizedFilter filter) throws LDAPException {
        SearchRequest sr = new SearchRequest(baseDN, scope, filter.toString(), new String[]{"+", "*"});
        sr.setDerefPolicy(DereferencePolicy.ALWAYS);
        SearchResult searchResult = con.search(sr);
        return searchResult.getSearchEntries();
    }

    public SearchResultEntry lookup(LDAPConnection con, String dn) throws LDAPException {
        return con.getEntry(dn, new String[]{"+", "*"});
    }

    public SearchResultEntry exists(LDAPConnection con, String name) throws LDAPException {
        return this.userSearcher.exists(con, name);
    }

    @Override
    public void close() throws IOException {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    private /* synthetic */ LDAPConnectionPool lambda$new$0(List ldapStrings, LDAPConnectionOptions opts, BindRequest bindRequest, int poolMinSize, int poolMaxSize) throws Exception {
        return new LDAPConnectionPool(this.createServerSet(ldapStrings, opts), bindRequest, poolMinSize, poolMaxSize, null, false);
    }
}

