/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.rest;

import com.floragunn.fluent.collections.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class AttributedHttpRequest
implements HttpRequest {
    private final HttpRequest httpRequest;
    private ImmutableMap<String, Object> attributes;

    private AttributedHttpRequest(HttpRequest httpRequest, ImmutableMap<String, Object> attributes) {
        this.httpRequest = Objects.requireNonNull(httpRequest, "Http request is required.");
        this.attributes = Objects.requireNonNull(attributes, "Request attributes are required");
    }

    public static AttributedHttpRequest create(HttpRequest httpRequest, ImmutableMap<String, Object> attributes) {
        Objects.requireNonNull(httpRequest, "Http request is required.");
        Objects.requireNonNull(attributes, "Request attributes are required");
        if (httpRequest instanceof AttributedHttpRequest) {
            AttributedHttpRequest request = (AttributedHttpRequest)httpRequest;
            ImmutableMap commonAttributes = request.attributes.with(attributes);
            return request.withAttributes((ImmutableMap<String, Object>)commonAttributes);
        }
        return new AttributedHttpRequest(httpRequest, attributes);
    }

    private AttributedHttpRequest withAttributes(ImmutableMap<String, Object> commonAttributes) {
        return new AttributedHttpRequest(this.httpRequest, commonAttributes);
    }

    public Optional<Object> getAttribute(String name) {
        Objects.requireNonNull(name, "Attribute name is required.");
        return Optional.ofNullable(this.attributes.get((Object)name));
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public HttpBody body() {
        return this.httpRequest.body();
    }

    public List<String> strictCookies() {
        return this.httpRequest.strictCookies();
    }

    public HttpRequest removeHeader(String header) {
        return this.httpRequest.removeHeader(header);
    }

    public void release() {
        this.httpRequest.release();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        return this.httpRequest.protocolVersion();
    }

    public RestRequest.Method method() {
        return this.httpRequest.method();
    }

    public Exception getInboundException() {
        return this.httpRequest.getInboundException();
    }

    public Map<String, List<String>> getHeaders() {
        return this.httpRequest.getHeaders();
    }

    public HttpResponse createResponse(RestStatus status, BytesReference content) {
        return this.httpRequest.createResponse(status, content);
    }

    public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart content) {
        return this.httpRequest.createResponse(status, content);
    }
}

