/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.impl;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.patch.JsonPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditMessage;
import com.floragunn.searchguard.enterprise.auditlog.impl.RequestResolver;
import com.floragunn.searchguard.enterprise.auditlog.impl.Utils;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchguard.user.UserInformation;
import com.floragunn.searchsupport.PrivilegedCode;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public abstract class AbstractAuditLog
implements AuditLog {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final ThreadPool threadPool;
    protected final IndexNameExpressionResolver resolver;
    protected volatile ClusterState clusterState = null;
    protected final Settings settings;
    protected final boolean restAuditingEnabled;
    protected final boolean transportAuditingEnabled;
    protected final boolean resolveBulkRequests;
    protected final boolean logRequestBody;
    protected final boolean resolveIndices;
    private Pattern ignoredAuditUsers;
    private Pattern ignoredComplianceUsersForRead;
    private Pattern ignoredComplianceUsersForWrite;
    private Pattern ignoreAuditRequests;
    private final List<String> disabledRestCategories;
    private final List<String> disabledTransportCategories;
    private final List<String> defaultDisabledCategories = Arrays.asList(AuditMessage.Category.AUTHENTICATED.toString(), AuditMessage.Category.GRANTED_PRIVILEGES.toString());
    private final List<String> defaultIgnoredUsers = Collections.singletonList("kibanaserver");
    private final boolean excludeSensitiveHeaders;
    private final boolean logEnvVars;
    private AuditLogConfig complianceConfig;
    private final Pattern searchguardIndexPattern;
    protected final ConfigurationRepository configurationRepository;
    private static final List<String> writeClasses = new ArrayList<String>();

    protected AbstractAuditLog(Settings settings, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, ConfigurationRepository configurationRepository) {
        writeClasses.add(IndexRequest.class.getSimpleName());
        writeClasses.add(UpdateRequest.class.getSimpleName());
        writeClasses.add(BulkRequest.class.getSimpleName());
        writeClasses.add(BulkShardRequest.class.getSimpleName());
        writeClasses.add(DeleteRequest.class.getSimpleName());
        ValidationErrors validationErrors = new ValidationErrors();
        this.threadPool = threadPool;
        this.settings = settings;
        this.resolver = resolver;
        if (clusterService != null) {
            clusterService.addListener(new ClusterStateListener(){

                public void clusterChanged(ClusterChangedEvent event) {
                    AbstractAuditLog.this.clusterState = event.state();
                }
            });
        }
        this.configurationRepository = configurationRepository;
        this.searchguardIndexPattern = configurationRepository != null ? configurationRepository.getConfiguredSearchguardIndices() : Pattern.blank();
        this.resolveBulkRequests = settings.getAsBoolean("searchguard.audit.resolve_bulk_requests", Boolean.valueOf(false));
        this.restAuditingEnabled = settings.getAsBoolean("searchguard.audit.enable_rest", Boolean.valueOf(true));
        this.transportAuditingEnabled = settings.getAsBoolean("searchguard.audit.enable_transport", Boolean.valueOf(true));
        this.logEnvVars = settings.getAsBoolean("searchguard.compliance.history.external_config.env_vars.enabled", Boolean.valueOf(true));
        this.disabledRestCategories = new ArrayList<String>(settings.getAsList("searchguard.audit.config.disabled_rest_categories", this.defaultDisabledCategories).stream().map(c -> c.toUpperCase()).collect(Collectors.toList()));
        if (this.disabledRestCategories.size() == 1 && "NONE".equals(this.disabledRestCategories.get(0))) {
            this.disabledRestCategories.clear();
        }
        if (this.disabledRestCategories.size() > 0) {
            this.log.info("Configured categories on rest layer to ignore: {}", this.disabledRestCategories);
        }
        this.disabledTransportCategories = new ArrayList<String>(settings.getAsList("searchguard.audit.config.disabled_transport_categories", this.defaultDisabledCategories).stream().map(c -> c.toUpperCase()).collect(Collectors.toList()));
        if (this.disabledTransportCategories.size() == 1 && "NONE".equals(this.disabledTransportCategories.get(0))) {
            this.disabledTransportCategories.clear();
        }
        if (this.disabledTransportCategories.size() > 0) {
            this.log.info("Configured categories on transport layer to ignore: {}", this.disabledTransportCategories);
        }
        this.logRequestBody = settings.getAsBoolean("searchguard.audit.log_request_body", Boolean.valueOf(true));
        this.resolveIndices = settings.getAsBoolean("searchguard.audit.resolve_indices", Boolean.valueOf(true));
        ArrayList ignoredAuditUsers = new ArrayList(settings.getAsList("searchguard.audit.ignore_users", this.defaultIgnoredUsers));
        if (ignoredAuditUsers.size() == 0 || ignoredAuditUsers.size() == 1 && "NONE".equals(ignoredAuditUsers.get(0))) {
            this.ignoredAuditUsers = Pattern.blank();
        } else {
            this.log.info("Configured Users to ignore: {}", ignoredAuditUsers);
            try {
                this.ignoredAuditUsers = Pattern.create(ignoredAuditUsers);
            }
            catch (ConfigValidationException e) {
                validationErrors.add("searchguard.audit.ignore_users", e);
                this.ignoredAuditUsers = Pattern.blank();
            }
        }
        ArrayList ignoredComplianceUsersForRead = new ArrayList(settings.getAsList("searchguard.compliance.history.read.ignore_users", this.defaultIgnoredUsers));
        if (ignoredComplianceUsersForRead.size() == 0 || ignoredComplianceUsersForRead.size() == 1 && "NONE".equals(ignoredComplianceUsersForRead.get(0))) {
            this.ignoredComplianceUsersForRead = Pattern.blank();
        } else {
            this.log.info("Configured Users to ignore for read compliance events: {}", ignoredComplianceUsersForRead);
            try {
                this.ignoredComplianceUsersForRead = Pattern.create(ignoredComplianceUsersForRead);
            }
            catch (ConfigValidationException e) {
                validationErrors.add("searchguard.compliance.history.read.ignore_users", e);
                this.ignoredComplianceUsersForRead = Pattern.blank();
            }
        }
        ArrayList ignoredComplianceUsersForWrite = new ArrayList(settings.getAsList("searchguard.compliance.history.write.ignore_users", this.defaultIgnoredUsers));
        if (ignoredComplianceUsersForRead.size() == 0 || ignoredComplianceUsersForWrite.size() == 1 && "NONE".equals(ignoredComplianceUsersForWrite.get(0))) {
            this.ignoredComplianceUsersForWrite = Pattern.blank();
        } else {
            this.log.info("Configured Users to ignore for write compliance events: {}", ignoredComplianceUsersForWrite);
            try {
                this.ignoredComplianceUsersForWrite = Pattern.create(ignoredComplianceUsersForWrite);
            }
            catch (ConfigValidationException e) {
                validationErrors.add("searchguard.compliance.history.write.ignore_users", e);
                this.ignoredComplianceUsersForWrite = Pattern.blank();
            }
        }
        List ignoreAuditRequests = settings.getAsList("searchguard.audit.ignore_requests", Collections.emptyList());
        try {
            this.ignoreAuditRequests = Pattern.create((List)ignoreAuditRequests);
        }
        catch (ConfigValidationException e) {
            validationErrors.add("searchguard.audit.ignore_requests", e);
            this.ignoreAuditRequests = Pattern.blank();
        }
        for (String event : this.disabledRestCategories) {
            try {
                AuditMessage.Category.valueOf(event.toUpperCase());
            }
            catch (Exception iae) {
                this.log.error("Unknown category {}, please check searchguard.audit.config.disabled_categories settings", (Object)event);
            }
        }
        for (String event : this.disabledTransportCategories) {
            try {
                AuditMessage.Category.valueOf(event.toUpperCase());
            }
            catch (Exception iae) {
                this.log.error("Unknown category {}, please check searchguard.audit.config.disabled_categories settings", (Object)event);
            }
        }
        this.excludeSensitiveHeaders = settings.getAsBoolean("searchguard.audit.exclude_sensitive_headers", Boolean.valueOf(true));
        if (validationErrors.size() != 0) {
            this.log.error("The audit log configuration contains errors:\n" + String.valueOf(validationErrors));
        }
    }

    public void setComplianceConfig(AuditLogConfig complianceConfig) {
        this.complianceConfig = complianceConfig;
    }

    public void logFailedLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditMessage.Category.FAILED_LOGIN, action, effectiveUser, request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.FAILED_LOGIN, this.getOrigin(), action, null, effectiveUser, sgadmin, initiatingUser, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logFailedLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditMessage.Category.FAILED_LOGIN, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.FAILED_LOGIN, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(sgadmin);
        this.save(msg);
    }

    public void logBlockedUser(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditMessage.Category.BLOCKED_USER, action, effectiveUser, request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.BLOCKED_USER, this.getOrigin(), action, null, effectiveUser, sgadmin, initiatingUser, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logBlockedUser(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditMessage.Category.BLOCKED_USER, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.BLOCKED_USER, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(sgadmin);
        this.save(msg);
    }

    public void logSucceededLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.AUTHENTICATED, action, effectiveUser, request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.AUTHENTICATED, this.getOrigin(), action, null, effectiveUser, sgadmin, initiatingUser, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logSucceededLogin(UserInformation effectiveUser, boolean sgadmin, UserInformation initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditMessage.Category.AUTHENTICATED, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.AUTHENTICATED, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            if (request.isFullContent()) {
                msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
            } else {
                msg.addMissingRequestBodyMessage("Streamable request body cannot be logged");
            }
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(sgadmin);
        this.save(msg);
    }

    public void logMissingPrivileges(String privilege, UserInformation effectiveUser, RestRequest request) {
        if (!this.checkRestFilter(AuditMessage.Category.MISSING_PRIVILEGES, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.MISSING_PRIVILEGES, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditMessage.Category.MISSING_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.MISSING_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditMessage.Category.GRANTED_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.GRANTED_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.BAD_HEADERS, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.BAD_HEADERS, this.getOrigin(), action, null, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logBadHeaders(RestRequest request) {
        if (!this.checkRestFilter(AuditMessage.Category.BAD_HEADERS, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.BAD_HEADERS, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    public void logBlockedIp(TransportRequest request, String action, TransportAddress remoteAddress, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.BLOCKED_IP, action, this.getUser(), request)) {
            return;
        }
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.BLOCKED_IP, this.getOrigin(), action, null, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logBlockedIp(RestRequest request, InetSocketAddress remoteAddress) {
        if (!this.checkRestFilter(AuditMessage.Category.BLOCKED_IP, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.BLOCKED_IP, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        msg.addRemoteAddress(remoteAddress.getAddress().getHostAddress());
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    public void logSgIndexAttempt(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.SG_INDEX_ATTEMPT, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.SG_INDEX_ATTEMPT, this.getOrigin(), action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logImmutableIndexAttempt(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.COMPLIANCE_IMMUTABLE_INDEX_ATTEMPT, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.COMPLIANCE_IMMUTABLE_INDEX_ATTEMPT, this.getOrigin(), action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (!this.checkTransportFilter(AuditMessage.Category.SSL_EXCEPTION, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditMessage.Category.SSL_EXCEPTION, AuditLog.Origin.TRANSPORT, action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterState, this.settings, this.logRequestBody, this.resolveIndices, this.resolveBulkRequests, this.searchguardIndexPattern, this.excludeSensitiveHeaders, t);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    public void logSSLException(RestRequest request, Throwable t) {
        if (!this.checkRestFilter(AuditMessage.Category.SSL_EXCEPTION, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.SSL_EXCEPTION, this.clusterState, AuditLog.Origin.REST, AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        if (request != null && this.logRequestBody && request.hasContentOrSourceParam()) {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)request.contentOrSourceParam());
        }
        if (request != null) {
            msg.addPath(request.path());
            msg.addRestHeaders(request.getHeaders(), this.excludeSensitiveHeaders);
            msg.addRestParams(request.params());
        }
        msg.addException(t);
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        UserInformation effectiveUser;
        if (this.complianceConfig == null || !this.complianceConfig.readHistoryEnabledForIndex(index)) {
            return;
        }
        String initiatingRequestClass = this.threadPool.getThreadContext().getHeader("_sg_initial_action_class_header");
        if (initiatingRequestClass != null && writeClasses.contains(initiatingRequestClass)) {
            return;
        }
        AuditMessage.Category category = this.searchguardIndexPattern.matches(index) ? AuditMessage.Category.COMPLIANCE_INTERNAL_CONFIG_READ : AuditMessage.Category.COMPLIANCE_DOC_READ;
        if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin())) {
            return;
        }
        if (fieldNameValues != null && !fieldNameValues.isEmpty()) {
            AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), null);
            TransportAddress remoteAddress = this.getRemoteAddress();
            msg.addRemoteAddress(remoteAddress);
            msg.addEffectiveUser(effectiveUser);
            msg.addIndices(new String[]{index});
            msg.addResolvedIndices(new String[]{index});
            msg.addShardId(shardId);
            msg.addId(id);
            try {
                if (this.complianceConfig.logReadMetadataOnly()) {
                    try {
                        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
                        builder.startObject();
                        builder.field("field_names", fieldNameValues.keySet());
                        builder.endObject();
                        builder.close();
                        msg.addUnescapedJsonToRequestBody(Strings.toString((XContentBuilder)builder));
                    }
                    catch (IOException e2) {
                        this.log.error(e2.toString(), (Throwable)e2);
                    }
                } else if (this.searchguardIndexPattern.matches(index) && !"tattr".equals(id) && !"*".equals(id)) {
                    try {
                        Map<String, String> map = fieldNameValues.entrySet().stream().filter(e -> ((String)e.getKey()).equals(id)).collect(Collectors.toMap(entry -> "id", entry -> AbstractAuditLog.decodeBase64IfNecessary((String)entry.getValue())));
                        msg.addMapToRequestBody(Utils.convertJsonToxToStructuredMap(map.get("id")));
                    }
                    catch (Exception e3) {
                        this.log.error("Unexpected Exception {}", (Object)e3, (Object)e3);
                    }
                } else {
                    msg.addMapToRequestBody(new HashMap<String, Object>(fieldNameValues));
                }
            }
            catch (Exception e4) {
                this.log.error("Unable to generate request body for {} and {}", (Object)msg.toPrettyString(), fieldNameValues, (Object)e4);
            }
            this.save(msg);
        }
    }

    private static String decodeBase64IfNecessary(String base64EncodedOrPlainJson) {
        if (base64EncodedOrPlainJson == null || base64EncodedOrPlainJson.isEmpty()) {
            return base64EncodedOrPlainJson;
        }
        if (base64EncodedOrPlainJson.stripLeading().startsWith("{")) {
            return base64EncodedOrPlainJson;
        }
        try {
            return new String(BaseEncoding.base64().decode((CharSequence)base64EncodedOrPlainJson), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return base64EncodedOrPlainJson;
        }
    }

    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        UserInformation effectiveUser;
        if (this.complianceConfig == null || !this.complianceConfig.writeHistoryEnabledForIndex(shardId.getIndexName())) {
            return;
        }
        AuditMessage.Category category = this.searchguardIndexPattern.matches(shardId.getIndexName()) ? AuditMessage.Category.COMPLIANCE_INTERNAL_CONFIG_WRITE : AuditMessage.Category.COMPLIANCE_DOC_WRITE;
        if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin())) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), null);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{shardId.getIndexName()});
        msg.addResolvedIndices(new String[]{shardId.getIndexName()});
        msg.addId(currentIndex.id());
        msg.addShardId(shardId);
        msg.addComplianceDocVersion(result.getVersion());
        msg.addComplianceOperation(result.isCreated() ? AuditLog.Operation.CREATE : AuditLog.Operation.UPDATE);
        if (this.complianceConfig.logDiffsForWrite() && originalResult != null && originalResult.isExists() && originalResult.internalSourceRef() != null) {
            try {
                DocNode currentDocument;
                DocNode originalDocument;
                JsonPatch diff;
                String originalSource = null;
                String currentSource = null;
                if (this.searchguardIndexPattern.matches(shardId.getIndexName())) {
                    Object base64;
                    XContentParser parser;
                    try {
                        parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)originalResult.internalSourceRef(), (XContentType)XContentType.JSON);
                        try {
                            base64 = parser.map().values().iterator().next();
                            originalSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64))) : XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (XContentType)XContentType.JSON);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                    try {
                        parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (XContentType)XContentType.JSON);
                        try {
                            base64 = parser.map().values().iterator().next();
                            currentSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64))) : XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (XContentType)XContentType.JSON);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                } else {
                    originalSource = XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (XContentType)XContentType.JSON);
                    currentSource = XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (XContentType)XContentType.JSON);
                }
                msg.addComplianceWriteDiffSource((diff = JsonPatch.fromDiff((DocNode)(originalDocument = DocNode.parse((Format)Format.JSON).from(originalSource)), (DocNode)(currentDocument = DocNode.parse((Format)Format.JSON).from(currentSource)))).isEmpty() ? "" : diff.toJsonString());
            }
            catch (Exception e) {
                this.log.error("Unable to generate diff for {}", (Object)msg.toPrettyString(), (Object)e);
            }
        }
        if (!this.complianceConfig.logWriteMetadataOnly()) {
            if (this.searchguardIndexPattern.matches(shardId.getIndexName())) {
                try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (XContentType)XContentType.JSON);){
                    Object base64 = parser.map().values().iterator().next();
                    if (base64 instanceof String) {
                        msg.addUnescapedJsonToRequestBody(new String(BaseEncoding.base64().decode((CharSequence)((String)base64))));
                    } else {
                        msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()));
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            } else {
                msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()));
            }
        }
        this.save(msg);
    }

    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        UserInformation effectiveUser = this.getUser();
        if (!this.checkComplianceFilter(AuditMessage.Category.COMPLIANCE_DOC_WRITE, effectiveUser, this.getOrigin())) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditMessage.Category.COMPLIANCE_DOC_WRITE, this.clusterState, this.getOrigin(), null);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{shardId.getIndexName()});
        msg.addResolvedIndices(new String[]{shardId.getIndexName()});
        msg.addId(delete.id());
        msg.addShardId(shardId);
        msg.addComplianceDocVersion(result.getVersion());
        msg.addComplianceOperation(AuditLog.Operation.DELETE);
        this.save(msg);
    }

    public void logExternalConfig(Settings settings, Environment environment) {
        if (!this.checkComplianceFilter(AuditMessage.Category.COMPLIANCE_EXTERNAL_CONFIG, null, this.getOrigin())) {
            return;
        }
        Map<String, Object> configAsMap = Utils.convertJsonToxToStructuredMap((ToXContent)settings);
        Map envAsMap = this.logEnvVars ? (Map)PrivilegedCode.execute(() -> System.getenv()) : null;
        Properties propsAsMap = (Properties)PrivilegedCode.execute(() -> System.getProperties());
        String sha256 = DigestUtils.sha256Hex((String)(configAsMap.toString() + (envAsMap != null ? envAsMap.toString() : "") + propsAsMap.toString()));
        AuditMessage msg = new AuditMessage(AuditMessage.Category.COMPLIANCE_EXTERNAL_CONFIG, this.clusterState, null, null);
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            builder.startObject("external_configuration");
            builder.field("elasticsearch_yml", configAsMap);
            if (this.logEnvVars) {
                builder.field("os_environment", envAsMap);
            }
            builder.field("java_properties", (Object)propsAsMap);
            builder.field("sha256_checksum", sha256);
            builder.endObject();
            builder.endObject();
            builder.close();
            msg.addUnescapedJsonToRequestBody(Strings.toString((XContentBuilder)builder));
        }
        catch (Exception e) {
            this.log.error("Unable to build message", (Throwable)e);
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        for (String key : settings.keySet()) {
            String value;
            if (!key.startsWith("searchguard") || !key.contains("filepath") && !key.contains("file_path") || (value = settings.get(key)) == null || value.isEmpty()) continue;
            Path path = value.startsWith("/") ? Paths.get(value, new String[0]) : environment.configDir().resolve(value);
            paths.put(key, path);
        }
        msg.addFileInfos(paths);
        this.save(msg);
    }

    public void logIndexTemplatePutted(String templateName, ComposableIndexTemplate originalTemplate, ComposableIndexTemplate currentTemplate, String action, TransportRequest transportRequest) {
        if (currentTemplate == null) {
            this.log.error("Unable to log putted composable index template. Current index template is null.");
            return;
        }
        AuditMessage.Category category = AuditMessage.Category.INDEX_TEMPLATE_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndexTemplates(new String[]{templateName});
        msg.addComplianceIndexTemplateVersion(currentTemplate.version());
        msg.addComplianceOperation(originalTemplate == null ? AuditLog.Operation.CREATE : AuditLog.Operation.UPDATE);
        try {
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)new Tuple((Object)XContentType.JSON, (Object)XContentHelper.toXContent((ToXContent)currentTemplate, (XContentType)XContentType.JSON, (boolean)false)));
        }
        catch (Exception e) {
            this.log.error("Unable to parse current composable index template source", (Throwable)e);
        }
        this.save(msg);
    }

    public void logIndexTemplatePutted(String templateName, IndexTemplateMetadata originalTemplate, IndexTemplateMetadata currentTemplate, String action, TransportRequest transportRequest) {
        if (currentTemplate == null) {
            this.log.error("Unable to log putted legacy index template. Current index template is null.");
            return;
        }
        AuditMessage.Category category = AuditMessage.Category.INDEX_TEMPLATE_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndexTemplates(new String[]{templateName});
        msg.addComplianceIndexTemplateVersion(currentTemplate.getVersion() != null ? Long.valueOf(currentTemplate.getVersion().intValue()) : null);
        msg.addComplianceOperation(originalTemplate == null ? AuditLog.Operation.CREATE : AuditLog.Operation.UPDATE);
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            IndexTemplateMetadata.Builder.toXContent((IndexTemplateMetadata)currentTemplate, (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
            builder.endObject();
            msg.addTupleToRequestBody((Tuple<XContentType, ? extends BytesReference>)new Tuple((Object)XContentType.JSON, (Object)BytesReference.bytes((XContentBuilder)builder)));
        }
        catch (Exception e) {
            this.log.error("Unable to parse current legacy index template source", (Throwable)e);
        }
        this.save(msg);
    }

    public void logIndexTemplateDeleted(List<String> templateNames, String action, TransportRequest transportRequest) {
        AuditMessage.Category category = AuditMessage.Category.INDEX_TEMPLATE_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndexTemplates(templateNames.toArray(new String[0]));
        msg.addComplianceOperation(AuditLog.Operation.DELETE);
        this.save(msg);
    }

    public void logIndexCreated(String unresolvedIndexName, String action, TransportRequest transportRequest) {
        AuditMessage.Category category = AuditMessage.Category.INDEX_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{unresolvedIndexName});
        msg.addComplianceOperation(AuditLog.Operation.CREATE);
        try {
            msg.addUnescapedJsonToRequestBody(this.serializeRequestContent(transportRequest));
        }
        catch (Exception e) {
            this.log.error("Unable to parse current index source", (Throwable)e);
        }
        this.save(msg);
    }

    public void logIndicesDeleted(List<String> indexNames, String action, TransportRequest transportRequest) {
        AuditMessage.Category category = AuditMessage.Category.INDEX_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(indexNames.toArray(new String[0]));
        msg.addComplianceOperation(AuditLog.Operation.DELETE);
        this.save(msg);
    }

    public void logIndexSettingsUpdated(List<String> indexNames, String action, TransportRequest transportRequest) {
        AuditMessage.Category category = AuditMessage.Category.INDEX_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(indexNames.toArray(new String[0]));
        msg.addComplianceOperation(AuditLog.Operation.UPDATE);
        try {
            msg.addUnescapedJsonToRequestBody(this.serializeRequestContent(transportRequest));
        }
        catch (Exception e) {
            this.log.error("Unable to parse current index settings source", (Throwable)e);
        }
        this.save(msg);
    }

    public void logIndexMappingsUpdated(List<String> indexNames, String action, TransportRequest transportRequest) {
        AuditMessage.Category category = AuditMessage.Category.INDEX_WRITE;
        UserInformation effectiveUser = this.getUser();
        if (!this.checkTransportFilter(category, action, effectiveUser, transportRequest)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.TRANSPORT);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(indexNames.toArray(new String[0]));
        msg.addComplianceOperation(AuditLog.Operation.UPDATE);
        try {
            msg.addUnescapedJsonToRequestBody(this.serializeRequestContent(transportRequest));
        }
        catch (Exception e) {
            this.log.error("Unable to parse current index mappings source", (Throwable)e);
        }
        this.save(msg);
    }

    public void logSucceededKibanaLogin(UserInformation effectiveUser) {
        AuditMessage.Category category = AuditMessage.Category.KIBANA_LOGIN;
        if (!this.checkRestFilter(category, effectiveUser, null)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    public void logSucceededKibanaLogout(UserInformation effectiveUser) {
        AuditMessage.Category category = AuditMessage.Category.KIBANA_LOGOUT;
        if (!this.checkRestFilter(category, effectiveUser, null)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterState, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    private AuditLog.Origin getOrigin() {
        String origin = (String)this.threadPool.getThreadContext().getTransient("_sg_origin");
        if (origin == null && this.threadPool.getThreadContext().getHeader("_sg_origin_header") != null) {
            origin = this.threadPool.getThreadContext().getHeader("_sg_origin_header");
        }
        return origin == null ? null : AuditLog.Origin.valueOf((String)origin);
    }

    private TransportAddress getRemoteAddress() {
        TransportAddress address = (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
        if (address == null && this.threadPool.getThreadContext().getHeader("_sg_remote_address_header") != null) {
            address = new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject((String)this.threadPool.getThreadContext().getHeader("_sg_remote_address_header")));
        }
        return address;
    }

    private UserInformation getUser() {
        User user = (User)this.threadPool.getThreadContext().getTransient("_sg_user");
        if (user == null && this.threadPool.getThreadContext().getHeader("_sg_user_header") != null) {
            user = (User)Base64Helper.deserializeObject((String)this.threadPool.getThreadContext().getHeader("_sg_user_header"));
        }
        return user;
    }

    private Map<String, String> getThreadContextHeaders() {
        return this.threadPool.getThreadContext().getHeaders();
    }

    private boolean checkTransportFilter(AuditMessage.Category category, String action, UserInformation effectiveUser, TransportRequest request) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check category:{}, action:{}, effectiveUser:{}, request:{}", (Object)category, (Object)action, (Object)effectiveUser, request == null ? null : request.getClass().getSimpleName());
        }
        if (!this.transportAuditingEnabled && category != AuditMessage.Category.FAILED_LOGIN && category != AuditMessage.Category.MISSING_PRIVILEGES && category != AuditMessage.Category.SG_INDEX_ATTEMPT) {
            return false;
        }
        if (action != null && (action.startsWith("internal:") || action.startsWith("cluster:monitor") || action.startsWith("indices:monitor"))) {
            return false;
        }
        if (effectiveUser != null && this.ignoredAuditUsers.matches(effectiveUser.getName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && (this.ignoreAuditRequests.matches(action) || this.ignoreAuditRequests.matches(request.getClass().getSimpleName()))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)(action + "#" + request.getClass().getSimpleName()));
            }
            return false;
        }
        if (!this.disabledTransportCategories.contains(category.toString())) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    private boolean checkComplianceFilter(AuditMessage.Category category, UserInformation effectiveUser, AuditLog.Origin origin) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check for COMPLIANCE category:{}, effectiveUser:{}, origin: {}", (Object)category, (Object)effectiveUser, (Object)origin);
        }
        if (origin == AuditLog.Origin.LOCAL && effectiveUser == null && category != AuditMessage.Category.COMPLIANCE_EXTERNAL_CONFIG) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of null user and local origin");
            }
            return false;
        }
        if ((category == AuditMessage.Category.COMPLIANCE_DOC_READ || category == AuditMessage.Category.COMPLIANCE_INTERNAL_CONFIG_READ) && effectiveUser != null && effectiveUser.getName() != null && this.ignoredComplianceUsersForRead.matches(effectiveUser.getName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if ((category == AuditMessage.Category.COMPLIANCE_DOC_WRITE || category == AuditMessage.Category.COMPLIANCE_INTERNAL_CONFIG_WRITE) && effectiveUser != null && effectiveUser.getName() != null && this.ignoredComplianceUsersForWrite.matches(effectiveUser.getName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        return true;
    }

    private boolean checkRestFilter(AuditMessage.Category category, UserInformation effectiveUser, RestRequest request) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check for REST category:{}, effectiveUser:{}, request:{}", (Object)category, (Object)effectiveUser, (Object)(request == null ? null : request.path()));
        }
        if (!this.restAuditingEnabled && category != AuditMessage.Category.FAILED_LOGIN && category != AuditMessage.Category.MISSING_PRIVILEGES && category != AuditMessage.Category.SG_INDEX_ATTEMPT) {
            return false;
        }
        if (effectiveUser != null && this.ignoredAuditUsers.matches(effectiveUser.getName())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && this.ignoreAuditRequests.matches(request.path())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)request.path());
            }
            return false;
        }
        if (!this.disabledRestCategories.contains(category.toString())) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    protected String serializeRequestContent(TransportRequest transportRequest) {
        if (transportRequest instanceof CreateIndexRequest) {
            return this.serializeRequestContent((CreateIndexRequest)transportRequest);
        }
        if (transportRequest instanceof UpdateSettingsRequest) {
            return this.serializeRequestContent((UpdateSettingsRequest)transportRequest);
        }
        if (transportRequest instanceof PutMappingRequest) {
            return this.serializeRequestContent((PutMappingRequest)transportRequest);
        }
        throw new IllegalArgumentException(String.format("Unexpected request type: %s", transportRequest.getClass().getName()));
    }

    private String serializeRequestContent(CreateIndexRequest request) {
        List aliases = request.aliases().stream().map(Utils::convertJsonToxToStructuredMap).collect(Collectors.toList());
        return DocNode.of((String)"index", (Object)request.index(), (String)"settings", Utils.convertJsonToxToStructuredMap((ToXContent)request.settings()), (String)"mappings", Utils.convertJsonToxToStructuredMap(request.mappings()), (String)"aliases", aliases, (String)"cause", (Object)request.cause(), (Object[])new Object[]{"origin", request.origin()}).toJsonString();
    }

    private String serializeRequestContent(UpdateSettingsRequest request) {
        return DocNode.of((String)"indices", (Object)request.indices(), (String)"settings", Utils.convertJsonToxToStructuredMap((ToXContent)request.settings()), (String)"preserve_existing", (Object)request.isPreserveExisting(), (String)"origin", (Object)request.origin()).toJsonString();
    }

    private String serializeRequestContent(PutMappingRequest request) {
        return DocNode.of((String)"indices", (Object)request.indices(), (String)"source", Utils.convertJsonToxToStructuredMap(request.source()), (String)"write_index_only", (Object)request.writeIndexOnly(), (String)"origin", (Object)request.origin()).toJsonString();
    }

    protected abstract void save(AuditMessage var1);
}

