/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.watch.search.SearchWatchAction;
import com.floragunn.signals.actions.watch.search.SearchWatchRequest;
import com.floragunn.signals.actions.watch.search.SearchWatchResponse;
import com.floragunn.signals.api.SignalsTenantAwareRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchWatchApiAction
extends SignalsTenantAwareRestHandler {
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public SearchWatchApiAction(Settings settings, Predicate<NodeFeature> clusterSupportsFeature) {
        super(settings);
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/watch/{tenant}/_search"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_signals/watch/{tenant}/_search"));
    }

    @Override
    protected final BaseRestHandler.RestChannelConsumer getRestChannelConsumer(RestRequest request, NodeClient client) throws IOException {
        String scroll = request.param("scroll");
        int from = request.paramAsInt("from", -1);
        int size = request.paramAsInt("size", -1);
        request.param("tenant");
        SearchWatchRequest searchWatchRequest = new SearchWatchRequest();
        if (scroll != null) {
            searchWatchRequest.setScroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll"));
        }
        searchWatchRequest.setFrom(from);
        searchWatchRequest.setSize(size);
        if (request.hasContent()) {
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().parseXContent(request.contentParser(), true, this.clusterSupportsFeature);
            searchWatchRequest.setSearchSourceBuilder(searchSourceBuilder);
        }
        return channel -> client.execute((ActionType)SearchWatchAction.INSTANCE, (ActionRequest)searchWatchRequest, (ActionListener)new RestToXContentListener(channel, SearchWatchResponse::status));
    }

    public String getName() {
        return "Search Watch Action";
    }
}

