/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class RestrictingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;

    public RestrictingSSLSocketFactory(SSLSocketFactory delegate, String[] enabledProtocols, String[] enabledCipherSuites) {
        this.delegate = delegate;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites == null ? this.delegate.getDefaultCipherSuites() : this.enabledCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites == null ? this.delegate.getSupportedCipherSuites() : this.enabledCipherSuites;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.enforce(this.delegate.createSocket());
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.enforce(this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enforce(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.enforce(this.delegate.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enforce(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enforce(this.delegate.createSocket(address, port, localAddress, localPort));
    }

    private Socket enforce(Socket socket) {
        if (socket != null && socket instanceof SSLSocket) {
            if (this.enabledProtocols != null) {
                ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
            }
            if (this.enabledCipherSuites != null) {
                ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCipherSuites);
            }
        }
        return socket;
    }
}

