/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgconf.history;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.sgconf.history.ConfigVersion;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ConfigVersionSet
implements Iterable<ConfigVersion>,
ToXContentObject,
Writeable,
Serializable {
    private static final long serialVersionUID = -1526475316346152188L;
    public static final ConfigVersionSet EMPTY = new Builder().build();
    private Map<CType<?>, ConfigVersion> versionMap;

    public static Builder with(CType<?> configurationType, long version) {
        return new Builder(configurationType, version);
    }

    public static ConfigVersionSet from(Map<CType<?>, SgDynamicConfiguration<?>> configByType) {
        Builder builder = new Builder();
        for (Map.Entry<CType<?>, SgDynamicConfiguration<?>> entry : configByType.entrySet()) {
            builder.add(entry.getKey(), entry.getValue().getDocVersion());
        }
        return builder.build();
    }

    public ConfigVersionSet(Map<CType<?>, ConfigVersion> versionMap) {
        this.versionMap = Collections.unmodifiableMap(versionMap);
    }

    public ConfigVersionSet(Collection<ConfigVersion> versions) {
        HashMap versionMap = new HashMap(versions.size());
        for (ConfigVersion version : versions) {
            versionMap.put(version.getConfigurationType(), version);
        }
        this.versionMap = Collections.unmodifiableMap(versionMap);
    }

    public ConfigVersionSet(StreamInput in) throws IOException {
        this(in.readCollectionAsList(ConfigVersion::new));
    }

    public ConfigVersion get(CType<?> configurationType) {
        return this.versionMap.get(configurationType);
    }

    @Override
    public Iterator<ConfigVersion> iterator() {
        return this.versionMap.values().iterator();
    }

    public int size() {
        return this.versionMap.size();
    }

    public int hashCode() {
        return this.versionMap.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ConfigVersionSet)) {
            return false;
        }
        return this.versionMap.equals(((ConfigVersionSet)other).versionMap);
    }

    public String toString() {
        return this.versionMap.values().toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (ConfigVersion configVersion : this) {
            configVersion.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public XContentBuilder toCompactXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ConfigVersion configVersion : this) {
            builder.field(configVersion.getConfigurationType().name(), configVersion.getVersion());
        }
        builder.endObject();
        return builder;
    }

    public static ConfigVersionSet parse(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        Builder builder = new Builder();
        if (jsonNode.isList()) {
            for (Object subNode : jsonNode.toList()) {
                try {
                    builder.add(ConfigVersion.parse(DocNode.wrap(subNode)));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("_", e);
                }
            }
        } else if (jsonNode.isMap()) {
            for (Map.Entry entry : jsonNode.toMap().entrySet()) {
                CType configType;
                String fieldName = (String)entry.getKey();
                try {
                    configType = CType.valueOf((String)fieldName);
                }
                catch (Exception e) {
                    validationErrors.add(new ValidationError(fieldName, "Not a valid config type: " + fieldName, null).cause((Throwable)e));
                    continue;
                }
                Object value = entry.getValue();
                if (!(value instanceof Number)) {
                    validationErrors.add((ValidationError)new InvalidAttributeValue(fieldName, value, (Object)"A version number"));
                    continue;
                }
                builder.add(configType, ((Number)value).longValue());
            }
        } else {
            validationErrors.add(new ValidationError(null, "Unexpected type " + String.valueOf(jsonNode)));
        }
        validationErrors.throwExceptionForPresentErrors();
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(new ArrayList<ConfigVersion>(this.versionMap.values()));
    }

    public static class Builder {
        private Map<CType<?>, ConfigVersion> versionMap = new HashMap();

        public Builder() {
        }

        private Builder(CType<?> configurationType, long version) {
            this.add(configurationType, version);
        }

        public Builder add(CType<?> configurationType, long version) {
            this.versionMap.put(configurationType, new ConfigVersion(configurationType, version));
            return this;
        }

        public Builder add(ConfigVersion configurationVersion) {
            this.versionMap.put(configurationVersion.getConfigurationType(), configurationVersion);
            return this;
        }

        public Builder and(CType<?> configurationType, long version) {
            this.add(configurationType, version);
            return this;
        }

        public ConfigVersionSet build() {
            return new ConfigVersionSet(this.versionMap);
        }
    }
}

