/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.diag;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class LogContextPreservingActionListener<R>
implements ActionListener<R> {
    private final ActionListener<R> delegate;
    private final Supplier<ThreadContext.StoredContext> context;
    private final Map<String, String> logThreadContextMap;

    public LogContextPreservingActionListener(Supplier<ThreadContext.StoredContext> contextSupplier, Map<String, String> logThreadContextMap, ActionListener<R> delegate) {
        this.delegate = delegate;
        this.context = contextSupplier;
        this.logThreadContextMap = logThreadContextMap;
    }

    public void onResponse(R r) {
        try (ThreadContext.StoredContext ignore = this.context.get();
             CloseableThreadContext.Instance ctc = CloseableThreadContext.putAll(this.logThreadContextMap);){
            this.delegate.onResponse(r);
        }
    }

    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.context.get();
             CloseableThreadContext.Instance ctc = CloseableThreadContext.putAll(this.logThreadContextMap);){
            this.delegate.onFailure(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.delegate.toString();
    }

    public static <R> LogContextPreservingActionListener<R> wrapPreservingContext(ActionListener<R> listener, org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        return new LogContextPreservingActionListener<R>(threadContext.newRestorableContext(true), ThreadContext.getImmutableContext(), listener);
    }
}

