/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.internal_users_db;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.UserInformationBackend;
import com.floragunn.searchguard.authc.internal_users_db.InternalUser;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersDatabase;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

public class InternalUsersAuthenticationBackend
implements AuthenticationBackend,
UserInformationBackend {
    public static final String TYPE = "internal_users_db";
    private final InternalUsersDatabase internalUsersDatabase;
    private final ComponentState componentState = new ComponentState(0, "authentication_backend", "internal_users_db").initialized();

    InternalUsersAuthenticationBackend(InternalUsersDatabase internalUsersDatabase) {
        this.internalUsersDatabase = internalUsersDatabase;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AuthCredentials> authenticate(AuthCredentials authCredentials, Meter meter) throws AuthenticatorUnavailableException, CredentialsException {
        InternalUser internalUser = this.internalUsersDatabase.get(authCredentials.getUsername());
        if (internalUser == null) {
            return CompletableFuture.completedFuture(null);
        }
        byte[] password = authCredentials.getPassword();
        if (password == null || password.length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (OpenBSDBCrypt.checkPassword((String)internalUser.getPasswordHash(), (char[])array)) {
                authCredentials = authCredentials.copy().backendRoles((Collection<String>)internalUser.getBackendRoles()).searchGuardRoles((Collection<String>)internalUser.getSearchGuardRoles()).userMappingAttribute("user_entry", internalUser.toRedactedBasicObject().with((Object)"name", (Object)authCredentials.getUsername())).authDomainInfo(authCredentials.getAuthDomainInfo().authBackendType(this.getType())).build();
                CompletableFuture<AuthCredentials> completableFuture = CompletableFuture.completedFuture(authCredentials);
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    @Override
    public CompletableFuture<AuthCredentials> getUserInformation(AuthCredentials authCredentials, Meter meter) throws AuthenticatorUnavailableException {
        InternalUser internalUser = this.internalUsersDatabase.get(authCredentials.getUsername());
        if (internalUser == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(authCredentials.copy().backendRoles((Collection<String>)internalUser.getBackendRoles()).searchGuardRoles((Collection<String>)internalUser.getSearchGuardRoles()).userMappingAttribute("user_entry", internalUser.toRedactedBasicObject().with((Object)"name", (Object)authCredentials.getUsername())).build());
    }

    @Override
    public ImmutableMap<String, String> describeAvailableUserMappingAttributes() {
        return ImmutableMap.of((Object)"user_entry", (Object)"The user entry from the internal users db");
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public static interface UserMappingAttributes {
        public static final String USER_ENTRY = "user_entry";
    }

    public static class UserInformationBackendInfo
    implements TypedComponent.Info<UserInformationBackend> {
        private final InternalUsersDatabase internalUsersDatabase;

        public UserInformationBackendInfo(InternalUsersDatabase internalUsersDatabase) {
            this.internalUsersDatabase = internalUsersDatabase;
        }

        @Override
        public Class<UserInformationBackend> getType() {
            return UserInformationBackend.class;
        }

        @Override
        public String getName() {
            return InternalUsersAuthenticationBackend.TYPE;
        }

        @Override
        public TypedComponent.Factory<UserInformationBackend> getFactory() {
            return (config, context) -> new InternalUsersAuthenticationBackend(this.internalUsersDatabase);
        }
    }

    public static class Info
    implements TypedComponent.Info<AuthenticationBackend> {
        private final InternalUsersDatabase internalUsersDatabase;

        public Info(InternalUsersDatabase internalUsersDatabase) {
            this.internalUsersDatabase = internalUsersDatabase;
        }

        @Override
        public Class<AuthenticationBackend> getType() {
            return AuthenticationBackend.class;
        }

        @Override
        public String getName() {
            return InternalUsersAuthenticationBackend.TYPE;
        }

        @Override
        public TypedComponent.Factory<AuthenticationBackend> getFactory() {
            return (config, context) -> new InternalUsersAuthenticationBackend(this.internalUsersDatabase);
        }
    }
}

