/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.legacy;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.NoSuchComponentException;
import com.floragunn.searchguard.TypedComponentRegistry;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticationFrontend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.legacy.LegacyAuthenticationBackend;
import com.floragunn.searchguard.authc.legacy.LegacyAuthorizationBackend;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.support.IPAddressCollection;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import inet.ipaddr.IPAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;

public class LegacyAuthenticationDomain<AuthenticatorType extends AuthenticationFrontend>
implements AuthenticationDomain<AuthenticatorType> {
    private static final Logger log = LogManager.getLogger(LegacyAuthenticationDomain.class);
    private final String id;
    private final LegacyAuthenticationBackend backend;
    private final AuthenticatorType authenticator;
    private final ImmutableList<LegacyAuthorizationBackend> authorizationBackends;
    private final int order;
    private final boolean challenge;
    private final Pattern skippedUsers;
    private final IPAddressCollection enabledOnlyForIps;
    private final String infoString;
    private final ComponentState componentState;

    public LegacyAuthenticationDomain(String id, LegacyAuthenticationBackend backend, AuthenticatorType authenticator, boolean challenge, int order, Pattern skippedUsers, IPAddressCollection enabledOnlyForIps, ImmutableList<LegacyAuthorizationBackend> authorizationBackends) {
        this.id = id;
        this.backend = backend;
        this.authenticator = authenticator;
        this.order = order;
        this.challenge = challenge;
        this.skippedUsers = skippedUsers;
        this.enabledOnlyForIps = enabledOnlyForIps;
        this.authorizationBackends = authorizationBackends;
        this.infoString = this.buildInfoString();
        this.componentState = new ComponentState(0, "legacy_auth_domain", id);
        if (authenticator != null) {
            this.componentState.addPart(authenticator.getComponentState());
        }
        this.componentState.updateStateFromParts();
    }

    public boolean isChallenge() {
        return this.challenge;
    }

    @Override
    public AuthenticatorType getFrontend() {
        return this.authenticator;
    }

    @Override
    public boolean accept(RequestMetaData<?> request) {
        IPAddress ipAddress = request.getOriginatingIpAddress();
        return this.enabledOnlyForIps == null || this.enabledOnlyForIps.contains(ipAddress);
    }

    @Override
    public boolean accept(AuthCredentials authCredentials) {
        return this.skippedUsers == null || !this.skippedUsers.matches(authCredentials.getName());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.infoString;
    }

    private String buildInfoString() {
        StringBuilder result = new StringBuilder();
        if (this.authenticator != null) {
            result.append(this.authenticator.getType());
        }
        if (this.backend != null) {
            result.append("/").append(this.backend.getType());
        }
        if (this.id != null) {
            result.append("[").append(this.id).append("]");
        }
        return result.toString();
    }

    public static Optional<AuthenticationDomain<HttpAuthenticationFrontend>> parseHttpDomain(String id, DocNode docNode, ConfigurationRepository.Context context, ImmutableList<LegacyAuthorizationBackend> authorizationBackends) throws ConfigValidationException {
        TypedComponentRegistry typedComponentRegistry = context.modulesRegistry().getTypedComponentRegistry();
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        boolean enabled = vNode.get("http_enabled").withDefault(false).asBoolean();
        if (!enabled) {
            return Optional.empty();
        }
        IPAddressCollection enabledOnlyForIps = (IPAddressCollection)vNode.get("enabled_only_for_ips").by(IPAddressCollection::parse);
        Pattern skipUsers = (Pattern)vNode.get("skip_users").by(Pattern::parse);
        String authenticatorType = vNode.get("http_authenticator.type").asString();
        int order = vNode.get("order").withDefault((Number)0).asInt();
        boolean challenge = vNode.get("challenge").withDefault(true).asBoolean();
        if (authenticatorType == null) {
            return Optional.empty();
        }
        String backendType = vNode.get("authentication_backend.type").withDefault("internal").asString();
        HttpAuthenticationFrontend httpAuthenticator = null;
        LegacyAuthenticationBackend authenticationBackend = null;
        try {
            httpAuthenticator = typedComponentRegistry.create(LegacyHTTPAuthenticator.class, authenticatorType, docNode.getAsNode("http_authenticator", new String[]{"config"}), context);
            if (httpAuthenticator == null) {
                throw new NoSuchComponentException(authenticatorType);
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("http_authenticator.config", e);
        }
        catch (NoSuchComponentException e) {
            validationErrors.add(new InvalidAttributeValue("http_authenticator.type", (Object)authenticatorType, (Object)e.getAvailableTypesAsInfoString()).message("Unknown HTTP authenticator").cause((Throwable)e));
        }
        catch (Exception e) {
            log.error("Unexpected exception while creating authenticator " + authenticatorType, (Throwable)e);
            validationErrors.add(new ValidationError("http_authenticator", e.getMessage()).cause((Throwable)e));
        }
        try {
            if ("intern".equals(backendType)) {
                backendType = "internal";
            }
            if ((authenticationBackend = typedComponentRegistry.create(LegacyAuthenticationBackend.class, backendType, docNode.getAsNode("authentication_backend", new String[]{"config"}), context)) == null) {
                throw new NoSuchComponentException(backendType);
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("authentication_backend.config", e);
        }
        catch (NoSuchComponentException e) {
            validationErrors.add(new InvalidAttributeValue("type", (Object)backendType, (Object)e.getAvailableTypesAsInfoString()).message("Unknown authentication backend").cause((Throwable)e));
        }
        catch (Exception e) {
            log.error("Unexpected exception while creating authentication backend " + backendType, (Throwable)e);
            validationErrors.add(new ValidationError("authentication_backend", e.getMessage()).cause((Throwable)e));
        }
        validationErrors.throwExceptionForPresentErrors();
        return Optional.of(new LegacyAuthenticationDomain<HttpAuthenticationFrontend>(id, authenticationBackend, httpAuthenticator, challenge, order, skipUsers, enabledOnlyForIps, authorizationBackends));
    }

    @Override
    public CompletableFuture<User> authenticate(AuthCredentials authCredentials, AuthenticationDebugLogger debug) throws AuthenticatorUnavailableException, CredentialsException {
        User user = this.backend.authenticate(authCredentials);
        if (user == null) {
            return CompletableFuture.completedFuture(null);
        }
        for (LegacyAuthorizationBackend authorizationBackend : this.authorizationBackends) {
            try {
                authorizationBackend.fillRoles(user, authCredentials);
            }
            catch (ElasticsearchSecurityException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Authz backend " + String.valueOf(authorizationBackend) + " did not find roles for " + String.valueOf(authCredentials), (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Error while retrieving roles for " + String.valueOf(authCredentials) + " from " + String.valueOf(authorizationBackend), (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(user);
    }

    @Override
    public CompletableFuture<User> impersonate(User originalUser, AuthCredentials authCredentials) throws AuthenticatorUnavailableException, CredentialsException {
        User user = AuthenticationBackend.UserMapper.DIRECT.map(authCredentials);
        if (!this.backend.exists(user)) {
            return CompletableFuture.completedFuture(null);
        }
        for (LegacyAuthorizationBackend authorizationBackend : this.authorizationBackends) {
            try {
                authorizationBackend.fillRoles(user, authCredentials);
            }
            catch (ElasticsearchSecurityException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Authz backend " + String.valueOf(authorizationBackend) + " did not find roles for " + String.valueOf(authCredentials), (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Error while retrieving roles for " + String.valueOf(authCredentials) + " from " + String.valueOf(authorizationBackend), (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(user);
    }

    @Override
    public String getType() {
        return this.toString();
    }

    @Override
    public boolean cacheUser() {
        switch (this.backend.userCachingPolicy()) {
            case ALWAYS: {
                return true;
            }
            case ONLY_IF_AUTHZ_SEPARATE: {
                return !this.authorizationBackends.isEmpty();
            }
        }
        return false;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

