/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.backend.InvalidTokenException;
import com.floragunn.searchguard.authc.session.backend.SessionService;
import com.floragunn.searchguard.authc.session.backend.SessionToken;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.util.concurrent.CompletableFuture;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.RestStatus;

public class SessionTokenAuthenticationDomain
implements AuthenticationDomain<HttpAuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(SessionTokenAuthenticationDomain.class);
    private final SessionService sessionService;
    private final SessionAuthenticator authenticator;
    private final ComponentState componentState = new ComponentState(0, "auth_domain", "session").initialized();
    private final TimeAggregation authenticationBackendMetrics = new TimeAggregation.Milliseconds();

    SessionTokenAuthenticationDomain(SessionService sessionService) {
        this.sessionService = sessionService;
        this.authenticator = new SessionAuthenticator(sessionService);
        this.componentState.addPart(this.authenticator.getComponentState());
        this.componentState.addMetrics("authentication_backend", (Measurement)this.authenticationBackendMetrics);
    }

    @Override
    public HttpAuthenticationFrontend getFrontend() {
        return this.authenticator;
    }

    @Override
    public String getId() {
        return "session";
    }

    @Override
    public boolean accept(RequestMetaData<?> request) {
        return true;
    }

    @Override
    public boolean accept(AuthCredentials authCredentials) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.sessionService.isEnabled();
    }

    @Override
    public String getType() {
        return "session";
    }

    @Override
    public CompletableFuture<User> authenticate(AuthCredentials credentials, AuthenticationDebugLogger debug) throws AuthenticatorUnavailableException, CredentialsException {
        Meter meter = Meter.basic((MetricsLevel)this.sessionService.getMetricsLevel(), (TimeAggregation)this.authenticationBackendMetrics);
        try {
            CompletableFuture<User> result = new CompletableFuture<User>();
            this.sessionService.getByClaims(credentials.getClaims(), sessionToken -> {
                if (sessionToken.isRevoked()) {
                    result.completeExceptionally(new ElasticsearchSecurityException("Session " + sessionToken.getId() + " has been expired or deleted", RestStatus.UNAUTHORIZED, new Object[0]));
                } else {
                    this.sessionService.checkExpiryAndTrackAccess((SessionToken)sessionToken, ok -> {
                        meter.close();
                        if (ok.booleanValue()) {
                            result.complete(User.forUser(sessionToken.getUserName()).type("session").backendRoles(sessionToken.getBase().getBackendRoles()).searchGuardRoles(sessionToken.getBase().getSearchGuardRoles()).specialAuthzConfig(sessionToken.getId()).attributes(sessionToken.getBase().getAttributes()).authzComplete().build());
                        } else {
                            result.completeExceptionally(new ElasticsearchSecurityException("Session " + sessionToken.getId() + " has been expired", RestStatus.UNAUTHORIZED, new Object[0]));
                        }
                    }, e -> {
                        meter.close();
                        result.completeExceptionally((Throwable)e);
                    }, meter);
                }
            }, noSuchAuthTokenException -> {
                meter.close();
                result.complete(null);
            }, e -> {
                meter.close();
                result.completeExceptionally((Throwable)e);
            }, meter);
            return result;
        }
        catch (InvalidTokenException e2) {
            log.info("Got InvalidTokenException for " + String.valueOf(credentials), (Throwable)e2);
            meter.close();
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public CompletableFuture<User> impersonate(User originalUser, AuthCredentials authCredentials) throws AuthenticatorUnavailableException, CredentialsException {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean cacheUser() {
        return false;
    }

    public String toString() {
        return "session";
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public static class SessionAuthenticator
    implements HttpAuthenticationFrontend {
        private final SessionService sessionService;
        private final String jwtHeaderName;
        private final String subjectKey;
        private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "session").initialized();

        public SessionAuthenticator(SessionService sessionService) {
            this.sessionService = sessionService;
            this.jwtHeaderName = "Authorization";
            this.subjectKey = "sub";
        }

        @Override
        public String getType() {
            return "session";
        }

        @Override
        public AuthCredentials extractCredentials(RequestMetaData<?> request) throws CredentialsException {
            String encodedJwt = request.getAuthorizationByScheme(this.jwtHeaderName, "bearer");
            if (Strings.isNullOrEmpty((String)encodedJwt)) {
                return null;
            }
            try {
                JwtToken jwt = this.sessionService.getVerifiedJwtToken(encodedJwt);
                if (jwt == null) {
                    return null;
                }
                JwtClaims claims = jwt.getClaims();
                String subject = this.extractSubject(claims);
                if (subject == null) {
                    log.error("No subject found in JWT token: " + String.valueOf(claims));
                    return null;
                }
                return AuthCredentials.forUser(subject).claims(claims.asMap()).complete().build();
            }
            catch (JwtException e) {
                log.info("JWT is invalid (" + this.getType() + ")", (Throwable)e);
                throw new CredentialsException("JWT is invalid", (Throwable)e);
            }
        }

        protected String extractSubject(JwtClaims claims) {
            String subject = claims.getSubject();
            if (this.subjectKey != null) {
                Object subjectObject = claims.getClaim(this.subjectKey);
                if (subjectObject == null) {
                    log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                    return null;
                }
                if (!(subjectObject instanceof String)) {
                    log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
                    subject = String.valueOf(subjectObject);
                } else {
                    subject = (String)subjectObject;
                }
            }
            return subject;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

