/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.config.AuthorizationConfig;
import com.floragunn.searchguard.authz.config.RoleMapping;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.transport.TransportAddress;

public class AuthorizationService
implements ComponentStateProvider {
    public static final StaticSettings.Attribute<String> ROLES_MAPPING_RESOLUTION = StaticSettings.Attribute.define((String)"searchguard.roles_mapping_resolution").withDefault(RoleMapping.ResolutionMode.MAPPING_ONLY.toString()).asString();
    public static final StaticSettings.AttributeSet STATIC_SETTINGS = StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{ROLES_MAPPING_RESOLUTION});
    private static final Logger log = LogManager.getLogger(AuthorizationService.class);
    private final AuthInfoService authInfoService;
    private final ComponentState componentState = new ComponentState(9, null, "authorization_service");
    private volatile AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
    private volatile RoleMapping.InvertedIndex roleMapping;

    public AuthorizationService(ConfigurationRepository configurationRepository, final StaticSettings settings, AuthInfoService authInfoService) {
        this.authInfoService = authInfoService;
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<AuthorizationConfig> config = configMap.get(CType.AUTHZ);
                SgDynamicConfiguration<LegacySgConfig> legacyConfig = configMap.get(CType.CONFIG);
                AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
                if (config != null && config.getCEntry("default") != null) {
                    AuthorizationService.this.authzConfig = authzConfig = config.getCEntry("default");
                    log.info("Updated authz config:\n" + String.valueOf(config));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)authzConfig);
                    }
                } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                    try {
                        LegacySgConfig sgConfig = legacyConfig.getCEntry("sg_config");
                        AuthorizationService.this.authzConfig = authzConfig = AuthorizationConfig.parseLegacySgConfig(sgConfig.getSource(), null, settings);
                        log.info("Updated authz config (legacy):\n" + String.valueOf(legacyConfig));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)authzConfig);
                        }
                    }
                    catch (ConfigValidationException e) {
                        log.error("Error while parsing sg_config:\n" + String.valueOf((Object)e));
                    }
                }
                AuthorizationService.this.roleMapping = new RoleMapping.InvertedIndex(configMap.get(CType.ROLESMAPPING), authzConfig.getMetricsLevel());
                AuthorizationService.this.componentState.setConfigVersion(configMap.getVersionsAsString());
                AuthorizationService.this.componentState.replacePart(AuthorizationService.this.roleMapping.getComponentState());
                AuthorizationService.this.componentState.updateStateFromParts();
            }
        });
    }

    public boolean isInitialized() {
        return this.roleMapping != null;
    }

    public ImmutableSet<String> getMappedRoles(User user, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext) {
        if (this.roleMapping == null) {
            return ImmutableSet.empty();
        }
        if (specialPrivilegesEvaluationContext == null) {
            return this.getMappedRoles(user, this.authInfoService.getCurrentRemoteAddress());
        }
        return specialPrivilegesEvaluationContext.getMappedRoles();
    }

    public ImmutableSet<String> getMappedRoles(User user, TransportAddress caller) {
        if (this.roleMapping == null) {
            throw new RuntimeException("SearchGuard is not yet initialized");
        }
        return this.roleMapping.evaluate(user, caller, this.authzConfig.getRoleMappingResolution());
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public RoleMapping.InvertedIndex getRoleMapping() {
        return this.roleMapping;
    }
}

