/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.config;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticDefinable;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Count;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionGroup
implements Document<ActionGroup>,
Hideable,
StaticDefinable {
    private final DocNode source;
    private final boolean reserved;
    private final boolean hidden;
    private final boolean isStatic;
    private final String description;
    private final String type;
    private final ImmutableList<String> allowedActions;

    public static ValidationResult<ActionGroup> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        boolean reserved = vNode.get("reserved").withDefault(false).asBoolean();
        boolean hidden = vNode.get("hidden").withDefault(false).asBoolean();
        boolean isStatic = vNode.get("static").withDefault(false).asBoolean();
        String description = vNode.get("description").asString();
        String type = vNode.get("type").asString();
        ImmutableList allowedActions = ImmutableList.of((Collection)vNode.get("allowed_actions").required().asListOfStrings());
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new ActionGroup(docNode, reserved, hidden, isStatic, description, type, (ImmutableList<String>)allowedActions), validationErrors);
    }

    public ActionGroup(DocNode source, boolean reserved, boolean hidden, boolean isStatic, String description, String type, ImmutableList<String> allowedActions) {
        this.source = source;
        this.reserved = reserved;
        this.hidden = hidden;
        this.isStatic = isStatic;
        this.description = description;
        this.type = type;
        this.allowedActions = allowedActions;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public ImmutableList<String> getAllowedActions() {
        return this.allowedActions;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public static class FlattenedIndex
    implements ComponentStateProvider {
        public static final FlattenedIndex EMPTY = new FlattenedIndex();
        private static final Logger log = LogManager.getLogger(FlattenedIndex.class);
        private final ImmutableMap<String, Set<String>> resolvedActionGroups;
        private final ComponentState componentState = new ComponentState("action_group_index");
        private final Count size = new Count();
        private final Count initRounds = new Count();

        public FlattenedIndex(SgDynamicConfiguration<ActionGroup> actionGroups) {
            boolean tooDeep = false;
            HashMap<String, Set> resolved = new HashMap<String, Set>(actionGroups.getCEntries().size());
            HashMap<String, Set> needsResolution = new HashMap<String, Set>(actionGroups.getCEntries().size());
            for (Map.Entry entry : actionGroups.getCEntries().entrySet()) {
                String key = (String)entry.getKey();
                Set actions = resolved.computeIfAbsent(key, k -> new HashSet());
                for (String action : ((ActionGroup)entry.getValue()).getAllowedActions()) {
                    actions.add(action);
                    if (!actionGroups.getCEntries().containsKey((Object)action) || action.equals(key)) continue;
                    needsResolution.computeIfAbsent(key, k -> new HashSet()).add(action);
                }
            }
            boolean settled = false;
            int i = 0;
            while (!settled) {
                boolean changed = false;
                for (Map.Entry entry : needsResolution.entrySet()) {
                    String key = (String)entry.getKey();
                    Set resolvedActions = (Set)resolved.get(key);
                    for (String action : (Set)entry.getValue()) {
                        Set mappedActions = (Set)resolved.get(action);
                        changed |= resolvedActions.addAll(mappedActions);
                    }
                }
                if (!changed) {
                    settled = true;
                    this.initRounds.set((long)i);
                    if (log.isDebugEnabled()) {
                        log.debug("Action groups settled after " + i + " loops.\nResolved: " + String.valueOf(resolved));
                    }
                }
                if (i >= 1000) {
                    this.initRounds.set((long)i);
                    log.error("Found too deeply nested action groups. Aborting resolution.\nResolved so far: " + String.valueOf(resolved));
                    tooDeep = true;
                    break;
                }
                ++i;
            }
            this.resolvedActionGroups = ImmutableMap.of(resolved);
            this.size.set((long)this.resolvedActionGroups.size());
            this.componentState.addMetrics("size", (Measurement)this.size, "init_rounds", (Measurement)this.initRounds);
            if (tooDeep) {
                this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "too_deply_nested_action_groups");
                this.componentState.setMessage("Found too deeply nested action groups. Action groups are not fully initialized.");
            } else {
                this.componentState.initialized();
            }
        }

        private FlattenedIndex() {
            this.resolvedActionGroups = ImmutableMap.empty();
        }

        public String toString() {
            return this.resolvedActionGroups.toString();
        }

        public ImmutableSet<String> resolve(Collection<String> actions) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (String action : actions) {
                if (action == null) continue;
                result.add((Object)action);
                Set mappedActions = (Set)this.resolvedActionGroups.get((Object)action);
                if (mappedActions == null) continue;
                result.addAll((Collection)mappedActions);
            }
            return result.build();
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

