/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.config;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.StaticDefinable;
import com.floragunn.searchsupport.queries.Query;
import com.floragunn.searchsupport.xcontent.XContentParserContext;
import com.google.common.base.Splitter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Role
implements Document<Role>,
Hideable,
StaticDefinable {
    private static final Logger log = LogManager.getLogger(Role.class);
    private final DocNode source;
    private final boolean reserved;
    private final boolean hidden;
    private final boolean isStatic;
    private final String description;
    private final ImmutableList<String> clusterPermissions;
    private final ImmutableList<Index> indexPermissions;
    private final ImmutableList<Alias> aliasPermissions;
    private final ImmutableList<DataStream> dataStreamPermissions;
    private final ImmutableList<Tenant> tenantPermissions;
    private final ImmutableList<String> excludeClusterPermissions;

    public static ValidationResult<Role> parse(DocNode docNode, ConfigurationRepository.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, (Parser.Context)context);
        boolean reserved = vNode.get("reserved").withDefault(false).asBoolean();
        boolean hidden = vNode.get("hidden").withDefault(false).asBoolean();
        boolean isStatic = vNode.get("static").withDefault(false).asBoolean();
        vNode.get("cluster_permissions").by(com.floragunn.codova.config.text.Pattern::parse);
        vNode.get("exclude_cluster_permissions").by(com.floragunn.codova.config.text.Pattern::parse);
        ImmutableList clusterPermissions = vNode.get("cluster_permissions").asList().withEmptyListAsDefault().ofStrings();
        ImmutableList excludeClusterPermissions = vNode.get("exclude_cluster_permissions").asList().withEmptyListAsDefault().ofStrings();
        ImmutableList indexPermissions = vNode.get("index_permissions").asList().withEmptyListAsDefault().ofObjectsParsedBy(Index::new);
        ImmutableList aliasPermissions = vNode.get("alias_permissions").asList().withEmptyListAsDefault().ofObjectsParsedBy(Alias::new);
        ImmutableList dataStreamPermissions = vNode.get("data_stream_permissions").asList().withEmptyListAsDefault().ofObjectsParsedBy(DataStream::new);
        ImmutableList tenantPermissions = vNode.get("tenant_permissions").asList().withEmptyListAsDefault().ofObjectsParsedBy(Tenant::new);
        ImmutableList excludeIndexPermissions = vNode.get("exclude_index_permissions").asList().withEmptyListAsDefault().ofStrings();
        if (excludeIndexPermissions != null && !excludeIndexPermissions.isEmpty()) {
            if (context != null && context.isLenientValidationRequested()) {
                log.error("exclude_index_permissions in sg_roles is no longer supported");
            } else {
                validationErrors.add(new ValidationError("exclude_index_permissions", "This attribute is no longer supported"));
            }
        }
        String description = vNode.get("description").asString();
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new Role(docNode, reserved, hidden, isStatic, description, (ImmutableList<String>)clusterPermissions, (ImmutableList<Index>)indexPermissions, (ImmutableList<Alias>)aliasPermissions, (ImmutableList<DataStream>)dataStreamPermissions, (ImmutableList<Tenant>)tenantPermissions, (ImmutableList<String>)excludeClusterPermissions), validationErrors);
    }

    public Role(DocNode source, boolean reserved, boolean hidden, boolean isStatic, String description, ImmutableList<String> clusterPermissions, ImmutableList<Index> indexPermissions, ImmutableList<Alias> aliasPermissions, ImmutableList<DataStream> dataStreamPermissions, ImmutableList<Tenant> tenantPermissions, ImmutableList<String> excludeClusterPermissions) {
        this.source = source;
        this.reserved = reserved;
        this.isStatic = isStatic;
        this.hidden = hidden;
        this.description = description;
        this.clusterPermissions = clusterPermissions;
        this.indexPermissions = indexPermissions;
        this.aliasPermissions = aliasPermissions;
        this.dataStreamPermissions = dataStreamPermissions;
        this.tenantPermissions = tenantPermissions;
        this.excludeClusterPermissions = excludeClusterPermissions;
    }

    public Object toBasicObject() {
        return this.source;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public ImmutableList<String> getClusterPermissions() {
        return this.clusterPermissions;
    }

    public ImmutableList<String> getExcludeClusterPermissions() {
        return this.excludeClusterPermissions;
    }

    public ImmutableList<Index> getIndexPermissions() {
        return this.indexPermissions;
    }

    public ImmutableList<Tenant> getTenantPermissions() {
        return this.tenantPermissions;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public ImmutableList<Alias> getAliasPermissions() {
        return this.aliasPermissions;
    }

    public ImmutableList<DataStream> getDataStreamPermissions() {
        return this.dataStreamPermissions;
    }

    public static class IndexPatterns {
        private final com.floragunn.codova.config.text.Pattern pattern;
        private final ImmutableList<IndexPatternTemplate> patternTemplates;
        private final ImmutableList<DateMathExpression> dateMathExpressions;
        private final String asString;

        IndexPatterns(com.floragunn.codova.config.text.Pattern pattern, ImmutableList<IndexPatternTemplate> patternTemplates, ImmutableList<DateMathExpression> dateMathExpressions) {
            this.pattern = pattern;
            this.patternTemplates = patternTemplates;
            this.dateMathExpressions = dateMathExpressions;
            StringBuilder asString = new StringBuilder();
            if (pattern != null && !pattern.isBlank()) {
                asString.append(pattern);
            }
            if (patternTemplates != null && !patternTemplates.isEmpty()) {
                if (asString.length() != 0) {
                    asString.append(" ");
                }
                asString.append(patternTemplates);
            }
            if (dateMathExpressions != null && !dateMathExpressions.isEmpty()) {
                if (asString.length() != 0) {
                    asString.append(" ");
                }
                asString.append(dateMathExpressions);
            }
            if (asString.length() == 0) {
                asString.append("-/-");
            }
            this.asString = asString.toString();
        }

        public com.floragunn.codova.config.text.Pattern getPattern() {
            return this.pattern;
        }

        public ImmutableList<IndexPatternTemplate> getPatternTemplates() {
            return this.patternTemplates;
        }

        public ImmutableList<DateMathExpression> getDateMathExpressions() {
            return this.dateMathExpressions;
        }

        public String toString() {
            return this.asString;
        }

        public static class DateMathExpression {
            private final String dateMathExpression;
            private final com.floragunn.codova.config.text.Pattern exclusions;

            DateMathExpression(String dateMathExpression, com.floragunn.codova.config.text.Pattern exclusions) {
                this.dateMathExpression = dateMathExpression;
                this.exclusions = exclusions;
            }

            public String getDateMathExpression() {
                return this.dateMathExpression;
            }

            public com.floragunn.codova.config.text.Pattern getExclusions() {
                return this.exclusions;
            }

            public String toString() {
                if (this.exclusions.isBlank()) {
                    return this.dateMathExpression.toString();
                }
                return this.dateMathExpression + " -" + String.valueOf(this.exclusions);
            }
        }

        public static class IndexPatternTemplate {
            private final Template<com.floragunn.codova.config.text.Pattern> template;
            private final com.floragunn.codova.config.text.Pattern exclusions;

            IndexPatternTemplate(Template<com.floragunn.codova.config.text.Pattern> template, com.floragunn.codova.config.text.Pattern exclusions) {
                this.template = template;
                this.exclusions = exclusions;
            }

            public Template<com.floragunn.codova.config.text.Pattern> getTemplate() {
                return this.template;
            }

            public com.floragunn.codova.config.text.Pattern getExclusions() {
                return this.exclusions;
            }

            public String toString() {
                if (this.exclusions.isBlank()) {
                    return this.template.toString();
                }
                return String.valueOf(this.template) + " -" + String.valueOf(this.exclusions);
            }
        }

        static class Builder {
            private final ImmutableList<Template<String>> source;
            private List<String> constantPatterns = new ArrayList<String>();
            private List<IndexPatternTemplate> patternTemplates = new ArrayList<IndexPatternTemplate>();
            private List<DateMathExpression> dateMathExpressions = new ArrayList<DateMathExpression>();
            private Map<Integer, com.floragunn.codova.config.text.Pattern> negations = new HashMap<Integer, com.floragunn.codova.config.text.Pattern>();

            Builder(ImmutableList<Template<String>> source) {
                this.source = source;
            }

            IndexPatterns build() throws ConfigValidationException {
                ValidationErrors validationErrors = new ValidationErrors();
                for (int i = 0; i < this.source.size(); ++i) {
                    try {
                        Template indexPattern = (Template)this.source.get(i);
                        if (indexPattern.getSource().startsWith("<") && indexPattern.getSource().endsWith(">")) {
                            this.dateMathExpressions.add(new DateMathExpression(indexPattern.getSource(), this.getExclusions(i + 1)));
                            continue;
                        }
                        if (indexPattern.isConstant()) {
                            this.constantPatterns.add((String)indexPattern.getConstantValue());
                            continue;
                        }
                        this.patternTemplates.add(new IndexPatternTemplate((Template<com.floragunn.codova.config.text.Pattern>)indexPattern.parser(com.floragunn.codova.config.text.Pattern::create), this.getExclusions(i + 1)));
                        continue;
                    }
                    catch (ConfigValidationException e) {
                        validationErrors.add(String.valueOf(i), e);
                    }
                }
                validationErrors.throwExceptionForPresentErrors();
                return new IndexPatterns(com.floragunn.codova.config.text.Pattern.create(this.removeLeadingNegations(this.constantPatterns)), (ImmutableList<IndexPatternTemplate>)ImmutableList.of(this.patternTemplates), (ImmutableList<DateMathExpression>)ImmutableList.of(this.dateMathExpressions));
            }

            private List<String> removeLeadingNegations(List<String> patterns) {
                if (patterns.isEmpty()) {
                    return patterns;
                }
                if (!patterns.get(0).startsWith("-")) {
                    return patterns;
                }
                int firstNonNegated = -1;
                for (int i = 1; i < patterns.size(); ++i) {
                    if (patterns.get(i).startsWith("-")) continue;
                    firstNonNegated = i;
                    break;
                }
                if (firstNonNegated != -1) {
                    return patterns.subList(firstNonNegated, patterns.size());
                }
                return ImmutableList.empty();
            }

            private com.floragunn.codova.config.text.Pattern getExclusions(int start) {
                if (start >= this.source.size()) {
                    return com.floragunn.codova.config.text.Pattern.blank();
                }
                int firstNegation = this.findFirstNegation(start);
                if (firstNegation == -1) {
                    return com.floragunn.codova.config.text.Pattern.blank();
                }
                com.floragunn.codova.config.text.Pattern negation = this.negations.get(firstNegation);
                if (negation != null) {
                    return negation;
                }
                ArrayList<String> negations = new ArrayList<String>(this.source.size());
                for (int i = firstNegation; i < this.source.size(); ++i) {
                    Template pattern = (Template)this.source.get(i);
                    if (!pattern.isConstant() || !((String)pattern.getConstantValue()).startsWith("-")) continue;
                    negations.add(((String)pattern.getConstantValue()).substring(1));
                }
                negation = com.floragunn.codova.config.text.Pattern.createUnchecked(negations);
                this.negations.put(firstNegation, negation);
                return negation;
            }

            private int findFirstNegation(int start) {
                for (int i = start; i < this.source.size(); ++i) {
                    Template pattern = (Template)this.source.get(i);
                    if (!pattern.isConstant() || !((String)pattern.getConstantValue()).startsWith("-")) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    public static class Tenant {
        private final ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> tenantPatterns;
        private final ImmutableList<String> allowedActions;

        public Tenant(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            vNode.get("allowed_actions").by(com.floragunn.codova.config.text.Pattern::parse);
            this.tenantPatterns = ImmutableList.of((Collection)vNode.get("tenant_patterns").asList().withEmptyListAsDefault().ofTemplates(com.floragunn.codova.config.text.Pattern::create));
            this.allowedActions = ImmutableList.of((Collection)vNode.get("allowed_actions").asList().withEmptyListAsDefault().ofStrings());
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
        }

        public Tenant(ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> tenantPatterns, ImmutableList<String> allowedActions) {
            this.tenantPatterns = tenantPatterns;
            this.allowedActions = allowedActions;
        }

        public ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> getTenantPatterns() {
            return this.tenantPatterns;
        }

        public ImmutableList<String> getAllowedActions() {
            return this.allowedActions;
        }
    }

    public static class DataStream
    extends Index {
        DataStream(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            super(docNode, context);
        }

        public DataStream(ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> dataStreamPatterns, Template<Query> dls, ImmutableList<Index.FlsPattern> fls, ImmutableList<Index.FieldMaskingExpression> maskedFields, ImmutableList<String> allowedActions) {
            super(dataStreamPatterns, dls, fls, maskedFields, allowedActions);
        }

        @Override
        protected String getPatternAttributeName() {
            return "data_stream_patterns";
        }
    }

    public static class Alias
    extends Index {
        Alias(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            super(docNode, context);
        }

        public Alias(ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> aliasPatterns, Template<Query> dls, ImmutableList<Index.FlsPattern> fls, ImmutableList<Index.FieldMaskingExpression> maskedFields, ImmutableList<String> allowedActions) {
            super(aliasPatterns, dls, fls, maskedFields, allowedActions);
        }

        @Override
        protected String getPatternAttributeName() {
            return "alias_patterns";
        }
    }

    public static class Index {
        private final IndexPatterns indexPatterns;
        private final Template<Query> dls;
        private final ImmutableList<FlsPattern> fls;
        private final ImmutableList<FieldMaskingExpression> maskedFields;
        private final ImmutableList<String> allowedActions;
        private final ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> legacyIndexPatterns;

        Index(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            this.dls = vNode.get("dls").asTemplate(s -> new Query(s, (XContentParserContext)context));
            this.fls = vNode.get("fls").asList().ofObjectsParsedByString(FlsPattern::new);
            this.maskedFields = vNode.get("masked_fields").asList().withEmptyListAsDefault().ofObjectsParsedByString(FieldMaskingExpression::new);
            vNode.get("allowed_actions").by(com.floragunn.codova.config.text.Pattern::parse);
            this.legacyIndexPatterns = vNode.get(this.getPatternAttributeName()).asList().ofTemplates(com.floragunn.codova.config.text.Pattern::create);
            this.allowedActions = ImmutableList.of((Collection)vNode.get("allowed_actions").asList().withEmptyListAsDefault().ofStrings());
            ImmutableList indexPatterns = ImmutableList.of((Collection)vNode.get(this.getPatternAttributeName()).asList().withEmptyListAsDefault().ofTemplates());
            this.indexPatterns = new IndexPatterns.Builder((ImmutableList<Template<String>>)indexPatterns).build();
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
        }

        public Index(ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> indexPatterns, Template<Query> dls, ImmutableList<FlsPattern> fls, ImmutableList<FieldMaskingExpression> maskedFields, ImmutableList<String> allowedActions) {
            try {
                this.indexPatterns = new IndexPatterns.Builder((ImmutableList<Template<String>>)indexPatterns.map(t -> t.toStringTemplate())).build();
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException(e);
            }
            this.legacyIndexPatterns = indexPatterns;
            this.dls = dls;
            this.fls = fls;
            this.maskedFields = maskedFields;
            this.allowedActions = allowedActions;
        }

        public IndexPatterns getIndexPatterns() {
            return this.indexPatterns;
        }

        public ImmutableList<Template<com.floragunn.codova.config.text.Pattern>> getLegacyIndexPatterns() {
            return this.legacyIndexPatterns;
        }

        public Template<Query> getDls() {
            return this.dls;
        }

        public ImmutableList<FlsPattern> getFls() {
            return this.fls;
        }

        public ImmutableList<FieldMaskingExpression> getMaskedFields() {
            return this.maskedFields;
        }

        public ImmutableList<String> getAllowedActions() {
            return this.allowedActions;
        }

        protected String getPatternAttributeName() {
            return "index_patterns";
        }

        public static class FieldMaskingExpression {
            public static final FieldMaskingExpression MASK_ALL = new FieldMaskingExpression(com.floragunn.codova.config.text.Pattern.wildcard(), "*");
            private final com.floragunn.codova.config.text.Pattern pattern;
            private final String algo;
            private final List<RegexReplacement> regexReplacements;
            private final String source;

            public FieldMaskingExpression(String value) throws ConfigValidationException {
                this.source = value;
                List tokens = Splitter.on((String)"::").splitToList((CharSequence)value);
                this.pattern = com.floragunn.codova.config.text.Pattern.create((String)((String)tokens.get(0)));
                if (tokens.size() == 1) {
                    this.algo = null;
                    this.regexReplacements = null;
                } else if (tokens.size() == 2) {
                    this.regexReplacements = null;
                    try {
                        String algorithm = (String)tokens.get(1);
                        MessageDigest.getInstance(algorithm);
                        this.algo = algorithm;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new ConfigValidationException(new ValidationError(null, "Invalid algorithm " + (String)tokens.get(1)));
                    }
                } else {
                    this.algo = null;
                    this.regexReplacements = new ArrayList<RegexReplacement>((tokens.size() - 1) / 2);
                    for (int i = 1; i < tokens.size() - 1; i += 2) {
                        this.regexReplacements.add(new RegexReplacement((String)tokens.get(i), (String)tokens.get(i + 1)));
                    }
                }
            }

            private FieldMaskingExpression(com.floragunn.codova.config.text.Pattern pattern, String source) {
                this.pattern = pattern;
                this.source = source;
                this.algo = null;
                this.regexReplacements = null;
            }

            public String toString() {
                return this.source;
            }

            public MessageDigest getAlgo() {
                try {
                    if (this.algo == null) {
                        return null;
                    }
                    return MessageDigest.getInstance(this.algo);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Algorithm " + this.algo + " has been already validated", e);
                }
            }

            public List<RegexReplacement> getRegexReplacements() {
                return this.regexReplacements;
            }

            public com.floragunn.codova.config.text.Pattern getPattern() {
                return this.pattern;
            }

            public String getSource() {
                return this.source;
            }

            public static class RegexReplacement {
                private final Pattern regex;
                private final String replacement;

                public RegexReplacement(String regex, String replacement) throws ConfigValidationException {
                    if (!regex.startsWith("/") || !regex.endsWith("/")) {
                        throw new ConfigValidationException(new ValidationError(null, "A regular expression needs to be wrapped in /.../"));
                    }
                    try {
                        this.regex = Pattern.compile(regex.substring(1).substring(0, regex.length() - 2));
                    }
                    catch (PatternSyntaxException e) {
                        throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
                    }
                    this.replacement = replacement;
                }

                public Pattern getRegex() {
                    return this.regex;
                }

                public String getReplacement() {
                    return this.replacement;
                }

                public String toString() {
                    return "RegexReplacement [regex=" + String.valueOf(this.regex) + ", replacement=" + this.replacement + "]";
                }
            }
        }

        public static class FlsPattern {
            public static final FlsPattern INCLUDE_ALL = new FlsPattern(com.floragunn.codova.config.text.Pattern.wildcard(), false, "*");
            public static final FlsPattern EXCLUDE_ALL = new FlsPattern(com.floragunn.codova.config.text.Pattern.wildcard(), true, "~*");
            private final boolean excluded;
            private final com.floragunn.codova.config.text.Pattern pattern;
            private final String source;

            public FlsPattern(String string) throws ConfigValidationException {
                if (string.startsWith("~") || string.startsWith("!")) {
                    this.excluded = true;
                    this.pattern = com.floragunn.codova.config.text.Pattern.create((String)string.substring(1));
                } else {
                    this.pattern = com.floragunn.codova.config.text.Pattern.create((String)string);
                    this.excluded = false;
                }
                this.source = string;
            }

            FlsPattern(com.floragunn.codova.config.text.Pattern pattern, boolean excluded, String source) {
                this.pattern = pattern;
                this.excluded = excluded;
                this.source = source;
            }

            public String getSource() {
                return this.source;
            }

            public com.floragunn.codova.config.text.Pattern getPattern() {
                return this.pattern;
            }

            public boolean isExcluded() {
                return this.excluded;
            }

            public String toString() {
                return this.source;
            }
        }
    }
}

